/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.item;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import org.joml.Matrix4f;
import stepsword.mahoutsukai.datacomponents.DataComponents;
import stepsword.mahoutsukai.datacomponents.fiction.FictionMahou;
import stepsword.mahoutsukai.render.IEntityAwareRenderer;
import stepsword.mahoutsukai.render.MahoujinRenderType;
import stepsword.mahoutsukai.render.Point;
import stepsword.mahoutsukai.render.RenderUtils;
import stepsword.mahoutsukai.render.entity.RenderWilliamEntity;
import stepsword.mahoutsukai.render.item.BookRender;
import stepsword.mahoutsukai.render.item.RuleBreakerRenderer;
import stepsword.mahoutsukai.util.Utils;

public class WilliamRenderer
extends BlockEntityWithoutLevelRenderer
implements IClientItemExtensions,
IEntityAwareRenderer {
    public static float[] william_cover = new float[]{0.76862746f, 0.6666667f, 0.58431375f, 1.0f};
    public static float[] william_pages = new float[]{0.27058825f, 0.019607844f, 0.67058825f, 1.0f};
    public static float[] william_text = new float[]{0.39215687f, 0.19215687f, 0.70980394f, 1.0f};
    public static float[] william_circle = new float[]{0.6784314f, 0.47843137f, 1.0f, 1.0f};
    public static float[] rlyeh_cover = new float[]{0.0f, 0.2f, 0.25f, 1.0f};
    public static float[] rlyeh_pages = new float[]{0.3529412f, 0.3529412f, 0.3529412f, 1.0f};
    public static float[] rlyeh_text = new float[]{0.39215687f, 1.0f, 1.0f, 1.0f};
    public static float[] rlyeh_circle = new float[]{0.39215687f, 1.0f, 1.0f, 1.0f};

    public WilliamRenderer(BlockEntityRenderDispatcher p_172550_, EntityModelSet p_172551_) {
        super(p_172550_, p_172551_);
    }

    public void renderByItem(ItemStack stack, ItemDisplayContext transform, PoseStack matrix, MultiBufferSource buffer, int var1, int var2) {
        if (transform == ItemDisplayContext.GUI || transform == ItemDisplayContext.GROUND || transform == ItemDisplayContext.HEAD || transform == ItemDisplayContext.FIXED || transform == ItemDisplayContext.NONE) {
            this.render(null, stack, transform, matrix, buffer, var1, var2);
        }
    }

    @Override
    public void render(LivingEntity entity, ItemStack stack, ItemDisplayContext transform, PoseStack matrix, MultiBufferSource buffer, int var1, int var2) {
        matrix.pushPose();
        double x = 0.0;
        double y = 1.0;
        double z = 0.5;
        float xr = 90.0f;
        float yr = 45.0f;
        float zr = 0.0f;
        float size = 0.4f;
        if (transform.equals((Object)ItemDisplayContext.THIRD_PERSON_RIGHT_HAND)) {
            x = 0.5;
            y = 0.65;
            z = 0.5;
            xr = 180.0f;
            yr = 0.0f;
            zr = 0.0f;
        }
        if (transform.equals((Object)ItemDisplayContext.THIRD_PERSON_LEFT_HAND)) {
            x = 0.5;
            y = 0.65;
            z = 0.5;
            xr = 180.0f;
            yr = 0.0f;
            zr = 0.0f;
        }
        if (transform.equals((Object)ItemDisplayContext.FIRST_PERSON_RIGHT_HAND)) {
            x = 0.4;
            y = 0.85;
            z = 0.5;
            xr = 180.0f;
            yr = 90.0f;
            zr = 0.0f;
            size = 0.7f;
        }
        if (transform.equals((Object)ItemDisplayContext.FIRST_PERSON_LEFT_HAND)) {
            x = 0.2;
            y = 0.85;
            z = 0.5;
            xr = 180.0f;
            yr = 90.0f;
            zr = 0.0f;
            size = 0.7f;
        }
        if (transform.equals((Object)ItemDisplayContext.GUI)) {
            x = 0.25;
            y = 0.2;
            z = 0.5;
            xr = 30.0f;
            yr = 60.0f;
            zr = 0.0f;
            size = 0.6f;
        }
        if (transform.equals((Object)ItemDisplayContext.GROUND)) {
            x = 0.5;
            y = 0.85;
            z = 0.7;
            xr = 180.0f;
            yr = 0.0f;
            zr = 0.0f;
            size = 0.4f;
        }
        float[][] colorset = WilliamRenderer.getColorSet(stack, stack == null || !stack.has(DataComponents.FICTION_COMPONENT) || ((FictionMahou)stack.get(DataComponents.FICTION_COMPONENT)).style >= 0);
        WilliamRenderer.renderBook(x, y, z, xr, yr, zr, size, matrix, buffer, new BookRender(), colorset[0], colorset[1], colorset[2]);
        matrix.popPose();
    }

    public static float[][] getColorSet(ItemStack stack, boolean w) {
        float[][] colors = new float[][]{rlyeh_pages, rlyeh_cover, rlyeh_text, rlyeh_circle};
        if (w) {
            colors = new float[][]{william_pages, william_cover, william_text, william_circle};
        }
        float[] cs = Utils.getColor(stack, false);
        float[] cs2 = Utils.getColor(stack, true);
        if (cs != null && cs2 != null) {
            colors = new float[][]{{cs[0] / 255.0f, cs[1] / 255.0f, cs[2] / 255.0f, 1.0f}, {cs[3] / 255.0f, cs[4] / 255.0f, cs[5] / 255.0f, 1.0f}, {cs2[0] / 255.0f, cs2[1] / 255.0f, cs2[2] / 255.0f, 1.0f}, {cs2[3] / 255.0f, cs2[4] / 255.0f, cs2[5] / 255.0f, 1.0f}};
        }
        return colors;
    }

    public static void renderBook(double x, double y, double z, float yRot, float pRot, float dRot, float size, PoseStack matrix, MultiBufferSource buffer, BookRender br, float[] cover, float[] pages, float[] text) {
        matrix.pushPose();
        matrix.translate(x, y, z);
        RenderUtils.rotateQ(dRot, 0.0f, 0.0f, 1.0f, matrix);
        RenderUtils.rotateQ(yRot, 1.0f, 0.0f, 0.0f, matrix);
        RenderUtils.rotateQ(pRot, 0.0f, 1.0f, 0.0f, matrix);
        int lx = 240;
        int ly = 240;
        matrix.scale(size, size, size);
        buffer = buffer != null ? buffer : Minecraft.getInstance().renderBuffers().bufferSource();
        RenderType type = MahoujinRenderType.createWilliamRenderType(RuleBreakerRenderer.white, 0);
        Matrix4f m = matrix.last().pose();
        VertexConsumer buf = buffer.getBuffer(type);
        WilliamRenderer.renderPageStack(br.frontPageStack, m, buf, pages);
        WilliamRenderer.renderPageStack(br.backPageStack, m, buf, pages);
        WilliamRenderer.renderCover(br.frontCover, m, buf, cover);
        WilliamRenderer.renderCover(br.backCover, m, buf, cover);
        WilliamRenderer.renderBinding(br, m, buf, cover);
        for (ArrayList<Point> points : br.turningPages) {
            WilliamRenderer.renderPageFlip(points, m, buf, pages);
        }
        RenderUtils.conditionalBatchEnder(type, buffer);
        if (br.renderingChars) {
            WilliamRenderer.renderFrontText(br, m, buffer, text);
            WilliamRenderer.renderBackText(br, m, buffer, text);
            WilliamRenderer.renderPageFlipText(br, m, buffer, text);
        }
        matrix.popPose();
    }

    public static void renderFrontText(BookRender br, Matrix4f m, MultiBufferSource buffer, float[] rgba) {
        WilliamRenderer.renderText(br.frontCharIndices, br.frontCharacterLocations, m, buffer, rgba, true);
    }

    public static void renderBackText(BookRender br, Matrix4f m, MultiBufferSource buffer, float[] rgba) {
        WilliamRenderer.renderText(br.backCharIndices, br.backCharacterLocations, m, buffer, rgba, true);
    }

    public static void renderPageFlipText(BookRender br, Matrix4f m, MultiBufferSource buffer, float[] rgba) {
        int x;
        if (br.frontPageFlipCharacterLocations != null) {
            for (x = 0; x < br.frontPageFlipCharacterLocations.size(); ++x) {
                if (x >= br.turningPageChars.size()) continue;
                WilliamRenderer.renderText(br.turningPageChars.get(x), br.frontPageFlipCharacterLocations.get(x), m, buffer, rgba, true);
            }
        }
        if (br.backPageFlipCharacterLocations != null) {
            for (x = 0; x < br.backPageFlipCharacterLocations.size(); ++x) {
                if (x >= br.turningPageChars.size()) continue;
                WilliamRenderer.renderText(br.turningPageChars.get(x), br.backPageFlipCharacterLocations.get(x), m, buffer, rgba, true);
            }
        }
    }

    public static void renderText(ArrayList<Integer> indices, ArrayList<Point> points, Matrix4f m, MultiBufferSource buffer, float[] rgba, boolean flip) {
        int zz = 0;
        if (indices == null || indices.size() <= 0 || points == null || points.size() <= 0) {
            return;
        }
        for (int k = 0; k < points.size(); k += 4) {
            int ind = indices.get(zz % indices.size());
            ++zz;
            RenderType type = MahoujinRenderType.createCharacterRenderType(RenderWilliamEntity.rune_loc.get(ind % RenderWilliamEntity.rune_loc.size()), 0);
            VertexConsumer buf = buffer.getBuffer(type);
            if (flip) {
                Point.addPointAt(buf, m, points, k + 3, rgba).setUv(0.0f, 0.0f).setUv2(240, 240);
                Point.addPointAt(buf, m, points, k + 2, rgba).setUv(0.0f, 1.0f).setUv2(240, 240);
                Point.addPointAt(buf, m, points, k + 1, rgba).setUv(1.0f, 1.0f).setUv2(240, 240);
                Point.addPointAt(buf, m, points, k + 0, rgba).setUv(1.0f, 0.0f).setUv2(240, 240);
            } else {
                Point.addPointAt(buf, m, points, k + 0, rgba).setUv(0.0f, 0.0f).setUv2(240, 240);
                Point.addPointAt(buf, m, points, k + 1, rgba).setUv(0.0f, 1.0f).setUv2(240, 240);
                Point.addPointAt(buf, m, points, k + 2, rgba).setUv(1.0f, 1.0f).setUv2(240, 240);
                Point.addPointAt(buf, m, points, k + 3, rgba).setUv(1.0f, 0.0f).setUv2(240, 240);
            }
            RenderUtils.conditionalBatchEnder(type, buffer);
        }
    }

    public static void renderCover(ArrayList<Point> cover, Matrix4f m, VertexConsumer buf, float[] colors) {
        int lx = 240;
        int ly = 240;
        float[] rgba = colors;
        float[] darken = BookRender.darken(rgba);
        Point.addPointAt(buf, m, cover, 0, darken).setUv(0.0f, 0.0f).setUv2(lx, ly);
        Point.addPointAt(buf, m, cover, 0, darken).setUv(0.0f, 1.0f).setUv2(lx, ly);
        Point.addPointAt(buf, m, cover, 0, darken).setUv(0.0f, 1.0f).setUv2(lx, ly);
        Point.addPointAt(buf, m, cover, 4, darken).setUv(0.0f, 1.0f).setUv2(lx, ly);
        Point.addPointAt(buf, m, cover, 1, darken).setUv(0.0f, 1.0f).setUv2(lx, ly);
        Point.addPointAt(buf, m, cover, 5, darken).setUv(0.0f, 1.0f).setUv2(lx, ly);
        Point.addPointAt(buf, m, cover, 2, darken).setUv(0.0f, 1.0f).setUv2(lx, ly);
        Point.addPointAt(buf, m, cover, 6, darken).setUv(0.0f, 1.0f).setUv2(lx, ly);
        Point.addPointAt(buf, m, cover, 3, darken).setUv(0.0f, 1.0f).setUv2(lx, ly);
        Point.addPointAt(buf, m, cover, 7, darken).setUv(0.0f, 1.0f).setUv2(lx, ly);
        Point.addPointAt(buf, m, cover, 0, darken).setUv(0.0f, 1.0f).setUv2(lx, ly);
        Point.addPointAt(buf, m, cover, 4, darken).setUv(0.0f, 1.0f).setUv2(lx, ly);
        Point.addPointAt(buf, m, cover, 0, darken).setUv(0.0f, 1.0f).setUv2(lx, ly);
        Point.addPointAt(buf, m, cover, 1, darken).setUv(0.0f, 1.0f).setUv2(lx, ly);
        Point.addPointAt(buf, m, cover, 3, darken).setUv(0.0f, 1.0f).setUv2(lx, ly);
        Point.addPointAt(buf, m, cover, 2, darken).setUv(0.0f, 1.0f).setUv2(lx, ly);
        Point.addPointAt(buf, m, cover, 4, rgba).setUv(0.0f, 1.0f).setUv2(lx, ly);
        Point.addPointAt(buf, m, cover, 5, rgba).setUv(0.0f, 1.0f).setUv2(lx, ly);
        Point.addPointAt(buf, m, cover, 7, rgba).setUv(0.0f, 1.0f).setUv2(lx, ly);
        Point.addPointAt(buf, m, cover, 6, rgba).setUv(0.0f, 1.0f).setUv2(lx, ly);
        Point.addPointAt(buf, m, cover, 6, rgba).setUv(1.0f, 1.0f).setUv2(lx, ly);
    }

    public static void renderBinding(BookRender br, Matrix4f m, VertexConsumer buf, float[] colors) {
        int k;
        int lx = 240;
        int ly = 240;
        float[] rgba = colors;
        float[] darken = BookRender.darken(rgba);
        float[] darken1 = BookRender.darken(rgba, 0.9f);
        float[] darken2 = BookRender.darken(darken, 0.9f);
        Point.addPointAt(buf, m, br.binding, 6, darken).setUv(0.0f, 0.0f).setUv2(lx, ly);
        Point.addPointAt(buf, m, br.binding, 6, darken).setUv(0.0f, 1.0f).setUv2(lx, ly);
        Point.addPointAt(buf, m, br.binding, 7, darken).setUv(0.0f, 1.0f).setUv2(lx, ly);
        for (k = 0; k <= br.binding_quality; ++k) {
            Point.addPointAt(buf, m, br.binding, 9 + 4 * k, darken).setUv(0.0f, 1.0f).setUv2(lx, ly);
            Point.addPointAt(buf, m, br.binding, 11 + 4 * k, darken).setUv(0.0f, 1.0f).setUv2(lx, ly);
        }
        Point.addPointAt(buf, m, br.binding, 2, darken).setUv(0.0f, 1.0f).setUv2(lx, ly);
        Point.addPointAt(buf, m, br.binding, 3, darken).setUv(0.0f, 1.0f).setUv2(lx, ly);
        Point.addPointAt(buf, m, br.binding, 3, darken).setUv(1.0f, 1.0f).setUv2(lx, ly);
        Point.addPointAt(buf, m, br.binding, 4, darken).setUv(0.0f, 0.0f).setUv2(lx, ly);
        Point.addPointAt(buf, m, br.binding, 4, darken).setUv(0.0f, 1.0f).setUv2(lx, ly);
        Point.addPointAt(buf, m, br.binding, 5, darken).setUv(0.0f, 1.0f).setUv2(lx, ly);
        for (k = 0; k <= br.binding_quality; ++k) {
            Point.addPointAt(buf, m, br.binding, 8 + 4 * k, darken).setUv(0.0f, 1.0f).setUv2(lx, ly);
            Point.addPointAt(buf, m, br.binding, 10 + 4 * k, darken).setUv(0.0f, 1.0f).setUv2(lx, ly);
        }
        Point.addPointAt(buf, m, br.binding, 0, darken).setUv(0.0f, 1.0f).setUv2(lx, ly);
        Point.addPointAt(buf, m, br.binding, 1, darken).setUv(0.0f, 1.0f).setUv2(lx, ly);
        Point.addPointAt(buf, m, br.binding, 1, darken).setUv(1.0f, 1.0f).setUv2(lx, ly);
        Point.addPointAt(buf, m, br.binding, 4, darken2).setUv(0.0f, 0.0f).setUv2(lx, ly);
        Point.addPointAt(buf, m, br.binding, 4, darken2).setUv(0.0f, 1.0f).setUv2(lx, ly);
        Point.addPointAt(buf, m, br.binding, 6, darken2).setUv(0.0f, 1.0f).setUv2(lx, ly);
        for (k = 0; k <= br.binding_quality; ++k) {
            Point.addPointAt(buf, m, br.binding, 8 + 4 * k, darken2).setUv(0.0f, 1.0f).setUv2(lx, ly);
            Point.addPointAt(buf, m, br.binding, 9 + 4 * k, darken2).setUv(0.0f, 1.0f).setUv2(lx, ly);
        }
        Point.addPointAt(buf, m, br.binding, 0, darken2).setUv(0.0f, 1.0f).setUv2(lx, ly);
        Point.addPointAt(buf, m, br.binding, 2, darken2).setUv(0.0f, 1.0f).setUv2(lx, ly);
        Point.addPointAt(buf, m, br.binding, 2, darken2).setUv(1.0f, 1.0f).setUv2(lx, ly);
        Point.addPointAt(buf, m, br.binding, 5, darken1).setUv(0.0f, 0.0f).setUv2(lx, ly);
        Point.addPointAt(buf, m, br.binding, 5, darken1).setUv(0.0f, 1.0f).setUv2(lx, ly);
        Point.addPointAt(buf, m, br.binding, 7, darken1).setUv(0.0f, 1.0f).setUv2(lx, ly);
        for (k = 0; k <= br.binding_quality; ++k) {
            Point.addPointAt(buf, m, br.binding, 10 + 4 * k, darken1).setUv(0.0f, 1.0f).setUv2(lx, ly);
            Point.addPointAt(buf, m, br.binding, 11 + 4 * k, darken1).setUv(0.0f, 1.0f).setUv2(lx, ly);
        }
        Point.addPointAt(buf, m, br.binding, 1, darken1).setUv(0.0f, 1.0f).setUv2(lx, ly);
        Point.addPointAt(buf, m, br.binding, 3, darken1).setUv(0.0f, 1.0f).setUv2(lx, ly);
        Point.addPointAt(buf, m, br.binding, 3, darken1).setUv(1.0f, 1.0f).setUv2(lx, ly);
    }

    public static void renderPageStack(ArrayList<Point> stack, Matrix4f m, VertexConsumer buf, float[] colors) {
        int lx = 240;
        int ly = 240;
        float[] rgba = colors;
        float[] darken = BookRender.darken(rgba, 0.8f);
        float[] darken2 = BookRender.darken(darken, 0.8f);
        Point.addPointAt(buf, m, stack, 0, darken).setUv(0.0f, 0.0f).setUv2(lx, ly);
        for (int k = 0; k <= stack.size() - 8; k += 4) {
            Point.addPointAt(buf, m, stack, k, darken).setUv(0.0f, 1.0f).setUv2(lx, ly);
            Point.addPointAt(buf, m, stack, k + 4, darken).setUv(0.0f, 1.0f).setUv2(lx, ly);
            Point.addPointAt(buf, m, stack, k + 1, darken2).setUv(0.0f, 1.0f).setUv2(lx, ly);
            Point.addPointAt(buf, m, stack, k + 5, darken2).setUv(0.0f, 1.0f).setUv2(lx, ly);
            Point.addPointAt(buf, m, stack, k + 2, rgba).setUv(0.0f, 1.0f).setUv2(lx, ly);
            Point.addPointAt(buf, m, stack, k + 6, rgba).setUv(0.0f, 1.0f).setUv2(lx, ly);
            Point.addPointAt(buf, m, stack, k + 3, darken2).setUv(0.0f, 1.0f).setUv2(lx, ly);
            Point.addPointAt(buf, m, stack, k + 7, darken2).setUv(0.0f, 1.0f).setUv2(lx, ly);
            Point.addPointAt(buf, m, stack, k, darken2).setUv(0.0f, 1.0f).setUv2(lx, ly);
            Point.addPointAt(buf, m, stack, k + 4, darken2).setUv(0.0f, 1.0f).setUv2(lx, ly);
        }
        Point.addPointAt(buf, m, stack, 0, darken2).setUv(0.0f, 1.0f).setUv2(lx, ly);
        Point.addPointAt(buf, m, stack, 1, darken2).setUv(0.0f, 1.0f).setUv2(lx, ly);
        Point.addPointAt(buf, m, stack, 3, darken).setUv(0.0f, 1.0f).setUv2(lx, ly);
        Point.addPointAt(buf, m, stack, 2, darken).setUv(0.0f, 1.0f).setUv2(lx, ly);
        Point.addPointAt(buf, m, stack, 2, darken).setUv(1.0f, 1.0f).setUv2(lx, ly);
    }

    public static void renderPageFlip(ArrayList<Point> stack, Matrix4f m, VertexConsumer buf, float[] colors) {
        int lx = 240;
        int ly = 240;
        float[] rgba = colors;
        float[] darken = BookRender.darken(rgba, 0.8f);
        float[] darken2 = BookRender.darken(darken, 0.8f);
        Point.addPointAt(buf, m, stack, 0, rgba).setUv(0.0f, 0.0f).setUv2(lx, ly);
        for (int k = 0; k < stack.size(); k += 2) {
            Point.addPointAt(buf, m, stack, k + 0, rgba).setUv(0.0f, 0.5f).setUv2(lx, ly);
            Point.addPointAt(buf, m, stack, k + 1, darken2).setUv(0.0f, 1.0f).setUv2(lx, ly);
        }
        Point.addPointAt(buf, m, stack, stack.size() - 1, rgba).setUv(1.0f, 1.0f).setUv2(lx, ly);
    }

    public static void renderCircle(ArrayList<Point> circle, Matrix4f m, VertexConsumer buf, float[] colors) {
        int lx = 240;
        int ly = 240;
        float[] rgba = colors;
        Point.addPointAt(buf, m, circle, 0, rgba).setUv(0.0f, 0.0f).setUv2(lx, ly);
        Point.addPointAt(buf, m, circle, 0, rgba).setUv(0.0f, 0.0f).setUv2(lx, ly);
        Point.addPointAt(buf, m, circle, 1, rgba).setUv(0.0f, 1.0f).setUv2(lx, ly);
        Point.addPointAt(buf, m, circle, 3, rgba).setUv(1.0f, 0.0f).setUv2(lx, ly);
        Point.addPointAt(buf, m, circle, 2, rgba).setUv(1.0f, 1.0f).setUv2(lx, ly);
        Point.addPointAt(buf, m, circle, 2, rgba).setUv(1.0f, 1.0f).setUv2(lx, ly);
    }
}

