/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.networking;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.WrittenBookItem;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import stepsword.mahoutsukai.dataattachments.worldsave.MahouSavedData;
import stepsword.mahoutsukai.item.william.BookReadingTracker;
import stepsword.mahoutsukai.item.william.WrittenEvaluation;
import stepsword.mahoutsukai.networking.MahouPackets;
import stepsword.mahoutsukai.util.Utils;

public class TurnedPagePacket
implements CustomPacketPayload {
    int page;
    public static ConcurrentHashMap<UUID, BookReadingTracker> lastOpened = new ConcurrentHashMap();
    public static final StreamCodec<ByteBuf, TurnedPagePacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, p -> p.page, TurnedPagePacket::new);

    public TurnedPagePacket(int page) {
        this.page = page;
    }

    public static void handle(TurnedPagePacket message, IPayloadContext context) {
        ServerPlayer player = (ServerPlayer)context.player();
        MahouSavedData mahou = Utils.getWorldMahou(player.level());
        if (lastOpened != null && lastOpened.containsKey(player.getUUID())) {
            BookReadingTracker tracker = lastOpened.get(player.getUUID());
            long now = System.currentTimeMillis();
            if (message.page == tracker.lastPage + 1 && now - tracker.lastUpdated > 500L && now - tracker.lastUpdated < 120000L && now > tracker.lastUpdated) {
                mahou.addFameIfExists(1, tracker.text, player.getUUID());
            }
            tracker.lastPage = message.page;
            tracker.lastUpdated = now;
        }
    }

    public static void openedBook(PlayerInteractEvent.RightClickItem event) {
        ItemStack stack = event.getItemStack();
        lastOpened.remove(event.getEntity().getUUID());
        if (stack.getItem() instanceof WrittenBookItem) {
            BookReadingTracker tracker = new BookReadingTracker();
            tracker.lastUpdated = System.currentTimeMillis();
            tracker.lastPage = 0;
            tracker.text = WrittenEvaluation.getBookText(stack);
            lastOpened.put(event.getEntity().getUUID(), tracker);
        }
    }

    public CustomPacketPayload.Type<TurnedPagePacket> type() {
        return MahouPackets.TURNED_PAGE_TYPE;
    }
}

