/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.item.spells.projection.WeaponProjectile;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.EventHooks;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.dataattachments.settingsmahou.MahouSettings;
import stepsword.mahoutsukai.datacomponents.stackholder.StackHolderMahou;
import stepsword.mahoutsukai.effects.projection.ProjectionSpellEffect;
import stepsword.mahoutsukai.entity.WeaponProjectileEntity;
import stepsword.mahoutsukai.item.spells.projection.ProjectionSpellScroll;
import stepsword.mahoutsukai.util.Utils;

public class WeaponProjectileBow
extends BowItem {
    public static String AMMO_STACK = "mahoutsukai_ammo_stack";
    private String MODE_TAG = "MAHOUTSUKAI_WPBOW_MODE";

    public WeaponProjectileBow() {
        super(new Item.Properties().stacksTo(1).durability(MTConfig.WEAPON_SHOOTER_DURABILITY));
    }

    public boolean isDamageable(ItemStack stack) {
        return false;
    }

    public int getMaxDamage(ItemStack stack) {
        return MTConfig.WEAPON_SHOOTER_DURABILITY;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        boolean flag2;
        ItemStack stack = player.getItemInHand(hand);
        ItemStack s = new ItemStack((ItemLike)Items.AIR);
        ItemStack weapon = new ItemStack((ItemLike)Items.AIR);
        if (Utils.getMode(stack) == 1) {
            s = this.findAmmo(player, stack, true);
            if (s == null || s.isEmpty() || s.getItem() == Items.ARROW) {
                StackHolderMahou mahou;
                ItemStack scroll = this.findProjection(player, stack);
                if (scroll.getItem() instanceof ProjectionSpellScroll) {
                    ((ProjectionSpellScroll)scroll.getItem()).useAction(scroll, world, (LivingEntity)player, true);
                }
                s = this.findAmmo(player, stack, true);
                if (world.isClientSide && (s == null || s.isEmpty() || s.getItem() == Items.ARROW) && scroll.getItem() instanceof ProjectionSpellScroll && (mahou = Utils.getStackHolderMahou(scroll)) != null && mahou.getStack().isPresent()) {
                    s = mahou.getStack().get();
                }
            }
            weapon = s;
        } else {
            weapon = s = this.findAmmo(player, stack, false);
        }
        boolean flag = s != null && !s.isEmpty() && s.getItem() != Items.ARROW;
        boolean bl = flag2 = weapon != null && !weapon.isEmpty() && weapon.getItem() != Items.ARROW;
        if ((!flag && !world.isClientSide || !flag2 && world.isClientSide) && !player.isDiscrete()) {
            return InteractionResultHolder.fail((Object)stack);
        }
        if (!player.isDiscrete()) {
            Utils.setAmmoStack(stack, weapon);
            player.startUsingItem(hand);
            return InteractionResultHolder.success((Object)stack);
        }
        Utils.setMode(stack, (Utils.getMode(stack) + 1) % 2);
        int mode = Utils.getMode(stack);
        MutableComponent tt = mode == 0 ? Component.translatable((String)"mahoutsukai.weaponprojectiles.normal") : Component.translatable((String)"mahoutsukai.weaponprojectiles.projections");
        player.displayClientMessage((Component)tt, true);
        return InteractionResultHolder.success((Object)stack);
    }

    public ItemStack findAmmo(Player player, ItemStack shootable, boolean projectedOnly) {
        ItemStack itemstack1;
        int i;
        if (!(shootable.getItem() instanceof WeaponProjectileBow)) {
            return ItemStack.EMPTY;
        }
        Predicate<ItemStack> prepredicate = ((WeaponProjectileBow)shootable.getItem()).getPreInventoryAmmoPredicate();
        Predicate<ItemStack> predicate = ((WeaponProjectileBow)shootable.getItem()).getSupportedHeldProjectiles();
        ItemStack itemstack = WeaponProjectileBow.getHeldProjectile((LivingEntity)player, (Predicate)predicate);
        if (!itemstack.isEmpty()) {
            return itemstack;
        }
        prepredicate = ((WeaponProjectileBow)shootable.getItem()).getPreInventoryAmmoPredicate();
        predicate = ((WeaponProjectileBow)shootable.getItem()).getAllSupportedProjectiles();
        for (i = 0; i < player.getInventory().getContainerSize(); ++i) {
            itemstack1 = player.getInventory().getItem(i);
            if (!prepredicate.test(itemstack1)) continue;
            return itemstack1;
        }
        if (!projectedOnly) {
            for (i = 0; i < player.getInventory().getContainerSize(); ++i) {
                itemstack1 = player.getInventory().getItem(i);
                if (!predicate.test(itemstack1)) continue;
                return itemstack1;
            }
        }
        return player.getAbilities().instabuild ? new ItemStack((ItemLike)Items.ARROW) : ItemStack.EMPTY;
    }

    public ItemStack findProjection(Player player, ItemStack shootable) {
        if (!(shootable.getItem() instanceof WeaponProjectileBow)) {
            return ItemStack.EMPTY;
        }
        Predicate<ItemStack> predicate = a -> a.getItem() instanceof ProjectionSpellScroll;
        ItemStack itemstack = WeaponProjectileBow.getHeldProjectile((LivingEntity)player, predicate);
        if (!itemstack.isEmpty()) {
            return itemstack;
        }
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            ItemStack itemstack1 = player.getInventory().getItem(i);
            if (!predicate.test(itemstack1)) continue;
            return itemstack1;
        }
        return player.getAbilities().instabuild ? new ItemStack((ItemLike)Items.ARROW) : ItemStack.EMPTY;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 72000;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    public Predicate<ItemStack> getPreInventoryAmmoPredicate() {
        return s -> this.isArrow((ItemStack)s) && ProjectionSpellEffect.getProjected(s);
    }

    public Predicate<ItemStack> getAllSupportedProjectiles() {
        return s -> this.isArrow((ItemStack)s);
    }

    public void releaseUsing(ItemStack stack, Level world, LivingEntity shooter, int useTicks) {
        if (shooter instanceof Player) {
            float f;
            Player player = (Player)shooter;
            ItemStack projectile = new ItemStack((ItemLike)Items.AIR);
            projectile = Utils.getMode(stack) == 1 ? this.findAmmo(player, stack, true) : this.findAmmo(player, stack, false);
            int i = this.getUseDuration(stack, shooter) - useTicks;
            if ((i = EventHooks.onArrowLoose((ItemStack)stack, (Level)world, (Player)player, (int)i, (projectile != ItemStack.EMPTY ? 1 : 0) != 0)) < 0) {
                return;
            }
            if (!player.level().isClientSide) {
                List<Integer> settings = MahouSettings.getIntSettings(player, MahouSettings.Spell.WEAPON_PROJECTILE);
                Utils.color(stack, settings.get(0).intValue(), settings.get(1).intValue(), settings.get(2).intValue(), settings.get(3).intValue(), settings.get(4).intValue(), settings.get(5).intValue());
            }
            if (projectile != ItemStack.EMPTY && (double)(f = WeaponProjectileBow.getPowerForTime((int)i)) >= 0.1) {
                if (!world.isClientSide) {
                    if (!this.isArrow(projectile)) {
                        return;
                    }
                    WeaponProjectileEntity projectileEntity = new WeaponProjectileEntity(world, shooter, projectile.copy());
                    projectileEntity.shoot((Entity)shooter, shooter.xRot, shooter.yRot, 0.0f, (float)((double)f * MTConfig.WEAPON_SHOOTER_PROJECTILE_SPEED), 1.0f);
                    projectileEntity.setOwner((Entity)shooter);
                    world.addFreshEntity((Entity)projectileEntity);
                    stack.hurtAndBreak(1, shooter, EquipmentSlot.MAINHAND);
                }
                if (!player.isCreative()) {
                    projectile.shrink(1);
                    if (stack.isEmpty()) {
                        player.getInventory().removeItem(projectile);
                    }
                }
                world.playSound(null, shooter.blockPosition(), SoundEvents.ARROW_SHOOT, SoundSource.NEUTRAL, 1.0f, 1.0f / (shooter.getRandom().nextFloat() * 0.4f + 1.2f) + f * 0.5f);
            }
        }
    }

    protected boolean isArrow(ItemStack stack) {
        Item tmpi = stack.getItem();
        return tmpi instanceof SwordItem || tmpi instanceof DiggerItem || tmpi instanceof ShieldItem || tmpi instanceof ShearsItem || tmpi instanceof FishingRodItem || tmpi instanceof TridentItem;
    }
}

