/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.effects.projection;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.component.Unbreakable;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.UseItemOnBlockEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import org.apache.commons.lang3.stream.Streams;
import org.apache.commons.lang3.tuple.Pair;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.datacomponents.strengthening.StrengtheningMahou;
import stepsword.mahoutsukai.item.spells.SpellScroll;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class StrengtheningSpellEffect {
    public static final String STRENGTHENED_TAG = "mahoutsukai_strengthened";
    public static final String UNBREAKABLE_TAG = "mahoutsukai_old_unbreakable";
    public static final int STRENGTHENED_USES = 5;
    public static final float STRENGTHENED_DAMAGE_BUFF = 4.0f;
    static Map<Pair<TagKey<Block>, TagKey<Block>>, Boolean> CACHE = new HashMap<Pair<TagKey<Block>, TagKey<Block>>, Boolean>();
    static Tier[] VANILLA_TIERS = new Tier[]{Tiers.WOOD, Tiers.STONE, Tiers.IRON, Tiers.DIAMOND, Tiers.NETHERITE};

    public static void strengtheningLivingHurt(LivingIncomingDamageEvent event) {
        if (!event.getEntity().level().isClientSide) {
            Entity trueSource;
            DamageSource source = event.getSource();
            ItemStack weapon = null;
            if (source.getMsgId() != "arrow" && Utils.damageSourceAny(source, DamageTypes.PLAYER_ATTACK) && source.getEntity() instanceof LivingEntity && (trueSource = source.getEntity()) instanceof LivingEntity) {
                LivingEntity attacker = (LivingEntity)trueSource;
                weapon = attacker.getMainHandItem();
            }
            if (weapon != null && StrengtheningSpellEffect.getStrengthened(weapon) > 0) {
                event.setAmount(event.getAmount() + 4.0f);
                StrengtheningSpellEffect.reduceStrengthened(weapon, 1);
            }
        }
    }

    public static void strengtheningUseEvent(LivingEntityUseItemEvent.Stop event) {
    }

    public static void strengtheningUseEvent(UseItemOnBlockEvent event) {
    }

    static boolean isSubset(TagKey<Block> tag1, TagKey<Block> tag2) {
        return CACHE.computeIfAbsent((Pair<TagKey<Block>, TagKey<Block>>)Pair.of(tag1, tag2), pair -> {
            Iterable list1 = BuiltInRegistries.BLOCK.getTagOrEmpty((TagKey)pair.getLeft());
            Iterable list2 = BuiltInRegistries.BLOCK.getTagOrEmpty((TagKey)pair.getRight());
            Set set1 = Streams.of((Iterable)list1).collect(Collectors.toSet());
            Set set2 = Streams.of((Iterable)list2).collect(Collectors.toSet());
            return set2.size() > set1.size() && set2.containsAll(set1);
        });
    }

    static Tier getCurrentTier(Tier inputTier) {
        for (Tier vanillaTier : VANILLA_TIERS) {
            if (!StrengtheningSpellEffect.isSubset((TagKey<Block>)vanillaTier.getIncorrectBlocksForDrops(), (TagKey<Block>)inputTier.getIncorrectBlocksForDrops())) continue;
            return vanillaTier;
        }
        return inputTier;
    }

    public static void strengtheningHarvestCheck(PlayerEvent.HarvestCheck event) {
        Player player = event.getEntity();
        ItemStack s = player.getMainHandItem();
        if (StrengtheningSpellEffect.getStrengthened(s) > 0) {
            ItemStack woodPickaxe = new ItemStack((ItemLike)Items.WOODEN_PICKAXE);
            boolean wood = woodPickaxe.isCorrectToolForDrops(event.getTargetBlock());
            if (s.getItem() instanceof PickaxeItem) {
                Tier tier = ((PickaxeItem)s.getItem()).getTier();
                Tier nextTier = StrengtheningSpellEffect.getCurrentTier(tier);
                if (!event.getTargetBlock().is(nextTier.getIncorrectBlocksForDrops())) {
                    event.setCanHarvest(true);
                }
            } else if (wood) {
                event.setCanHarvest(true);
            }
        }
    }

    public static void strengtheningArmorEvent(LivingIncomingDamageEvent event) {
        LivingEntity living = event.getEntity();
        Iterable armors = living.getArmorSlots();
        for (ItemStack s : armors) {
            if (StrengtheningSpellEffect.getStrengthened(s) <= 0) continue;
            StrengtheningSpellEffect.reduceStrengthened(s, 1);
        }
    }

    public static void strengtheningBreakEvent(BlockEvent.BreakEvent event) {
    }

    public static void strengtheningBreakSpeed(PlayerEvent.BreakSpeed event) {
        ItemStack s;
        Player player = event.getEntity();
        if (player != null && StrengtheningSpellEffect.getStrengthened(s = player.getMainHandItem()) > 0) {
            event.setNewSpeed(event.getNewSpeed() + 3.0f);
        }
    }

    public static void reduceStrengthened(ItemStack stack, int reduce) {
        StrengtheningMahou mahou;
        if (stack != null && !stack.isEmpty() && (mahou = (StrengtheningMahou)Utils.getDefaultMahou(stack, stepsword.mahoutsukai.datacomponents.DataComponents.STRENGTHENING_COMPONENT, null)) != null) {
            mahou.setUses(mahou.getUses() - reduce);
            Utils.setStrengtheningMahou(stack, mahou);
            if (mahou.getUses() <= 0) {
                if (mahou.unbreakable) {
                    stack.set(DataComponents.UNBREAKABLE, (Object)new Unbreakable(true));
                } else {
                    stack.set(DataComponents.UNBREAKABLE, null);
                    stack.remove(stepsword.mahoutsukai.datacomponents.DataComponents.STRENGTHENING_COMPONENT);
                }
                stack.remove(stepsword.mahoutsukai.datacomponents.DataComponents.STRENGTHENING_COMPONENT);
            }
        }
    }

    public static void setStrengthened(ItemStack stack, Level world) {
        if (!(world.isClientSide || stack == null || stack.isEmpty() || EffectUtil.inItemBlacklist(stack.getItem(), MTConfig.STRENGTHENING_ITEM_BLACKLIST, world))) {
            int alreadyStrengthened = 0;
            StrengtheningMahou mahou = Utils.getStrengtheningMahou(stack);
            alreadyStrengthened = StrengtheningSpellEffect.getStrengthened(stack);
            if (alreadyStrengthened == 0 && stack.has(DataComponents.UNBREAKABLE)) {
                mahou.setUnbreakable(true);
            }
            stack.set(DataComponents.UNBREAKABLE, (Object)new Unbreakable(true));
            mahou.setUses(Math.min(MTConfig.STRENGTHENING_CAP, alreadyStrengthened + 5));
            Utils.setStrengtheningMahou(stack, mahou);
        }
    }

    public static int getStrengthened(ItemStack stack) {
        if (stack != null && !stack.isEmpty() && Utils.hasStrengtheningMahou(stack)) {
            if (Utils.getStrengtheningMahou((ItemStack)stack).uses <= 0) {
                stack.remove(stepsword.mahoutsukai.datacomponents.DataComponents.STRENGTHENING_COMPONENT);
            }
            return Utils.getStrengtheningMahou((ItemStack)stack).uses;
        }
        return 0;
    }

    public static ItemStack findStackToStrengthen(Player p) {
        ItemStack stack = null;
        if (p != null && ((stack = p.getOffhandItem()) == null || stack.isEmpty())) {
            for (int i = 0; i < 10 && ((stack = p.getInventory().getItem(i)) == null || stack.isEmpty() || stack.getItem() instanceof SpellScroll); ++i) {
            }
        }
        return stack;
    }
}

