/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.recipe.serializer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.hrznstudio.titanium.Titanium;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.fluids.FluidStack;

public class JSONSerializableDataHandler {
    private static HashMap<Class, Pair<Writer, Reader>> FIELD_SERIALIZER = new HashMap();

    public static <T> void map(Class<T> type, Writer<T> writer, Reader<T> reader) {
        FIELD_SERIALIZER.put(type, (Pair<Writer, Reader>)Pair.of(writer, reader));
    }

    public static boolean acceptField(Field f, Class<?> type) {
        int mods = f.getModifiers();
        return !Modifier.isFinal(mods) && !Modifier.isStatic(mods) && !Modifier.isTransient(mods) && FIELD_SERIALIZER.containsKey(type);
    }

    public static <T> T read(Class<T> type, JsonElement element) {
        return ((Reader)FIELD_SERIALIZER.get(type).getSecond()).read(element);
    }

    public static <T> T readCodec(Codec<T> codec, JsonElement element) {
        return (T)((Pair)codec.decode((DynamicOps)JsonOps.INSTANCE, (Object)element).result().orElseThrow()).getFirst();
    }

    public static <T> JsonElement writeCodec(Codec<T> codec, T value) {
        return (JsonElement)codec.encodeStart((DynamicOps)JsonOps.INSTANCE, value).result().orElseThrow();
    }

    public static JsonElement write(Class<?> type, Object value) {
        return ((Writer)FIELD_SERIALIZER.get(type).getFirst()).write(value);
    }

    public static JsonObject writeItemStack(ItemStack stack) {
        if (stack.isEmpty()) {
            return null;
        }
        JsonObject object = new JsonObject();
        return object;
    }

    public static JsonElement writeFluidStack(FluidStack fluidStack) {
        if (fluidStack.isEmpty()) {
            return null;
        }
        return new JsonObject();
    }

    public static FluidStack readFluidStack(JsonElement object) {
        return FluidStack.EMPTY;
    }

    public static ItemStack readItemStack(JsonObject object) {
        return ItemStack.EMPTY;
    }

    public static JsonObject writeRegistryKey(ResourceKey<?> registryKey) {
        JsonObject object = new JsonObject();
        object.addProperty("key", registryKey.registry().toString());
        object.addProperty("value", registryKey.location().toString());
        return object;
    }

    public static ResourceKey<?> readRegistryKey(JsonElement object) {
        return ResourceKey.create((ResourceKey)ResourceKey.createRegistryKey((ResourceLocation)ResourceLocation.parse((String)object.getAsJsonObject().get("key").getAsString())), (ResourceLocation)ResourceLocation.parse((String)object.getAsJsonObject().get("value").getAsString()));
    }

    static {
        JSONSerializableDataHandler.map(Byte.TYPE, JsonPrimitive::new, JsonElement::getAsByte);
        JSONSerializableDataHandler.map(Short.TYPE, JsonPrimitive::new, JsonElement::getAsShort);
        JSONSerializableDataHandler.map(Integer.TYPE, JsonPrimitive::new, JsonElement::getAsInt);
        JSONSerializableDataHandler.map(Long.TYPE, JsonPrimitive::new, JsonElement::getAsLong);
        JSONSerializableDataHandler.map(Float.TYPE, JsonPrimitive::new, JsonElement::getAsFloat);
        JSONSerializableDataHandler.map(Double.TYPE, JsonPrimitive::new, JsonElement::getAsDouble);
        JSONSerializableDataHandler.map(Boolean.TYPE, JsonPrimitive::new, JsonElement::getAsBoolean);
        JSONSerializableDataHandler.map(Character.TYPE, JsonPrimitive::new, JsonElement::getAsCharacter);
        JSONSerializableDataHandler.map(Byte.class, JsonPrimitive::new, JsonElement::getAsByte);
        JSONSerializableDataHandler.map(Short.class, JsonPrimitive::new, JsonElement::getAsShort);
        JSONSerializableDataHandler.map(Integer.class, JsonPrimitive::new, JsonElement::getAsInt);
        JSONSerializableDataHandler.map(Long.class, JsonPrimitive::new, JsonElement::getAsLong);
        JSONSerializableDataHandler.map(Float.class, JsonPrimitive::new, JsonElement::getAsFloat);
        JSONSerializableDataHandler.map(Double.class, JsonPrimitive::new, JsonElement::getAsDouble);
        JSONSerializableDataHandler.map(Boolean.class, JsonPrimitive::new, JsonElement::getAsBoolean);
        JSONSerializableDataHandler.map(Character.class, JsonPrimitive::new, JsonElement::getAsCharacter);
        JSONSerializableDataHandler.map(String.class, JsonPrimitive::new, JsonElement::getAsString);
        JSONSerializableDataHandler.map(ItemStack.class, JSONSerializableDataHandler::writeItemStack, element -> JSONSerializableDataHandler.readItemStack(element.getAsJsonObject()));
        JSONSerializableDataHandler.map(ItemStack[].class, stacks -> {
            JsonArray array = new JsonArray();
            for (ItemStack stack : stacks) {
                array.add((JsonElement)JSONSerializableDataHandler.writeItemStack(stack));
            }
            return array;
        }, element -> {
            JsonArray array = element.getAsJsonArray();
            ItemStack[] stacks = new ItemStack[array.size()];
            for (int i = 0; i < array.size(); ++i) {
                stacks[i] = JSONSerializableDataHandler.readItemStack(array.get(i).getAsJsonObject());
            }
            return stacks;
        });
        JSONSerializableDataHandler.map(ResourceLocation.class, type -> new JsonPrimitive(type.toString()), element -> ResourceLocation.parse((String)element.getAsString()));
        JSONSerializableDataHandler.map(Block.class, type -> new JsonPrimitive(BuiltInRegistries.BLOCK.getKey(type).toString()), element -> (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)element.getAsString())));
        JSONSerializableDataHandler.map(FluidStack.class, JSONSerializableDataHandler::writeFluidStack, JSONSerializableDataHandler::readFluidStack);
        JSONSerializableDataHandler.map(ResourceKey.class, JSONSerializableDataHandler::writeRegistryKey, JSONSerializableDataHandler::readRegistryKey);
        JSONSerializableDataHandler.map(ResourceKey[].class, registryKeys -> {
            JsonObject object = new JsonObject();
            if (((ResourceKey[])registryKeys).length > 0) {
                object.addProperty("type", registryKeys[0].registry().toString());
                JsonArray array = new JsonArray();
                for (ResourceKey registryKey : registryKeys) {
                    array.add(registryKey.location().toString());
                }
                object.add("values", (JsonElement)array);
            }
            return object;
        }, element -> {
            ResourceKey[] registryKeys = new ResourceKey[]{};
            if (element.getAsJsonObject().has("type")) {
                registryKeys = new ResourceKey[element.getAsJsonObject().getAsJsonArray("values").size()];
                int i = 0;
                for (JsonElement jsonElement : element.getAsJsonObject().getAsJsonArray("values")) {
                    registryKeys[i] = ResourceKey.create((ResourceKey)ResourceKey.createRegistryKey((ResourceLocation)ResourceLocation.parse((String)element.getAsJsonObject().get("type").getAsString())), (ResourceLocation)ResourceLocation.parse((String)jsonElement.getAsString()));
                    ++i;
                }
            }
            return registryKeys;
        });
        JSONSerializableDataHandler.map(Ingredient[].class, type -> {
            JsonArray array = new JsonArray();
            for (Ingredient ingredient : type) {
                array.add(JSONSerializableDataHandler.write(Ingredient.class, ingredient));
            }
            return array;
        }, element -> {
            Ingredient[] ingredients = new Ingredient[element.getAsJsonArray().size()];
            int i = 0;
            for (JsonElement jsonElement : element.getAsJsonArray()) {
                ingredients[i] = JSONSerializableDataHandler.read(Ingredient.class, jsonElement);
                ++i;
            }
            return ingredients;
        });
        JSONSerializableDataHandler.map(Ingredient.Value.class, type -> JSONSerializableDataHandler.writeCodec(Ingredient.Value.CODEC, type), element -> (Ingredient.Value)JSONSerializableDataHandler.readCodec(Ingredient.Value.CODEC, element));
        JSONSerializableDataHandler.map(Ingredient.Value[].class, type -> {
            JsonArray array = new JsonArray();
            for (Ingredient.Value ingredient : type) {
                array.add(JSONSerializableDataHandler.write(Ingredient.Value.class, ingredient));
            }
            return array;
        }, element -> {
            Ingredient.Value[] ingredient = new Ingredient.Value[element.getAsJsonArray().size()];
            int i = 0;
            for (JsonElement jsonElement : element.getAsJsonArray()) {
                ingredient[i] = JSONSerializableDataHandler.read(Ingredient.Value.class, jsonElement);
                ++i;
            }
            return ingredient;
        });
        JSONSerializableDataHandler.map(CompoundTag.class, type -> new JsonPrimitive(type.toString()), element -> {
            try {
                return TagParser.parseTag((String)element.getAsString());
            }
            catch (CommandSyntaxException e) {
                Titanium.LOGGER.catching((Throwable)e);
                return new CompoundTag();
            }
        });
    }

    public static interface Reader<T> {
        public T read(JsonElement var1);
    }

    public static interface Writer<T> {
        public JsonElement write(T var1);
    }
}

