/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.block.tile;

import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.api.client.IScreenAddonProvider;
import com.hrznstudio.titanium.api.filter.IFilter;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.block.RotatableBlock;
import com.hrznstudio.titanium.block.tile.BasicTile;
import com.hrznstudio.titanium.block.tile.ITickableBlockEntity;
import com.hrznstudio.titanium.client.screen.asset.IAssetProvider;
import com.hrznstudio.titanium.client.screen.asset.IHasAssetProvider;
import com.hrznstudio.titanium.component.IComponentBundle;
import com.hrznstudio.titanium.component.button.ButtonComponent;
import com.hrznstudio.titanium.component.button.MultiButtonComponent;
import com.hrznstudio.titanium.component.filter.MultiFilterComponent;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.hrznstudio.titanium.component.fluid.MultiTankComponent;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.component.inventory.MultiInventoryComponent;
import com.hrznstudio.titanium.component.progress.MultiProgressBarHandler;
import com.hrznstudio.titanium.component.progress.ProgressBarComponent;
import com.hrznstudio.titanium.component.sideness.IFacingComponent;
import com.hrznstudio.titanium.component.sideness.IFacingComponentHarness;
import com.hrznstudio.titanium.container.BasicAddonContainer;
import com.hrznstudio.titanium.container.addon.IContainerAddon;
import com.hrznstudio.titanium.container.addon.IContainerAddonProvider;
import com.hrznstudio.titanium.network.IButtonHandler;
import com.hrznstudio.titanium.network.locator.LocatorFactory;
import com.hrznstudio.titanium.network.locator.instance.TileEntityLocatorInstance;
import com.hrznstudio.titanium.util.FacingUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MilkBucketItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.items.IItemHandler;

public abstract class ActiveTile<T extends ActiveTile<T>>
extends BasicTile<T>
implements IScreenAddonProvider,
ITickableBlockEntity<T>,
MenuProvider,
IButtonHandler,
IFacingComponentHarness,
IContainerAddonProvider,
IHasAssetProvider {
    private MultiInventoryComponent<T> multiInventoryComponent;
    private MultiProgressBarHandler<T> multiProgressBarHandler;
    private MultiTankComponent<T> multiTankComponent;
    private MultiButtonComponent multiButtonComponent;
    private MultiFilterComponent multiFilterComponent;
    private List<IFactory<? extends IScreenAddon>> guiAddons = new ArrayList<IFactory<? extends IScreenAddon>>();
    private List<IFactory<? extends IContainerAddon>> containerAddons = new ArrayList<IFactory<? extends IContainerAddon>>();
    private List<IComponentBundle> bundles = new ArrayList<IComponentBundle>();

    public ActiveTile(BasicTileBlock<T> base, BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(base, blockEntityType, pos, state);
    }

    @Override
    @ParametersAreNonnullByDefault
    public ItemInteractionResult onActivated(Player player, InteractionHand hand, Direction facing, double hitX, double hitY, double hitZ) {
        if (this.multiTankComponent != null && FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (IFluidHandler)this.multiTankComponent.getCapabilityForSide(null).orElse(new MultiTankComponent.MultiTankCapabilityHandler(new ArrayList())))) {
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
    }

    @Override
    public void onNeighborChanged(Block blockIn, BlockPos fromPos) {
    }

    public void openGui(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            sp.openMenu((MenuProvider)this, buffer -> LocatorFactory.writePacketBuffer(buffer, new TileEntityLocatorInstance(this.worldPosition)));
        }
    }

    @Nullable
    public AbstractContainerMenu createMenu(int menu, Inventory inventoryPlayer, Player entityPlayer) {
        return new BasicAddonContainer(this, new TileEntityLocatorInstance(this.worldPosition), this.getWorldPosCallable(), inventoryPlayer, menu);
    }

    @Nonnull
    public Component getDisplayName() {
        return Component.translatable((String)this.getBasicTileBlock().getDescriptionId()).setStyle(Style.EMPTY.withColor(ChatFormatting.DARK_GRAY));
    }

    public void addInventory(InventoryComponent<T> handler) {
        if (this.multiInventoryComponent == null) {
            this.multiInventoryComponent = new MultiInventoryComponent();
        }
        this.multiInventoryComponent.add(handler.setComponentHarness(this.getSelf()));
    }

    public void addProgressBar(ProgressBarComponent<T> progressBarComponent) {
        if (this.multiProgressBarHandler == null) {
            this.multiProgressBarHandler = new MultiProgressBarHandler();
        }
        this.multiProgressBarHandler.add(progressBarComponent.setComponentHarness(this.getSelf()));
    }

    public void addTank(FluidTankComponent<T> tank) {
        if (this.multiTankComponent == null) {
            this.multiTankComponent = new MultiTankComponent();
        }
        this.multiTankComponent.add(tank.setComponentHarness(this.getSelf()));
    }

    public void addButton(ButtonComponent button) {
        if (this.multiButtonComponent == null) {
            this.multiButtonComponent = new MultiButtonComponent();
        }
        this.multiButtonComponent.add(button);
    }

    public void addFilter(IFilter<?> filter) {
        if (this.multiFilterComponent == null) {
            this.multiFilterComponent = new MultiFilterComponent();
        }
        this.multiFilterComponent.add(filter);
    }

    public void addBundle(IComponentBundle bundle) {
        if (this.multiInventoryComponent == null) {
            this.multiInventoryComponent = new MultiInventoryComponent();
        }
        if (this.multiProgressBarHandler == null) {
            this.multiProgressBarHandler = new MultiProgressBarHandler();
        }
        if (this.multiTankComponent == null) {
            this.multiTankComponent = new MultiTankComponent();
        }
        if (this.multiButtonComponent == null) {
            this.multiButtonComponent = new MultiButtonComponent();
        }
        if (this.multiFilterComponent == null) {
            this.multiFilterComponent = new MultiFilterComponent();
        }
        bundle.accept(this.multiInventoryComponent, this.multiProgressBarHandler, this.multiTankComponent, this.multiButtonComponent, this.multiFilterComponent);
        bundle.getContainerAddons().forEach(this::addContainerAddonFactory);
        this.bundles.add(bundle);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void initClient() {
        super.initClient();
        this.bundles.stream().forEach(iComponentBundle -> iComponentBundle.getScreenAddons().forEach(this::addGuiAddonFactory));
    }

    public MultiInventoryComponent<T> getMultiInventoryComponent() {
        return this.multiInventoryComponent;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void addGuiAddonFactory(IFactory<? extends IScreenAddon> factory) {
        this.guiAddons.add(factory);
    }

    public void addContainerAddonFactory(IFactory<? extends IContainerAddon> factory) {
        this.containerAddons.add(factory);
    }

    @Override
    public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
        ArrayList<IFactory<? extends IScreenAddon>> addons = new ArrayList<IFactory<? extends IScreenAddon>>(this.guiAddons);
        if (this.multiInventoryComponent != null) {
            addons.addAll(this.multiInventoryComponent.getScreenAddons());
        }
        if (this.multiProgressBarHandler != null) {
            addons.addAll(this.multiProgressBarHandler.getScreenAddons());
        }
        if (this.multiTankComponent != null) {
            addons.addAll(this.multiTankComponent.getScreenAddons());
        }
        if (this.multiButtonComponent != null) {
            addons.addAll(this.multiButtonComponent.getScreenAddons());
        }
        if (this.multiFilterComponent != null) {
            addons.addAll(this.multiFilterComponent.getScreenAddons());
        }
        return addons;
    }

    @Override
    public List<IFactory<? extends IContainerAddon>> getContainerAddons() {
        ArrayList<IFactory<? extends IContainerAddon>> addons = new ArrayList<IFactory<? extends IContainerAddon>>(this.containerAddons);
        if (this.multiInventoryComponent != null) {
            addons.addAll(this.multiInventoryComponent.getContainerAddons());
        }
        if (this.multiProgressBarHandler != null) {
            addons.addAll(this.multiProgressBarHandler.getContainerAddons());
        }
        if (this.multiTankComponent != null) {
            addons.addAll(this.multiTankComponent.getContainerAddons());
        }
        return addons;
    }

    @Override
    public IAssetProvider getAssetProvider() {
        return IAssetProvider.DEFAULT_PROVIDER;
    }

    @Override
    public void serverTick(Level level, BlockPos pos, BlockState state, T blockEntity) {
        if (this.multiProgressBarHandler != null) {
            this.multiProgressBarHandler.update();
        }
        if (level.getGameTime() % (long)this.getFacingHandlerWorkTime() == 0L) {
            if (this.multiInventoryComponent != null) {
                for (InventoryComponent inventoryComponent : this.multiInventoryComponent.getInventoryHandlers()) {
                    if (!(inventoryComponent instanceof IFacingComponent)) continue;
                    ((IFacingComponent)((Object)inventoryComponent)).work(this.level, this.worldPosition, this.getFacingDirection(), this.getFacingHandlerWorkAmount());
                }
            }
            if (this.multiTankComponent != null) {
                for (FluidTankComponent fluidTankComponent : this.multiTankComponent.getTanks()) {
                    if (!(fluidTankComponent instanceof IFacingComponent)) continue;
                    ((IFacingComponent)((Object)fluidTankComponent)).work(this.level, this.worldPosition, this.getFacingDirection(), this.getFacingHandlerWorkAmount());
                }
            }
        }
    }

    public int getFacingHandlerWorkTime() {
        return 10;
    }

    public int getFacingHandlerWorkAmount() {
        return 4;
    }

    public MultiButtonComponent getMultiButtonComponent() {
        return this.multiButtonComponent;
    }

    public Direction getFacingDirection() {
        return this.level.getBlockState(this.worldPosition).hasProperty((Property)RotatableBlock.FACING_ALL) ? (Direction)this.level.getBlockState(this.worldPosition).getValue((Property)RotatableBlock.FACING_ALL) : (this.level.getBlockState(this.worldPosition).hasProperty((Property)RotatableBlock.FACING_HORIZONTAL) ? (Direction)this.level.getBlockState(this.worldPosition).getValue((Property)RotatableBlock.FACING_HORIZONTAL) : Direction.NORTH);
    }

    @Override
    public IFacingComponent getHandlerFromName(String string) {
        if (this.multiInventoryComponent != null) {
            for (InventoryComponent inventoryComponent : this.multiInventoryComponent.getInventoryHandlers()) {
                if (!(inventoryComponent instanceof IFacingComponent) || !inventoryComponent.getName().equalsIgnoreCase(string)) continue;
                return (IFacingComponent)((Object)inventoryComponent);
            }
        }
        if (this.multiTankComponent != null) {
            for (FluidTankComponent fluidTankComponent : this.multiTankComponent.getTanks()) {
                if (!(fluidTankComponent instanceof IFacingComponent) || !fluidTankComponent.getName().equalsIgnoreCase(string)) continue;
                return (IFacingComponent)((Object)fluidTankComponent);
            }
        }
        return null;
    }

    @Override
    public void handleButtonMessage(int id, Player playerEntity, CompoundTag compound) {
        if (id == -3 && !compound.contains("Invalid") && compound.contains("Fill") && !playerEntity.containerMenu.getCarried().isEmpty()) {
            boolean fill = compound.getBoolean("Fill");
            String name = compound.getString("Name");
            if (this.multiTankComponent != null) {
                for (FluidTankComponent fluidTankComponent : this.multiTankComponent.getTanks()) {
                    if (!fluidTankComponent.getName().equalsIgnoreCase(name)) continue;
                    Optional.ofNullable((IFluidHandlerItem)playerEntity.containerMenu.getCarried().getCapability(Capabilities.FluidHandler.ITEM)).ifPresent(iFluidHandlerItem -> {
                        boolean isBucket;
                        Item carriedItem = playerEntity.containerMenu.getCarried().getItem();
                        boolean bl = isBucket = carriedItem instanceof BucketItem || carriedItem instanceof MilkBucketItem;
                        if (fill) {
                            int amount = isBucket ? 1000 : Integer.MAX_VALUE;
                            amount = fluidTankComponent.fill(iFluidHandlerItem.drain(amount, IFluidHandler.FluidAction.SIMULATE), IFluidHandler.FluidAction.EXECUTE);
                            iFluidHandlerItem.drain(amount, IFluidHandler.FluidAction.EXECUTE);
                        } else {
                            int amount = isBucket ? 1000 : Integer.MAX_VALUE;
                            amount = iFluidHandlerItem.fill(fluidTankComponent.drain(amount, IFluidHandler.FluidAction.SIMULATE), IFluidHandler.FluidAction.EXECUTE);
                            fluidTankComponent.drain(amount, IFluidHandler.FluidAction.EXECUTE);
                        }
                        playerEntity.containerMenu.setCarried(iFluidHandlerItem.getContainer().copy());
                        if (playerEntity instanceof ServerPlayer) {
                            playerEntity.containerMenu.broadcastChanges();
                        }
                    });
                }
            }
        }
        if (id == -2) {
            String name = compound.getString("Name");
            if (this.multiFilterComponent != null) {
                for (IFilter filter : this.multiFilterComponent.getFilters()) {
                    if (!filter.getName().equals(name)) continue;
                    int slot = compound.getInt("Slot");
                    filter.setFilter(slot, ItemStack.parseOptional((HolderLookup.Provider)this.level.registryAccess(), (CompoundTag)compound.getCompound("Filter")));
                    this.markForUpdate();
                    break;
                }
            }
        }
        if (id == -1) {
            String name = compound.getString("Name");
            FacingUtil.Sideness facing = FacingUtil.Sideness.valueOf(compound.getString("Facing"));
            int faceMode = compound.getInt("Next");
            if (this.multiInventoryComponent != null && this.multiInventoryComponent.handleFacingChange(name, facing, faceMode)) {
                this.invalidateCapabilities();
                this.markForUpdate();
            } else if (this.multiTankComponent != null && this.multiTankComponent.handleFacingChange(name, facing, faceMode)) {
                this.invalidateCapabilities();
                this.markForUpdate();
            }
        } else if (this.multiButtonComponent != null) {
            this.multiButtonComponent.clickButton(id, playerEntity, compound);
        }
    }

    @Nonnull
    public abstract T getSelf();

    @Override
    public Level getComponentWorld() {
        return this.getSelf().getLevel();
    }

    @Override
    public void markComponentDirty() {
        super.setChanged();
    }

    @Override
    public void markComponentForUpdate(boolean referenced) {
        if (!referenced) {
            super.markForUpdate();
        } else {
            this.markComponentDirty();
        }
    }

    public ContainerLevelAccess getWorldPosCallable() {
        return this.getLevel() != null ? ContainerLevelAccess.create((Level)this.getLevel(), (BlockPos)this.getBlockPos()) : ContainerLevelAccess.NULL;
    }

    @Override
    public boolean canInteract() {
        return this.level.getBlockEntity(this.worldPosition) == this;
    }

    public MultiTankComponent<T> getMultiTankComponent() {
        return this.multiTankComponent;
    }

    public IFluidHandler getFluidHandler(@Nullable Direction direction) {
        return this.multiTankComponent == null ? null : (IFluidHandler)this.multiTankComponent.getCapabilityForSide(FacingUtil.getFacingRelative(this.getFacingDirection(), direction)).orElse(null);
    }

    public IItemHandler getItemHandler(@Nullable Direction direction) {
        return this.multiInventoryComponent == null ? null : (IItemHandler)this.multiInventoryComponent.getCapabilityForSide(FacingUtil.getFacingRelative(this.getFacingDirection(), direction)).orElse(null);
    }

    public MultiFilterComponent getMultiFilterComponent() {
        return this.multiFilterComponent;
    }

    @Override
    public void loadAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.loadAdditional(compound, provider);
        if (this.multiInventoryComponent != null) {
            this.multiInventoryComponent.rebuildCapability(FacingUtil.Sideness.values());
        }
        if (this.multiTankComponent != null) {
            this.multiTankComponent.rebuildCapability(FacingUtil.Sideness.values());
        }
    }
}

