/*
 * Decompiled with CFR 0.152.
 */
package reliquary.compat.jei.lingering;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.level.ItemLike;
import reliquary.init.ModItems;
import reliquary.util.RegistryHelper;
import reliquary.util.potions.PotionEssence;
import reliquary.util.potions.PotionHelper;
import reliquary.util.potions.PotionMap;

public class ArrowShotRecipeMaker {
    private ArrowShotRecipeMaker() {
    }

    public static List<RecipeHolder<CraftingRecipe>> getRecipes(ItemStack output, String itemName) {
        return ArrowShotRecipeMaker.getRecipes(output, output, 0.2f, itemName);
    }

    public static List<RecipeHolder<CraftingRecipe>> getRecipes(ItemStack output, ItemStack itemStack, float durationFactor, String itemName) {
        ArrayList<RecipeHolder<CraftingRecipe>> recipes = new ArrayList<RecipeHolder<CraftingRecipe>>();
        String group = "reliquary.potion." + itemName;
        for (PotionEssence essence : PotionMap.uniquePotions) {
            ItemStack potion = new ItemStack((ItemLike)ModItems.LINGERING_POTION.get());
            PotionHelper.addPotionContentsToStack(potion, essence.getPotionContents());
            ItemStack outputCopy = output.copy();
            outputCopy.setCount(8);
            PotionHelper.addPotionContentsToStack(outputCopy, PotionHelper.changePotionEffectsDuration(essence.getPotionContents(), durationFactor));
            NonNullList ingredients = NonNullList.create();
            ingredients.addAll(Collections.nCopies(4, Ingredient.of((ItemStack[])new ItemStack[]{itemStack})));
            ingredients.add((Object)Ingredient.of((ItemStack[])new ItemStack[]{potion}));
            ingredients.addAll(Collections.nCopies(4, Ingredient.of((ItemStack[])new ItemStack[]{itemStack})));
            ShapedRecipePattern pattern = new ShapedRecipePattern(3, 3, ingredients, Optional.empty());
            recipes.add((RecipeHolder<CraftingRecipe>)new RecipeHolder(RegistryHelper.getRegistryName(output.getItem()), (Recipe)new ShapedRecipe(group, CraftingBookCategory.MISC, pattern, outputCopy)));
        }
        return recipes;
    }
}

