/*
 * Decompiled with CFR 0.152.
 */
package auroras.util;

import auroras.Auroras;
import auroras.config.Config;
import auroras.util.AuroraData;
import auroras.util.Noise2D;
import auroras.util.OpenSimplex2D;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.Objects;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.calendar.ICalendar;
import net.dries007.tfc.world.ChunkGeneratorExtension;
import net.irisshaders.iris.Iris;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.jetbrains.annotations.Nullable;

public class AHelpers {
    public static final KeyMapping RELOAD_AURORA_CONFIGS = new KeyMapping("auroras.key.reload_aurora_configs", (IKeyConflictContext)KeyConflictContext.UNIVERSAL, InputConstants.Type.KEYSYM, -1, "Auroras");

    public static ArtifactVersion getVersion() {
        return ((ModContainer)ModList.get().getModContainerById("auroras").get()).getModInfo().getVersion();
    }

    public static int compareVersions(String oldVersion) {
        return ((ModContainer)ModList.get().getModContainerById("auroras").get()).getModInfo().getVersion().compareTo((Object)new DefaultArtifactVersion(oldVersion));
    }

    @Nullable
    public static Level getLevel() {
        return Minecraft.getInstance().level;
    }

    public static Level getLevelOrThrow() {
        return Objects.requireNonNull(AHelpers.getLevel());
    }

    public static Level getUnsafeLevel(Object maybeLevel) {
        if (maybeLevel instanceof Level) {
            Level level = (Level)maybeLevel;
            return level;
        }
        if (maybeLevel instanceof WorldGenRegion) {
            WorldGenRegion level = (WorldGenRegion)maybeLevel;
            return level.getLevel();
        }
        return null;
    }

    public static Level getMaybeLevelFromClient() {
        if (Minecraft.getInstance().level != null && Minecraft.getInstance().level.getServer() != null) {
            return AHelpers.getUnsafeLevel(Minecraft.getInstance().level.getServer().overworld());
        }
        return null;
    }

    public static ChunkGeneratorExtension getMaybeChunkExtension(ServerLevelAccessor maybeLevel) {
        if (maybeLevel != null && maybeLevel instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)maybeLevel;
            return (ChunkGeneratorExtension)server.getChunkSource().getGenerator();
        }
        return null;
    }

    public static double hemisphereScale(ServerLevelAccessor level) {
        return (double)AHelpers.getMaybeChunkExtension(level).settings().temperatureScale() * 0.5;
    }

    public static double equator(ServerLevelAccessor level) {
        return AHelpers.hemisphereScale(level);
    }

    public static double getEquator(AuroraData data, Level level) {
        double equator = data.equatorZ;
        if (ModList.get().isLoaded("tfc") && level.getServer() != null && level.getServer().overworld().getLevel() != null && level.dimension() == Level.OVERWORLD) {
            equator = AHelpers.equator((ServerLevelAccessor)level.getServer().overworld().getLevel());
        }
        return equator;
    }

    public static double getDistanceToPole(AuroraData data, Level level, double offset) {
        double blocks90 = data.blocks90;
        if (ModList.get().isLoaded("tfc") && level.getServer() != null && level.getServer().overworld().getLevel() != null && level.dimension() == Level.OVERWORLD) {
            blocks90 = AHelpers.hemisphereScale((ServerLevelAccessor)level.getServer().overworld().getLevel()) * 2.0;
        }
        return blocks90 + offset;
    }

    public static boolean getEndlessPoles(AuroraData data, Level level) {
        return data.endlessPoles;
    }

    public static double angleFromPole(AuroraData data, Level level, Minecraft minecraft, double offset) {
        return AHelpers.angleFromPole(data, level, minecraft.player.getZ(), offset);
    }

    public static double angleFromPole(AuroraData data, Level level, double z, double offset) {
        double equator = AHelpers.getEquator(data, level);
        double blocks90 = AHelpers.getDistanceToPole(data, level, offset);
        double angle = 90.0 * (z - equator) / blocks90;
        return AHelpers.modulo(angle + 90.0, 180.0);
    }

    public static double modulo(double number, double divisor) {
        double result = number % divisor;
        return result < 0.0 ? result + divisor : result;
    }

    public static Noise2D waveNoise(long seed, int octaves, float scale, int minHeight, int maxHeight) {
        OpenSimplex2D warp = new OpenSimplex2D(seed).octaves(octaves).spread(0.03f).scaled(-scale, scale);
        return new OpenSimplex2D(seed + 1L).octaves(octaves).spread(0.06f).warped(warp).map(x -> x > 0.4 ? x - (double)0.8f : -x).scaled(-0.4f, 0.8f, minHeight, maxHeight);
    }

    public static double sunStormIntensity(double x, long seed, int octaves, int minHeight, int maxHeight, double factor) {
        return AHelpers.waveNoise(seed, octaves, 100.0f, minHeight, maxHeight).noise(x, 0.0) * factor;
    }

    public static double getAutoFogMaxDistance() {
        return (Double)Config.STARTUP.auroraRenderDistance.get();
    }

    public static boolean areShadersEnabled() {
        if (ModList.get().isLoaded("oculus") || ModList.get().isLoaded("iris")) {
            return Iris.getIrisConfig().areShadersEnabled();
        }
        return false;
    }

    public static double getDayOfYear(AuroraData data, Level level) {
        if (ModList.get().isLoaded("tfc") && level.dimension() == Level.OVERWORLD) {
            ICalendar calendar = Calendars.get((LevelReader)level);
            int yearLength = calendar.getCalendarDaysInMonth() * 12;
            return calendar.getCalendarTicks() / 24000L % (long)yearLength;
        }
        return level.getGameTime() / 24000L % (long)data.yearLength;
    }

    public static double getYear(AuroraData data, Level level) {
        if (ModList.get().isLoaded("tfc") && level.dimension() == Level.OVERWORLD) {
            ICalendar calendar = Calendars.get((LevelReader)level);
            int yearLength = calendar.getCalendarDaysInMonth() * 12;
            return Math.floor(AHelpers.getDayOfYear(data, level)) / (double)yearLength % (double)yearLength;
        }
        return Math.floor(AHelpers.getDayOfYear(data, level)) / (double)data.yearLength % (double)data.yearLength;
    }

    public static float lerp(float delta, float min, float max) {
        return min + (max - min) * delta;
    }

    public static double lerp(double delta, double min, double max) {
        return min + (max - min) * delta;
    }

    public static double lerpSine(double delta, double min, double max) {
        delta = Math.max(0.0, Math.min(1.0, delta));
        double sineValue = -(Math.cos(Math.PI * delta) - 1.0) / 2.0;
        return min + (max - min) * sineValue;
    }

    public static float[] lerpSine(float delta, float[] start, float[] end) {
        delta = Math.max(0.0f, Math.min(1.0f, delta));
        float sineValue = -((float)(Math.cos(Math.PI * (double)delta) - 1.0)) / 2.0f;
        float[] result = new float[start.length];
        for (int i = 0; i < start.length; ++i) {
            result[i] = start[i] + (end[i] - start[i]) * sineValue;
        }
        return result;
    }

    public static double convertToDouble(JsonElement json, String memberName, double fallback) {
        if (json.isJsonPrimitive() && json.getAsJsonPrimitive().isNumber()) {
            return json.getAsDouble();
        }
        Auroras.LOGGER.error("Expected " + memberName + " to be a Double, was " + GsonHelper.getType((JsonElement)json));
        return fallback;
    }

    public static double getAsDouble(JsonObject json, String memberName, double fallback) {
        return json.has(memberName) ? AHelpers.convertToDouble(json.get(memberName), memberName, fallback) : fallback;
    }

    public static int convertToInt(JsonElement json, String memberName, int fallback) {
        if (json.isJsonPrimitive() && json.getAsJsonPrimitive().isNumber()) {
            return json.getAsInt();
        }
        Auroras.LOGGER.error("Expected " + memberName + " to be a Int, was " + GsonHelper.getType((JsonElement)json));
        return fallback;
    }

    public static int getAsInt(JsonObject json, String memberName, int fallback) {
        return json.has(memberName) ? AHelpers.convertToInt(json.get(memberName), memberName, fallback) : fallback;
    }

    public static boolean convertToBoolean(JsonElement json, String memberName, boolean fallback) {
        if (json.isJsonPrimitive()) {
            return json.getAsBoolean();
        }
        Auroras.LOGGER.error("Expected " + memberName + " to be a Boolean, was " + GsonHelper.getType((JsonElement)json));
        return fallback;
    }

    public static boolean getAsBoolean(JsonObject json, String memberName, boolean fallback) {
        return json.has(memberName) ? AHelpers.convertToBoolean(json.get(memberName), memberName, fallback) : fallback;
    }

    public static String convertToString(JsonElement json, String memberName, String fallback) {
        if (json.isJsonPrimitive()) {
            return json.getAsString();
        }
        Auroras.LOGGER.error("Expected " + memberName + " to be a String, was " + GsonHelper.getType((JsonElement)json));
        return fallback;
    }

    public static String getAsString(JsonObject json, String memberName, String fallback) {
        return json.has(memberName) ? AHelpers.convertToString(json.get(memberName), memberName, fallback) : fallback;
    }
}

