/*
 * Decompiled with CFR 0.152.
 */
package auroras.mixin.client;

import auroras.ClientEventHandler;
import auroras.util.AuroraData;
import com.aetherteam.aether.client.renderer.level.AetherSkyRenderEffects;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.level.Level;
import net.neoforged.fml.ModList;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AetherSkyRenderEffects.class}, priority=10)
public abstract class AetherSkyRenderEffectsMixin
implements IMixinConfigPlugin {
    @Inject(method={"renderSky"}, at={@At(value="TAIL")}, cancellable=true, remap=false)
    private void inject$renderSky(ClientLevel level, int ticks, float partialTicks, Matrix4f modelViewMatrix, Camera camera, Matrix4f projectionMatrix, boolean isFoggy, Runnable setupFog, CallbackInfoReturnable<Boolean> cir) {
        for (AuroraData data : AuroraData.getDataList((Level)level)) {
            if (data == null) continue;
            for (String dimension : data.allowedDimensions) {
                if (!dimension.equals(level.dimension().location().toString())) continue;
                PoseStack poseStack = new PoseStack();
                poseStack.mulPose(modelViewMatrix);
                ClientEventHandler.AURORA.render(data, Minecraft.getInstance(), (Level)level, poseStack, projectionMatrix, partialTicks);
            }
        }
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        return ModList.get().isLoaded("aether");
    }
}

