/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds.pillar;

import net.minecraft.core.Direction;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WallSide;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.data.skippreds.CornerDir;
import xfacthd.framedblocks.common.data.skippreds.HalfDir;
import xfacthd.framedblocks.common.data.skippreds.TriangleDir;

public final class PillarDirs {

    public static final class Post {
        public static boolean testEarlyExit(Direction.Axis axis, Direction side) {
            return side.getAxis() != axis;
        }

        public static boolean isPostDir(Direction.Axis axis, Direction side) {
            return side.getAxis() == axis;
        }

        private Post() {
        }
    }

    public static final class PillarSocket {
        public static HalfDir getHalfDir(Direction dir, Direction side) {
            if (side.getAxis() != dir.getAxis()) {
                return HalfDir.fromDirections(side, dir);
            }
            return HalfDir.NULL;
        }

        public static boolean isPillarDir(Direction dir, Direction side) {
            return side == dir.getOpposite();
        }

        private PillarSocket() {
        }
    }

    public static final class HalfPillar {
        public static boolean testEarlyExit(Direction dir, Direction side) {
            return side != dir;
        }

        public static boolean isPillarDir(Direction dir, Direction side) {
            return side == dir;
        }

        private HalfPillar() {
        }
    }

    public static final class Pillar {
        public static boolean testEarlyExit(Direction.Axis axis, Direction side) {
            return side.getAxis() != axis;
        }

        public static boolean isPillarDir(Direction.Axis axis, Direction side) {
            return side.getAxis() == axis;
        }

        private Pillar() {
        }
    }

    public static final class ThickLattice {
        public static boolean testEarlyExit(boolean xAxis, boolean yAxis, boolean zAxis, Direction side) {
            return switch (side.getAxis()) {
                default -> throw new MatchException(null, null);
                case Direction.Axis.X -> {
                    if (!xAxis) {
                        yield true;
                    }
                    yield false;
                }
                case Direction.Axis.Y -> {
                    if (!yAxis) {
                        yield true;
                    }
                    yield false;
                }
                case Direction.Axis.Z -> !zAxis;
            };
        }

        public static boolean isPillarDir(boolean xAxis, boolean yAxis, boolean zAxis, Direction side) {
            return switch (side.getAxis()) {
                default -> throw new MatchException(null, null);
                case Direction.Axis.X -> xAxis;
                case Direction.Axis.Y -> yAxis;
                case Direction.Axis.Z -> zAxis;
            };
        }

        private ThickLattice() {
        }
    }

    public static final class Lattice {
        public static boolean testEarlyExit(boolean xAxis, boolean yAxis, boolean zAxis, Direction side) {
            return switch (side.getAxis()) {
                default -> throw new MatchException(null, null);
                case Direction.Axis.X -> {
                    if (!xAxis) {
                        yield true;
                    }
                    yield false;
                }
                case Direction.Axis.Y -> {
                    if (!yAxis) {
                        yield true;
                    }
                    yield false;
                }
                case Direction.Axis.Z -> !zAxis;
            };
        }

        public static boolean isPostDir(boolean xAxis, boolean yAxis, boolean zAxis, Direction side) {
            return switch (side.getAxis()) {
                default -> throw new MatchException(null, null);
                case Direction.Axis.X -> xAxis;
                case Direction.Axis.Y -> yAxis;
                case Direction.Axis.Z -> zAxis;
            };
        }

        private Lattice() {
        }
    }

    public static final class Fence {
        public static boolean testFenceArmDir(BlockState state, BlockState adjState, Direction side) {
            return !Utils.isY(side) && Fence.hasFenceArm(state, side) && Fence.hasFenceArm(adjState, side.getOpposite());
        }

        public static boolean testFenceArmToGateDir(BlockState state, BlockState adjState, Direction side) {
            if (!Utils.isY(side) && Fence.hasFenceArm(state, side)) {
                Direction adjDir = (Direction)adjState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
                return adjDir.getClockWise().getAxis() == side.getAxis();
            }
            return false;
        }

        private static boolean hasFenceArm(BlockState state, Direction side) {
            return switch (side) {
                case Direction.NORTH -> (Boolean)state.getValue((Property)FenceBlock.NORTH);
                case Direction.EAST -> (Boolean)state.getValue((Property)FenceBlock.EAST);
                case Direction.SOUTH -> (Boolean)state.getValue((Property)FenceBlock.SOUTH);
                case Direction.WEST -> (Boolean)state.getValue((Property)FenceBlock.WEST);
                default -> throw new IllegalArgumentException("Invalid fence arm side: " + String.valueOf(side));
            };
        }

        public static boolean isPostDir(Direction side) {
            return Utils.isY(side);
        }

        private Fence() {
        }
    }

    public static final class Wall {
        public static boolean testWallArmDir(BlockState state, BlockState adjState, Direction side) {
            if (!Utils.isY(side)) {
                WallSide wallSide = Wall.getWallSide(state, side);
                WallSide adjWallSide = Wall.getWallSide(adjState, side.getOpposite());
                return wallSide != WallSide.NONE && wallSide == adjWallSide;
            }
            return false;
        }

        public static WallSide getWallSide(BlockState state, Direction side) {
            return switch (side) {
                case Direction.NORTH -> (WallSide)state.getValue((Property)WallBlock.NORTH_WALL);
                case Direction.EAST -> (WallSide)state.getValue((Property)WallBlock.EAST_WALL);
                case Direction.SOUTH -> (WallSide)state.getValue((Property)WallBlock.SOUTH_WALL);
                case Direction.WEST -> (WallSide)state.getValue((Property)WallBlock.WEST_WALL);
                default -> throw new IllegalArgumentException("Invalid wall arm direction");
            };
        }

        public static boolean isPillarDir(boolean up, Direction side) {
            return up && Utils.isY(side);
        }

        private Wall() {
        }
    }

    public static final class ThreewayCornerPillar {
        public static TriangleDir getStairDir(Direction dir, boolean top, Direction side) {
            if (side == dir) {
                return TriangleDir.fromDirections(dir.getCounterClockWise(), top ? Direction.UP : Direction.DOWN);
            }
            if (side == dir.getCounterClockWise()) {
                return TriangleDir.fromDirections(dir, top ? Direction.UP : Direction.DOWN);
            }
            if (!top && side == Direction.DOWN || top && side == Direction.UP) {
                return TriangleDir.fromDirections(dir, dir.getCounterClockWise());
            }
            return TriangleDir.NULL;
        }

        public static CornerDir getCornerDir(Direction dir, boolean top, Direction side) {
            if (!top && side == Direction.UP || top && side == Direction.DOWN) {
                return CornerDir.fromDirections(side, dir, dir.getCounterClockWise());
            }
            if (side == dir.getClockWise()) {
                return CornerDir.fromDirections(side, dir, top ? Direction.UP : Direction.DOWN);
            }
            if (side == dir.getOpposite()) {
                return CornerDir.fromDirections(side, dir.getCounterClockWise(), top ? Direction.UP : Direction.DOWN);
            }
            return CornerDir.NULL;
        }

        private ThreewayCornerPillar() {
        }
    }

    public static final class CornerPillar {
        public static HalfDir getHalfDir(Direction dir, Direction side) {
            if (side == dir) {
                return HalfDir.fromDirections(side, dir.getCounterClockWise());
            }
            if (side == dir.getCounterClockWise()) {
                return HalfDir.fromDirections(side, dir);
            }
            return HalfDir.NULL;
        }

        public static CornerDir getCornerDir(Direction dir, Direction side) {
            if (Utils.isY(side)) {
                return CornerDir.fromDirections(side, dir, dir.getCounterClockWise());
            }
            return CornerDir.NULL;
        }

        private CornerPillar() {
        }
    }
}

