/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds.door;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.predicate.cull.SideSkipPredicate;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.skippreds.CullTest;
import xfacthd.framedblocks.common.data.skippreds.door.DoorDirs;

@CullTest(value={BlockType.FRAMED_TRAPDOOR, BlockType.FRAMED_IRON_TRAPDOOR})
public final class TrapdoorSkipPredicate
implements SideSkipPredicate {
    public static final TrapdoorSkipPredicate INSTANCE = new TrapdoorSkipPredicate();

    private TrapdoorSkipPredicate() {
    }

    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        Object object = adjState.getBlock();
        if (object instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType blockType = (BlockType)object;
            Direction dir = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
            Half half = (Half)state.getValue((Property)BlockStateProperties.HALF);
            boolean open = (Boolean)state.getValue((Property)BlockStateProperties.OPEN);
            return switch (blockType) {
                case BlockType.FRAMED_TRAPDOOR, BlockType.FRAMED_IRON_TRAPDOOR -> TrapdoorSkipPredicate.testAgainstTrapdoor(dir, half, open, adjState, side);
                case BlockType.FRAMED_DOOR, BlockType.FRAMED_IRON_DOOR -> TrapdoorSkipPredicate.testAgainstDoor(dir, half, open, adjState, side);
                case BlockType.FRAMED_GATE, BlockType.FRAMED_IRON_GATE -> TrapdoorSkipPredicate.testAgainstGate(dir, half, open, adjState, side);
                default -> false;
            };
        }
        return false;
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_TRAPDOOR, BlockType.FRAMED_IRON_TRAPDOOR})
    private static boolean testAgainstTrapdoor(Direction dir, Half half, boolean open, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        Half adjHalf = (Half)adjState.getValue((Property)BlockStateProperties.HALF);
        boolean adjOpen = (Boolean)adjState.getValue((Property)BlockStateProperties.OPEN);
        return DoorDirs.Trapdoor.getDoorEdgeDir(dir, half, open, side).isEqualTo(DoorDirs.Trapdoor.getDoorEdgeDir(adjDir, adjHalf, adjOpen, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_DOOR, BlockType.FRAMED_IRON_DOOR})
    private static boolean testAgainstDoor(Direction dir, Half half, boolean open, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        DoorHingeSide adjHinge = (DoorHingeSide)adjState.getValue((Property)BlockStateProperties.DOOR_HINGE);
        boolean adjOpen = (Boolean)adjState.getValue((Property)BlockStateProperties.OPEN);
        return DoorDirs.Trapdoor.getDoorEdgeDir(dir, half, open, side).isEqualTo(DoorDirs.Door.getDoorEdgeDir(adjDir, adjHinge, adjOpen, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_GATE, BlockType.FRAMED_IRON_GATE})
    private static boolean testAgainstGate(Direction dir, Half half, boolean open, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        DoorHingeSide adjHinge = (DoorHingeSide)adjState.getValue((Property)BlockStateProperties.DOOR_HINGE);
        boolean adjOpen = (Boolean)adjState.getValue((Property)BlockStateProperties.OPEN);
        return DoorDirs.Trapdoor.getDoorEdgeDir(dir, half, open, side).isEqualTo(DoorDirs.Gate.getDoorEdgeDir(adjDir, adjHinge, adjOpen, side.getOpposite()));
    }
}

