/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.shapes.slopeslab;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.shapes.ShapeCache;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.shapes.ShapeUtils;
import xfacthd.framedblocks.common.block.slopeslab.SlopeSlabShape;
import xfacthd.framedblocks.common.data.shapes.SplitShapeGenerator;
import xfacthd.framedblocks.common.data.shapes.slopeslab.SlopeSlabShapes;

public final class FlatElevatedSlopeSlabCornerShapes
implements SplitShapeGenerator {
    private static final ShapeCache<ShapeKey> FINAL_SHAPES = FlatElevatedSlopeSlabCornerShapes.makeCache(SlopeSlabShapes.SHAPES, BooleanOp.AND);
    private static final ShapeCache<ShapeKey> FINAL_OCCLUSION_SHAPES = FlatElevatedSlopeSlabCornerShapes.makeCache(SlopeSlabShapes.OCCLUSION_SHAPES, BooleanOp.AND);
    private static final ShapeCache<ShapeKey> FINAL_INNER_SHAPES = FlatElevatedSlopeSlabCornerShapes.makeCache(SlopeSlabShapes.SHAPES, BooleanOp.OR);
    private static final ShapeCache<ShapeKey> FINAL_INNER_OCCLUSION_SHAPES = FlatElevatedSlopeSlabCornerShapes.makeCache(SlopeSlabShapes.OCCLUSION_SHAPES, BooleanOp.OR);
    public static final FlatElevatedSlopeSlabCornerShapes OUTER = new FlatElevatedSlopeSlabCornerShapes(FINAL_SHAPES, FINAL_OCCLUSION_SHAPES);
    public static final FlatElevatedSlopeSlabCornerShapes INNER = new FlatElevatedSlopeSlabCornerShapes(FINAL_INNER_SHAPES, FINAL_INNER_OCCLUSION_SHAPES);
    private final ShapeCache<ShapeKey> shapes;
    private final ShapeCache<ShapeKey> occlusionShapes;

    private FlatElevatedSlopeSlabCornerShapes(ShapeCache<ShapeKey> shapes, ShapeCache<ShapeKey> occlusionShapes) {
        this.shapes = shapes;
        this.occlusionShapes = occlusionShapes;
    }

    @Override
    public ShapeProvider generate(ImmutableList<BlockState> states) {
        return FlatElevatedSlopeSlabCornerShapes.generate(states, this.shapes);
    }

    @Override
    public ShapeProvider generateOcclusionShapes(ImmutableList<BlockState> states) {
        return FlatElevatedSlopeSlabCornerShapes.generate(states, this.occlusionShapes);
    }

    private static ShapeProvider generate(ImmutableList<BlockState> states, ShapeCache<ShapeKey> cache) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BlockState state : states) {
            Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
            boolean top = (Boolean)state.getValue((Property)FramedProperties.TOP);
            builder.put((Object)state, (Object)cache.get(new ShapeKey(dir, top)));
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }

    private static ShapeCache<ShapeKey> makeCache(ShapeCache<SlopeSlabShape> cache, BooleanOp joinOp) {
        return ShapeCache.create(map -> {
            VoxelShape shapeSlopeBottom = cache.get(SlopeSlabShape.BOTTOM_TOP_HALF);
            VoxelShape shapeSlopeTop = cache.get(SlopeSlabShape.TOP_BOTTOM_HALF);
            VoxelShape shapeBottom = ShapeUtils.orUnoptimized(Shapes.joinUnoptimized((VoxelShape)shapeSlopeBottom, (VoxelShape)ShapeUtils.rotateShapeUnoptimizedAroundY(Direction.NORTH, Direction.WEST, shapeSlopeBottom), (BooleanOp)joinOp), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0));
            VoxelShape shapeTop = ShapeUtils.orUnoptimized(Shapes.joinUnoptimized((VoxelShape)shapeSlopeTop, (VoxelShape)ShapeUtils.rotateShapeUnoptimizedAroundY(Direction.NORTH, Direction.WEST, shapeSlopeTop), (BooleanOp)joinOp), Block.box((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
            ShapeUtils.makeHorizontalRotationsWithFlag(shapeBottom, shapeTop, Direction.NORTH, map, ShapeKey::new);
        });
    }

    private record ShapeKey(Direction dir, boolean top) {
    }
}

