/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.cullupdate;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import xfacthd.framedblocks.api.block.blockentity.FramedBlockEntity;
import xfacthd.framedblocks.client.util.ClientTaskQueue;
import xfacthd.framedblocks.common.data.cullupdate.CullingUpdateChunk;
import xfacthd.framedblocks.common.net.payload.ClientboundCullingUpdatePayload;

public final class ClientCullingUpdateTracker {
    public static void handleCullingUpdates(ClientboundCullingUpdatePayload payload, IPayloadContext ctx) {
        CullingUpdateChunk chunk = new CullingUpdateChunk(new ChunkPos(payload.chunk()), payload.positions());
        ctx.enqueueWork(() -> ClientCullingUpdateTracker.handleCullingUpdates(chunk));
    }

    private static void handleCullingUpdates(CullingUpdateChunk chunk) {
        ClientTaskQueue.enqueueClientTask(1L, () -> {
            Level level = (Level)Objects.requireNonNull(Minecraft.getInstance().level);
            BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
            ChunkPos cp = chunk.chunk();
            if (level.hasChunk(cp.x, cp.z)) {
                chunk.positions().forEach(pos -> {
                    blockPos.set(pos);
                    BlockEntity patt0$temp = level.getBlockEntity((BlockPos)blockPos);
                    if (patt0$temp instanceof FramedBlockEntity) {
                        FramedBlockEntity be = (FramedBlockEntity)patt0$temp;
                        be.updateCulling(true, true);
                    }
                });
            }
        });
    }

    private ClientCullingUpdateTracker() {
    }
}

