/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.conpreds.stairs;

import net.minecraft.core.Direction;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.predicate.contex.NonDetailedConnectionPredicate;

public final class DividedStairsConnectionPredicate
extends NonDetailedConnectionPredicate {
    @Override
    public boolean canConnectFullEdge(BlockState state, Direction side, @Nullable Direction edge) {
        Direction dirTwo;
        Direction facing = (Direction)state.getValue((Property)StairBlock.FACING);
        StairsShape shape = (StairsShape)state.getValue((Property)StairBlock.SHAPE);
        boolean top = state.getValue((Property)BlockStateProperties.HALF) == Half.TOP;
        Direction direction = dirTwo = top ? Direction.UP : Direction.DOWN;
        if (side == facing) {
            if (edge == facing.getCounterClockWise() && shape != StairsShape.OUTER_RIGHT) {
                return true;
            }
            if (edge == facing.getClockWise() && shape != StairsShape.OUTER_LEFT) {
                return true;
            }
        } else {
            if (side == dirTwo) {
                return edge != null && edge.getAxis() == facing.getClockWise().getAxis();
            }
            if (side == dirTwo.getOpposite() || side == facing.getOpposite()) {
                if (shape == StairsShape.INNER_LEFT && edge == facing.getCounterClockWise()) {
                    return true;
                }
                if (shape == StairsShape.INNER_RIGHT && edge == facing.getClockWise()) {
                    return true;
                }
            } else if (side == facing.getCounterClockWise()) {
                if (shape == StairsShape.INNER_LEFT) {
                    return true;
                }
                if (shape != StairsShape.OUTER_RIGHT) {
                    return edge == facing || edge == dirTwo;
                }
            } else if (side == facing.getClockWise()) {
                if (shape == StairsShape.INNER_RIGHT) {
                    return true;
                }
                if (shape != StairsShape.OUTER_LEFT) {
                    return edge == facing || edge == dirTwo;
                }
            }
        }
        return false;
    }
}

