/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.blockentity.special;

import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.blockentity.FramedBlockEntity;
import xfacthd.framedblocks.api.camo.CamoContainer;
import xfacthd.framedblocks.api.camo.empty.EmptyCamoContainer;
import xfacthd.framedblocks.api.util.CamoList;
import xfacthd.framedblocks.common.FBContent;

public class FramedDoorBlockEntity
extends FramedBlockEntity {
    public FramedDoorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)FBContent.BE_TYPE_FRAMED_DOOR.value(), pos, state);
    }

    @Override
    protected void collectCamoComponents(DataComponentMap.Builder builder) {
        boolean top = this.getBlockState().getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF) == DoubleBlockHalf.UPPER;
        CamoContainer otherCamo = EmptyCamoContainer.EMPTY;
        BlockPos otherPos = top ? this.worldPosition.below() : this.worldPosition.above();
        BlockEntity blockEntity = this.level().getBlockEntity(otherPos);
        if (blockEntity instanceof FramedDoorBlockEntity) {
            FramedDoorBlockEntity be = (FramedDoorBlockEntity)blockEntity;
            otherCamo = be.getCamo();
        }
        CamoContainer camoOne = top ? otherCamo : this.getCamo();
        CamoContainer camoTwo = top ? this.getCamo() : otherCamo;
        builder.set(FBContent.DC_TYPE_CAMO_LIST, (Object)CamoList.of(camoOne, camoTwo));
    }

    @Override
    protected void applyCamoComponents(BlockEntity.DataComponentInput input) {
        CamoList camoList = (CamoList)input.getOrDefault(FBContent.DC_TYPE_CAMO_LIST, (Object)CamoList.EMPTY);
        boolean top = this.getBlockState().getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF) == DoubleBlockHalf.UPPER;
        this.setCamo(camoList.getCamo(top ? 1 : 0), false);
    }
}

