/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.blockentity.doubled.stairs;

import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.util.Triangle;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.blockentity.doubled.FramedDoubleBlockEntity;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;

public class FramedVerticalSlicedSlopedStairsPanelBlockEntity
extends FramedDoubleBlockEntity {
    static final Triangle[] TRIANGLES = (Triangle[])Util.make((Object)new Triangle[16], arr -> {
        arr[FramedVerticalSlicedSlopedStairsPanelBlockEntity.triIndex((Direction)Direction.NORTH, (HorizontalRotation)HorizontalRotation.UP)] = new Triangle(new Vec3(0.0, 1.0, 0.5), new Vec3(1.0, 1.0, 0.5), new Vec3(0.0, 0.0, 0.5));
        arr[FramedVerticalSlicedSlopedStairsPanelBlockEntity.triIndex((Direction)Direction.NORTH, (HorizontalRotation)HorizontalRotation.DOWN)] = new Triangle(new Vec3(1.0, 0.0, 0.5), new Vec3(0.0, 0.0, 0.5), new Vec3(1.0, 1.0, 0.5));
        arr[FramedVerticalSlicedSlopedStairsPanelBlockEntity.triIndex((Direction)Direction.NORTH, (HorizontalRotation)HorizontalRotation.RIGHT)] = new Triangle(new Vec3(1.0, 1.0, 0.5), new Vec3(0.0, 1.0, 0.5), new Vec3(1.0, 0.0, 0.5));
        arr[FramedVerticalSlicedSlopedStairsPanelBlockEntity.triIndex((Direction)Direction.NORTH, (HorizontalRotation)HorizontalRotation.LEFT)] = new Triangle(new Vec3(0.0, 0.0, 0.5), new Vec3(1.0, 0.0, 0.5), new Vec3(0.0, 1.0, 0.5));
        arr[FramedVerticalSlicedSlopedStairsPanelBlockEntity.triIndex((Direction)Direction.SOUTH, (HorizontalRotation)HorizontalRotation.UP)] = arr[FramedVerticalSlicedSlopedStairsPanelBlockEntity.triIndex(Direction.NORTH, HorizontalRotation.RIGHT)];
        arr[FramedVerticalSlicedSlopedStairsPanelBlockEntity.triIndex((Direction)Direction.SOUTH, (HorizontalRotation)HorizontalRotation.DOWN)] = arr[FramedVerticalSlicedSlopedStairsPanelBlockEntity.triIndex(Direction.NORTH, HorizontalRotation.LEFT)];
        arr[FramedVerticalSlicedSlopedStairsPanelBlockEntity.triIndex((Direction)Direction.SOUTH, (HorizontalRotation)HorizontalRotation.RIGHT)] = arr[FramedVerticalSlicedSlopedStairsPanelBlockEntity.triIndex(Direction.NORTH, HorizontalRotation.UP)];
        arr[FramedVerticalSlicedSlopedStairsPanelBlockEntity.triIndex((Direction)Direction.SOUTH, (HorizontalRotation)HorizontalRotation.LEFT)] = arr[FramedVerticalSlicedSlopedStairsPanelBlockEntity.triIndex(Direction.NORTH, HorizontalRotation.DOWN)];
        arr[FramedVerticalSlicedSlopedStairsPanelBlockEntity.triIndex((Direction)Direction.WEST, (HorizontalRotation)HorizontalRotation.UP)] = new Triangle(new Vec3(0.5, 1.0, 1.0), new Vec3(0.5, 1.0, 0.0), new Vec3(0.5, 0.0, 1.0));
        arr[FramedVerticalSlicedSlopedStairsPanelBlockEntity.triIndex((Direction)Direction.WEST, (HorizontalRotation)HorizontalRotation.DOWN)] = new Triangle(new Vec3(0.5, 0.0, 0.0), new Vec3(0.5, 0.0, 1.0), new Vec3(0.5, 1.0, 0.0));
        arr[FramedVerticalSlicedSlopedStairsPanelBlockEntity.triIndex((Direction)Direction.WEST, (HorizontalRotation)HorizontalRotation.RIGHT)] = new Triangle(new Vec3(0.5, 1.0, 0.0), new Vec3(0.5, 1.0, 1.0), new Vec3(0.5, 0.0, 0.0));
        arr[FramedVerticalSlicedSlopedStairsPanelBlockEntity.triIndex((Direction)Direction.WEST, (HorizontalRotation)HorizontalRotation.LEFT)] = new Triangle(new Vec3(0.5, 0.0, 1.0), new Vec3(0.5, 0.0, 0.0), new Vec3(0.5, 1.0, 1.0));
        arr[FramedVerticalSlicedSlopedStairsPanelBlockEntity.triIndex((Direction)Direction.EAST, (HorizontalRotation)HorizontalRotation.UP)] = arr[FramedVerticalSlicedSlopedStairsPanelBlockEntity.triIndex(Direction.WEST, HorizontalRotation.RIGHT)];
        arr[FramedVerticalSlicedSlopedStairsPanelBlockEntity.triIndex((Direction)Direction.EAST, (HorizontalRotation)HorizontalRotation.DOWN)] = arr[FramedVerticalSlicedSlopedStairsPanelBlockEntity.triIndex(Direction.WEST, HorizontalRotation.LEFT)];
        arr[FramedVerticalSlicedSlopedStairsPanelBlockEntity.triIndex((Direction)Direction.EAST, (HorizontalRotation)HorizontalRotation.RIGHT)] = arr[FramedVerticalSlicedSlopedStairsPanelBlockEntity.triIndex(Direction.WEST, HorizontalRotation.UP)];
        arr[FramedVerticalSlicedSlopedStairsPanelBlockEntity.triIndex((Direction)Direction.EAST, (HorizontalRotation)HorizontalRotation.LEFT)] = arr[FramedVerticalSlicedSlopedStairsPanelBlockEntity.triIndex(Direction.WEST, HorizontalRotation.DOWN)];
    });

    public FramedVerticalSlicedSlopedStairsPanelBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)FBContent.BE_TYPE_FRAMED_VERTICAL_SLICED_SLOPED_DOUBLE_STAIRS_PANEL.value(), pos, state);
    }

    @Override
    protected boolean hitSecondary(BlockHitResult hit, Vec3 lookVec, Vec3 eyePos) {
        Vec3 origin;
        Triangle tri;
        Direction facing = (Direction)this.getBlockState().getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation rot = (HorizontalRotation)((Object)this.getBlockState().getValue(PropertyHolder.ROTATION));
        Direction dirTwo = rot.getOpposite().withFacing(facing);
        Direction dirThree = rot.rotate(Rotation.CLOCKWISE_90).withFacing(facing);
        Direction side = hit.getDirection();
        Vec3 hitVec = hit.getLocation();
        if (side == facing) {
            return false;
        }
        if (side == dirTwo || side == dirThree) {
            return Utils.fractionInDir(hitVec, facing) < 0.5;
        }
        if (side == dirTwo.getOpposite() || side == dirThree.getOpposite()) {
            if (Utils.fractionInDir(hitVec, facing) > 0.5) {
                return false;
            }
        } else if (side == facing.getOpposite()) {
            double par = Utils.fractionInDir(hitVec, dirTwo.getOpposite());
            double perp = Utils.fractionInDir(hitVec, dirThree);
            if (perp > par) {
                return true;
            }
        }
        return !(tri = FramedVerticalSlicedSlopedStairsPanelBlockEntity.getTriangle(facing, rot)).intersects(origin = eyePos.subtract((double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ()), lookVec.normalize());
    }

    static Triangle getTriangle(Direction facing, HorizontalRotation rot) {
        return TRIANGLES[FramedVerticalSlicedSlopedStairsPanelBlockEntity.triIndex(facing, rot)];
    }

    private static int triIndex(Direction facing, HorizontalRotation rot) {
        return facing.get2DDataValue() << 2 | rot.ordinal();
    }
}

