/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.prism;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.block.prism.FramedPrismBlock;
import xfacthd.framedblocks.common.block.prism.IFramedPrismBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.DirectionAxis;

public class FramedElevatedPrismBlock
extends FramedBlock
implements IFramedPrismBlock {
    public FramedElevatedPrismBlock(BlockType type) {
        super(type);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{PropertyHolder.FACING_AXIS, BlockStateProperties.WATERLOGGED, FramedProperties.SOLID, FramedProperties.Y_SLOPE});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return FramedPrismBlock.getStateForPlacement(context, this);
    }

    @Override
    public boolean handleBlockLeftClick(BlockState state, Level level, BlockPos pos, Player player) {
        return IFramedBlock.toggleYSlope(state, level, pos, player);
    }

    protected BlockState rotate(BlockState state, Rotation rot) {
        DirectionAxis dirAxis = (DirectionAxis)((Object)state.getValue(PropertyHolder.FACING_AXIS));
        return (BlockState)state.setValue(PropertyHolder.FACING_AXIS, (Comparable)((Object)dirAxis.rotate(rot)));
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        DirectionAxis dirAxis = (DirectionAxis)((Object)state.getValue(PropertyHolder.FACING_AXIS));
        return (BlockState)state.setValue(PropertyHolder.FACING_AXIS, (Comparable)((Object)dirAxis.mirror(mirror)));
    }

    @Override
    public BlockState getItemModelSource() {
        return (BlockState)this.defaultBlockState().setValue(PropertyHolder.FACING_AXIS, (Comparable)((Object)DirectionAxis.UP_X));
    }

    @Override
    public BlockState getJadeRenderState(BlockState state) {
        return this.getItemModelSource();
    }

    @Override
    public boolean isInnerPrism() {
        return this.getBlockType() == BlockType.FRAMED_ELEVATED_INNER_PRISM;
    }
}

