/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.stairs;

import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.model.data.QuadMap;
import xfacthd.framedblocks.api.model.geometry.Geometry;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.model.wrapping.GeometryFactory;
import xfacthd.framedblocks.api.util.Utils;

public class FramedLadderGeometry
extends Geometry {
    private static final float RUNG_DEPTH = 0.0625f;
    private static final float LEG_DEPTH = 0.125f;
    private static final float RUNG_OFFSET = 0.03125f;
    private static final float[] RUNGS = new float[]{0.09375f, 0.34375f, 0.59375f, 0.84375f};
    private final Direction dir;

    public FramedLadderGeometry(GeometryFactory.Context ctx) {
        this.dir = (Direction)ctx.state().getValue((Property)FramedProperties.FACING_HOR);
    }

    @Override
    public void transformQuad(QuadMap quadMap, BakedQuad quad) {
        Direction quadDir = quad.getDirection();
        if (Utils.isY(quadDir)) {
            QuadModifier capMod = QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.dir.getOpposite(), 0.125f));
            capMod.derive().apply(Modifiers.cutTopBottom(this.dir.getClockWise(), 0.125f)).export(quadMap.get(quadDir));
            capMod.apply(Modifiers.cutTopBottom(this.dir.getCounterClockWise(), 0.125f)).export(quadMap.get(quadDir));
            QuadModifier rungMod = QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.dir, 0.96875f)).apply(Modifiers.cutTopBottom(this.dir.getOpposite(), 0.09375f)).apply(Modifiers.cutTopBottom(this.dir.getClockWise(), 0.875f)).apply(Modifiers.cutTopBottom(this.dir.getCounterClockWise(), 0.875f));
            for (int i = 0; i < 4; ++i) {
                float height = quad.getDirection() == Direction.DOWN ? 1.0f - RUNGS[i] : RUNGS[i] + 0.0625f;
                rungMod.derive().apply(Modifiers.setPosition(height)).export(quadMap.get(null));
            }
        } else if (quadDir.getAxis() == this.dir.getAxis()) {
            boolean opposite = quadDir == this.dir.getOpposite();
            QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(this.dir.getClockWise(), 0.125f)).applyIf(Modifiers.setPosition(0.125f), opposite).export(quadMap.get(opposite ? null : quadDir));
            QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(this.dir.getCounterClockWise(), 0.125f)).applyIf(Modifiers.setPosition(0.125f), opposite).export(quadMap.get(opposite ? null : quadDir));
            float pos = quad.getDirection() == this.dir ? 0.96875f : 0.09375f;
            for (int i = 0; i < 4; ++i) {
                QuadModifier.of(quad).apply(Modifiers.cutSide(0.125f, RUNGS[i], 0.875f, RUNGS[i] + 0.0625f)).apply(Modifiers.setPosition(pos)).export(quadMap.get(null));
            }
        } else {
            QuadModifier mod = QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(this.dir.getOpposite(), 0.125f));
            mod.export(quadMap.get(quadDir));
            mod.derive().apply(Modifiers.setPosition(0.125f)).export(quadMap.get(null));
        }
    }

    @Override
    public boolean useSolidNoCamoModel() {
        return true;
    }
}

