/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.slope;

import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.model.data.QuadMap;
import xfacthd.framedblocks.api.model.geometry.Geometry;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.model.wrapping.GeometryFactory;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.CornerType;

public class FramedCornerSlopeGeometry
extends Geometry {
    private final Direction dir;
    private final CornerType type;
    private final boolean ySlope;

    public FramedCornerSlopeGeometry(GeometryFactory.Context ctx) {
        this.dir = (Direction)ctx.state().getValue((Property)FramedProperties.FACING_HOR);
        this.type = (CornerType)((Object)ctx.state().getValue(PropertyHolder.CORNER_TYPE));
        this.ySlope = (Boolean)ctx.state().getValue((Property)FramedProperties.Y_SLOPE);
    }

    @Override
    public void transformQuad(QuadMap quadMap, BakedQuad quad) {
        if (this.type.isHorizontal()) {
            this.createHorizontalCornerSlope(quadMap, quad);
        } else {
            this.createVerticalCornerSlope(quadMap, quad);
        }
    }

    private void createHorizontalCornerSlope(QuadMap quadMap, BakedQuad quad) {
        Direction quadDir = quad.getDirection();
        boolean top = this.type.isTop();
        boolean right = this.type.isRight();
        if (quadDir == this.dir.getClockWise() && right || quadDir == this.dir.getCounterClockWise() && !right) {
            QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(this.dir.getOpposite(), top ? 1.0f : 0.0f, top ? 0.0f : 1.0f)).export(quadMap.get(quadDir));
        } else if (quadDir == Direction.UP && top || quadDir == Direction.DOWN && !top) {
            QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.dir.getOpposite(), right ? 0.0f : 1.0f, right ? 1.0f : 0.0f)).export(quadMap.get(quadDir));
        } else if (quadDir == this.dir.getCounterClockWise() && right || quadDir == this.dir.getClockWise() && !right) {
            QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(this.dir.getOpposite(), top ? 1.0f : 0.0f, top ? 0.0f : 1.0f)).apply(Modifiers.makeHorizontalSlope(!right, 45.0f)).export(quadMap.get(null));
        } else if (!this.ySlope && quadDir == this.dir.getOpposite()) {
            QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(!top, right ? 0.0f : 1.0f, right ? 1.0f : 0.0f)).apply(Modifiers.makeVerticalSlope(!top, 45.0f)).export(quadMap.get(null));
        } else if (this.ySlope && (!top && quadDir == Direction.UP || top && quadDir == Direction.DOWN)) {
            QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.dir.getOpposite(), right ? 0.0f : 1.0f, right ? 1.0f : 0.0f)).apply(Modifiers.makeVerticalSlope(this.dir.getOpposite(), 45.0f)).export(quadMap.get(null));
        }
    }

    private void createVerticalCornerSlope(QuadMap quadMap, BakedQuad quad) {
        boolean slope;
        Direction quadDir = quad.getDirection();
        boolean yQuad = Utils.isY(quadDir);
        if (!this.ySlope && yQuad) {
            return;
        }
        boolean top = this.type.isTop();
        Direction cutDir = quadDir.getAxis() == this.dir.getAxis() ? this.dir.getClockWise() : this.dir.getOpposite();
        boolean bl = slope = quadDir == this.dir.getOpposite() || quadDir == this.dir.getClockWise();
        if (!slope && !yQuad || !this.ySlope) {
            QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(cutDir, top ? 1.0f : 0.0f, top ? 0.0f : 1.0f)).applyIf(Modifiers.makeVerticalSlope(!top, 45.0f), slope).export(quadMap.get(slope ? null : quadDir));
        } else if (yQuad) {
            QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.dir.getOpposite(), 0.0f, 1.0f)).apply(Modifiers.makeVerticalSlope(this.dir.getClockWise(), 45.0f)).export(quadMap.get(null));
            QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.dir.getClockWise(), 1.0f, 0.0f)).apply(Modifiers.makeVerticalSlope(this.dir.getOpposite(), 45.0f)).export(quadMap.get(null));
        }
    }
}

