/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.slab;

import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.model.data.QuadMap;
import xfacthd.framedblocks.api.model.geometry.Geometry;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.model.wrapping.GeometryFactory;
import xfacthd.framedblocks.api.util.Utils;

public class FramedSlabCornerGeometry
extends Geometry {
    private final Direction dir;
    private final boolean top;

    public FramedSlabCornerGeometry(GeometryFactory.Context ctx) {
        this.dir = (Direction)ctx.state().getValue((Property)FramedProperties.FACING_HOR);
        this.top = (Boolean)ctx.state().getValue((Property)FramedProperties.TOP);
    }

    @Override
    public void transformQuad(QuadMap quadMap, BakedQuad quad) {
        Direction quadDir = quad.getDirection();
        if (Utils.isY(quadDir)) {
            boolean inset = !this.top && quadDir == Direction.UP || this.top && quadDir == Direction.DOWN;
            QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.dir.getOpposite(), 0.5f)).apply(Modifiers.cutTopBottom(this.dir.getClockWise(), 0.5f)).applyIf(Modifiers.setPosition(0.5f), inset).export(quadMap.get(inset ? null : quadDir));
        } else {
            Direction cutDir = quadDir.getAxis() == this.dir.getAxis() ? this.dir.getClockWise() : this.dir.getOpposite();
            boolean inset = quadDir == this.dir.getOpposite() || quadDir == this.dir.getClockWise();
            QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(cutDir, 0.5f)).apply(Modifiers.cutSideUpDown(this.top, 0.5f)).applyIf(Modifiers.setPosition(0.5f), inset).export(quadMap.get(inset ? null : quadDir));
        }
    }
}

