/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.cube;

import java.util.List;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.model.data.ModelData;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.model.data.QuadMap;
import xfacthd.framedblocks.api.model.geometry.Geometry;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.model.util.ModelUtils;
import xfacthd.framedblocks.api.model.wrapping.GeometryFactory;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.client.model.cube.FramedChestGeometry;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.LatchType;

public class FramedChestLidGeometry
extends Geometry {
    private final BlockState state;
    private final BakedModel baseModel;
    private final Direction facing;
    private final ChestType type;
    private final LatchType latch;
    private final ChunkRenderTypeSet addLayers;

    public FramedChestLidGeometry(GeometryFactory.Context ctx) {
        this.state = ctx.state();
        this.baseModel = ctx.baseModel();
        this.facing = (Direction)ctx.state().getValue((Property)FramedProperties.FACING_HOR);
        this.type = (ChestType)ctx.state().getValue((Property)BlockStateProperties.CHEST_TYPE);
        this.latch = (LatchType)((Object)ctx.state().getValue(PropertyHolder.LATCH_TYPE));
        this.addLayers = this.latch == LatchType.DEFAULT ? ModelUtils.CUTOUT : ChunkRenderTypeSet.none();
    }

    @Override
    public void transformQuad(QuadMap quadMap, BakedQuad quad) {
        Direction quadDir = quad.getDirection();
        if (Utils.isY(quadDir)) {
            QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.facing.getAxis(), 0.9375f)).applyIf(Modifiers.cutTopBottom(this.facing.getClockWise(), 0.9375f), this.type != ChestType.LEFT).applyIf(Modifiers.cutTopBottom(this.facing.getCounterClockWise(), 0.9375f), this.type != ChestType.RIGHT).apply(Modifiers.setPosition(quadDir == Direction.UP ? 0.875f : 0.4375f)).export(quadMap.get(quadDir == Direction.UP ? null : quadDir));
        } else if (quadDir.getAxis() == this.facing.getAxis()) {
            QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(false, 0.875f)).apply(Modifiers.cutSideUpDown(true, 0.4375f)).applyIf(Modifiers.cutSideLeftRight(this.facing.getClockWise(), 0.9375f), this.type != ChestType.LEFT).applyIf(Modifiers.cutSideLeftRight(this.facing.getCounterClockWise(), 0.9375f), this.type != ChestType.RIGHT).apply(Modifiers.setPosition(0.9375f)).export(quadMap.get(null));
        } else {
            boolean offset = !(this.type == ChestType.RIGHT && quadDir == this.facing.getCounterClockWise() || this.type == ChestType.LEFT && quadDir == this.facing.getClockWise());
            QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(false, 0.875f)).apply(Modifiers.cutSideUpDown(true, 0.4375f)).apply(Modifiers.cutSideLeftRight(0.9375f)).applyIf(Modifiers.setPosition(0.9375f), offset).export(quadMap.get(offset ? null : quadDir));
        }
        if (this.latch == LatchType.CAMO) {
            FramedChestGeometry.makeChestLatch(quadMap, quad, this.facing, this.type);
        }
    }

    @Override
    public ChunkRenderTypeSet getAdditionalRenderTypes(RandomSource rand, ModelData extraData) {
        return this.addLayers;
    }

    @Override
    public void getAdditionalQuads(QuadMap quadMap, RandomSource rand, ModelData data, RenderType layer) {
        List quads = this.baseModel.getQuads(this.state, null, rand, data, layer);
        for (BakedQuad quad : quads) {
            quadMap.get(null).add(quad);
        }
    }
}

