/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.lib.logistics.energy;

import com.google.common.primitives.Ints;
import net.neoforged.neoforge.energy.IEnergyStorage;
import owmii.powah.lib.logistics.energy.Energy;

final class ItemEnergyStorageAdapter
implements IEnergyStorage {
    private final Energy.Item energyItem;

    public ItemEnergyStorageAdapter(Energy.Item energyItem) {
        this.energyItem = energyItem;
    }

    public int receiveEnergy(int i, boolean bl) {
        if (this.energyItem.getCapacity() == 0L || !this.canReceive()) {
            return 0;
        }
        return Ints.saturatedCast((long)this.energyItem.receiveEnergy(i, bl));
    }

    public int extractEnergy(int i, boolean bl) {
        if (!this.energyItem.canExtract()) {
            return 0;
        }
        return Ints.saturatedCast((long)this.energyItem.extractEnergy(i, bl));
    }

    public int getEnergyStored() {
        return Ints.saturatedCast((long)this.energyItem.getEnergyStored());
    }

    public int getMaxEnergyStored() {
        return Ints.saturatedCast((long)this.energyItem.getMaxEnergyStored());
    }

    public boolean canExtract() {
        return this.energyItem.canExtract();
    }

    public boolean canReceive() {
        return this.energyItem.canReceive();
    }
}

