/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.client.render.tile;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import owmii.powah.Powah;
import owmii.powah.api.wrench.IWrench;
import owmii.powah.block.Tier;
import owmii.powah.block.energizing.EnergizingOrbTile;
import owmii.powah.block.energizing.EnergizingRodTile;
import owmii.powah.lib.client.renderer.tile.AbstractTileRenderer;
import owmii.powah.lib.client.util.RenderTypes;
import owmii.powah.util.math.V3d;

public class EnergizingRodRenderer
extends AbstractTileRenderer<EnergizingRodTile> {
    public static final ResourceLocation BEAM_TEXTURE = Powah.id("textures/model/tile/beam.png");
    private static final RenderType RENDER_TYPE = RenderTypes.entityBlendedNoDept(BEAM_TEXTURE);

    protected EnergizingRodRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    @Override
    public void render(EnergizingRodTile te, float pt, PoseStack matrix, MultiBufferSource rtb, Minecraft mc, ClientLevel world, LocalPlayer player, int light, int ov) {
        EnergizingOrbTile orb;
        boolean flag = false;
        for (InteractionHand hand : InteractionHand.values()) {
            IWrench wrench;
            ItemStack stack = player.getItemInHand(hand);
            Item item = stack.getItem();
            if (!(item instanceof IWrench) || !(wrench = (IWrench)item).getWrenchMode(stack).link()) continue;
            flag = true;
            break;
        }
        if ((orb = te.getOrbTile()) != null && (te.coolDown.ended() || flag)) {
            matrix.pushPose();
            matrix.translate(0.5, 0.5, 0.5);
            V3d pos = V3d.from(te.getBlockPos()).center();
            V3d orbPos = V3d.from(orb.getOrbCenter());
            float f2 = 1.0f;
            float f3 = f2 * 0.5f % 1.0f;
            Vec3 vec3d2 = pos.subtract(orbPos);
            double d0 = vec3d2.length();
            vec3d2 = vec3d2.normalize();
            float f5 = (float)Math.acos(Mth.clamp((double)vec3d2.y, (double)-1.0, (double)1.0));
            float f6 = (float)Mth.atan2((double)vec3d2.z, (double)vec3d2.x);
            matrix.mulPose(Axis.YP.rotationDegrees((1.5707964f - f6) * 57.295776f));
            matrix.mulPose(Axis.XP.rotationDegrees(f5 * 57.295776f));
            float d1 = f2 * 0.0f;
            float d12 = Mth.cos((float)((float)((double)d1 + Math.PI))) * 0.12f;
            float d13 = Mth.sin((float)((float)((double)d1 + Math.PI))) * 0.12f;
            float d14 = Mth.cos((float)d1) * 0.12f;
            float d15 = Mth.sin((float)d1) * 0.12f;
            float d16 = Mth.cos((float)((float)((double)d1 + 1.5707963267948966))) * 0.12f;
            float d17 = Mth.sin((float)((float)((double)d1 + 1.5707963267948966))) * 0.12f;
            float d18 = Mth.cos((float)((float)((double)d1 + 4.71238898038469))) * 0.12f;
            float d19 = Mth.sin((float)((float)((double)d1 + 4.71238898038469))) * 0.12f;
            float d22 = f3 - 1.0f;
            float d23 = (float)(d0 * 5.05 + (double)d22);
            VertexConsumer builder = rtb.getBuffer(RENDER_TYPE);
            PoseStack.Pose last = matrix.last();
            int color = ((Tier)te.getVariant()).getColor();
            int r = 0xFF & color >> 16;
            int g = 0xFF & color >> 8;
            int b = 0xFF & color;
            this.pos(builder, last, d12, 0.0f, d13, r, g, b, 1.0f, d23);
            this.pos(builder, last, d12, (float)(-d0), d13, r, g, b, 1.0f, d22);
            this.pos(builder, last, d14, (float)(-d0), d15, r, g, b, 0.0f, d22);
            this.pos(builder, last, d14, 0.0f, d15, r, g, b, 0.0f, d23);
            this.pos(builder, last, d16, 0.0f, d17, r, g, b, 1.0f, d23);
            this.pos(builder, last, d16, (float)(-d0), d17, r, g, b, 1.0f, d22);
            this.pos(builder, last, d18, (float)(-d0), d19, r, g, b, 0.0f, d22);
            this.pos(builder, last, d18, 0.0f, d19, r, g, b, 0.0f, d23);
            matrix.popPose();
        }
    }

    private void pos(VertexConsumer builder, PoseStack.Pose pose, float x, float y, float z, int r, int g, int b, float u, float v) {
        builder.addVertex(pose, x, y, z).setColor(r, g, b, 255).setUv(u, v).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0x780078).setNormal(pose, 0.0f, 1.0f, 0.0f);
    }

    public AABB getRenderBoundingBox(EnergizingRodTile blockEntity) {
        int range = Powah.config().general.energizing_range;
        return new AABB(blockEntity.getBlockPos()).inflate((double)range);
    }
}

