/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.transmitter;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import owmii.powah.block.Tier;
import owmii.powah.block.Tiles;
import owmii.powah.block.transmitter.PlayerTransmitterBlock;
import owmii.powah.components.PowahComponents;
import owmii.powah.config.v2.types.ChargingConfig;
import owmii.powah.item.BindingCardItem;
import owmii.powah.lib.block.AbstractEnergyStorage;
import owmii.powah.lib.block.IInventoryHolder;
import owmii.powah.util.ChargeUtil;

public class PlayerTransmitterTile
extends AbstractEnergyStorage<ChargingConfig, PlayerTransmitterBlock>
implements IInventoryHolder {
    public PlayerTransmitterTile(BlockPos pos, BlockState state, Tier variant) {
        super(Tiles.PLAYER_TRANSMITTER.get(), pos, state, variant);
        this.inv.add(1);
    }

    public PlayerTransmitterTile(BlockPos pos, BlockState state) {
        this(pos, state, Tier.STARTER);
    }

    @Override
    protected int postTick(Level world) {
        long extracted = 0L;
        if (world instanceof ServerLevel) {
            BindingCardItem card;
            Optional<ServerPlayer> op;
            ItemStack stack;
            Item item;
            ServerLevel serverLevel = (ServerLevel)world;
            if (this.checkRedstone() && (item = (stack = this.inv.getFirst()).getItem()) instanceof BindingCardItem && (op = (card = (BindingCardItem)item).getPlayer(serverLevel, stack)).isPresent()) {
                ServerPlayer player = op.get();
                if (card.isMultiDim(stack) || player.level().dimensionType().equals((Object)world.dimensionType())) {
                    long charging = ((ChargingConfig)this.getConfig()).getChargingSpeed((Tier)this.variant);
                    extracted = ChargeUtil.chargeItemsInPlayerInv((Player)player, charging, this.getEnergy().getStored());
                    this.energy.consume(extracted);
                }
            }
        }
        return extracted > 0L ? 5 : -1;
    }

    @Override
    public int getSlotLimit(int slot) {
        return 1;
    }

    @Override
    public boolean canInsert(int slot, ItemStack stack) {
        return stack.has(PowahComponents.BOUND_PLAYER);
    }

    @Override
    public boolean canExtract(int slot, ItemStack stack) {
        return true;
    }

    @Override
    public boolean keepEnergy() {
        return true;
    }
}

