/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.megacells.misc;

import appeng.api.networking.GridServices;
import appeng.api.stacks.AEItemKey;
import gripe._90.megacells.definition.MEGADataMaps;
import gripe._90.megacells.misc.CompressionChain;
import gripe._90.megacells.misc.DecompressionService;
import gripe._90.megacells.misc.SyncCompressionChainsPacket;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompressionService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompressionService.class);
    private static final CompressionChain EMPTY = new CompressionChain(List.of());
    private static final List<CompressionChain> chains = new ArrayList<CompressionChain>();
    private static final Map<AEItemKey, Integer> chainIndexes = new HashMap<AEItemKey, Integer>();

    public static void init() {
        GridServices.register(DecompressionService.class, DecompressionService.class);
        NeoForge.EVENT_BUS.addListener(ServerStartedEvent.class, event -> {
            MinecraftServer server = event.getServer();
            CompressionService.loadRecipes(server.getRecipeManager(), (RegistryAccess)server.registryAccess());
        });
        NeoForge.EVENT_BUS.addListener(OnDatapackSyncEvent.class, event -> {
            if (event.getPlayer() == null) {
                MinecraftServer server = event.getPlayerList().getServer();
                CompressionService.loadRecipes(server.getRecipeManager(), (RegistryAccess)server.registryAccess());
                PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SyncCompressionChainsPacket(chains), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else {
                PacketDistributor.sendToPlayer((ServerPlayer)event.getPlayer(), (CustomPacketPayload)new SyncCompressionChainsPacket(chains), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        });
    }

    @NotNull
    public static CompressionChain getChain(@Nullable AEItemKey item) {
        if (item == null) {
            return EMPTY;
        }
        Integer cachedIndex = chainIndexes.get(item);
        if (cachedIndex != null) {
            return cachedIndex >= 0 ? chains.get(cachedIndex) : EMPTY;
        }
        for (int i = 0; i < chains.size(); ++i) {
            CompressionChain chain = chains.get(i);
            if (!chain.containsVariant(item)) continue;
            for (int j = 0; j < chain.size(); ++j) {
                chainIndexes.put(AEItemKey.of((ItemStack)chain.getItem(j)), i);
            }
            return chain;
        }
        chainIndexes.put(item, -1);
        return EMPTY;
    }

    public static void syncToClient(SyncCompressionChainsPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            chains.clear();
            chainIndexes.clear();
            chains.addAll(packet.chains());
        });
    }

    private static void loadRecipes(RecipeManager recipeManager, RegistryAccess access) {
        chains.clear();
        chainIndexes.clear();
        ArrayList<CraftingRecipe> compressed = new ArrayList<CraftingRecipe>();
        ArrayList<CraftingRecipe> decompressed = new ArrayList<CraftingRecipe>();
        ArrayList<Override> overrides = new ArrayList<Override>();
        for (RecipeHolder recipe2 : recipeManager.getAllRecipesFor(RecipeType.CRAFTING)) {
            if (CompressionService.isCompressionRecipe((CraftingRecipe)recipe2.value(), access)) {
                compressed.add((CraftingRecipe)recipe2.value());
                continue;
            }
            if (!CompressionService.isDecompressionRecipe((CraftingRecipe)recipe2.value())) continue;
            decompressed.add((CraftingRecipe)recipe2.value());
        }
        compressed.removeIf(recipe -> CompressionService.isIrreversible(recipe, decompressed, overrides, access));
        decompressed.removeIf(recipe -> CompressionService.isIrreversible(recipe, compressed, overrides, access));
        Comparator<CraftingRecipe> ingredientSize = Comparator.comparingInt(r -> ((Ingredient)r.getIngredients().getFirst()).getItems().length);
        compressed.sort(ingredientSize);
        decompressed.sort(ingredientSize);
        while (!compressed.isEmpty()) {
            ItemStack base = ((CraftingRecipe)compressed.removeFirst()).getResultItem((HolderLookup.Provider)access).copy();
            decompressed.removeIf(recipe -> ItemStack.isSameItemSameComponents((ItemStack)base, (ItemStack)recipe.getResultItem((HolderLookup.Provider)access)));
            chains.add(CompressionService.generateChain(base, compressed, decompressed, overrides, access));
        }
        LOGGER.info("Initialised bulk compression. {} compression chains gathered.", (Object)chains.size());
    }

    private static CompressionChain generateChain(ItemStack baseVariant, List<CraftingRecipe> compressed, List<CraftingRecipe> decompressed, List<Override> overrides, RegistryAccess access) {
        ArrayList<ItemStack> lowerList = new ArrayList<ItemStack>();
        lowerList.add(baseVariant);
        ArrayList<Integer> stackHashes = new ArrayList<Integer>();
        stackHashes.add(ItemStack.hashItemAndComponents((ItemStack)baseVariant));
        ItemStack lower = CompressionService.getNextVariant(baseVariant, decompressed, overrides, false, access);
        while (lower != null) {
            ItemStack stack = lower;
            if (stackHashes.contains(ItemStack.hashItemAndComponents((ItemStack)stack))) {
                if (stack.getCount() == 1) break;
                LOGGER.warn("Duplicate lower compression variant detected: {}. Check any recipe involving this item for problems.", (Object)stack);
                break;
            }
            lowerList.add(stack);
            compressed.removeIf(recipe -> ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)recipe.getResultItem((HolderLookup.Provider)access)));
            lower = CompressionService.getNextVariant(stack, decompressed, overrides, false, access);
        }
        ArrayList<ItemStack> variantList = new ArrayList<ItemStack>();
        for (int i = lowerList.size(); i > 0; --i) {
            variantList.add(((ItemStack)lowerList.get(i - 1)).copyWithCount(((ItemStack)lowerList.get(i % lowerList.size())).getCount()));
        }
        ItemStack higher = CompressionService.getNextVariant(baseVariant, compressed, overrides, true, access);
        while (higher != null) {
            if (stackHashes.contains(ItemStack.hashItemAndComponents((ItemStack)higher))) {
                if (higher.getCount() == 1) break;
                LOGGER.warn("Duplicate higher compression variant detected: {}. Check any recipe involving this item for problems.", (Object)higher);
                break;
            }
            ItemStack stack = higher;
            variantList.add(stack);
            decompressed.removeIf(recipe -> ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)recipe.getResultItem((HolderLookup.Provider)access)));
            higher = CompressionService.getNextVariant(stack, compressed, overrides, true, access);
        }
        CompressionChain chain = new CompressionChain(variantList);
        LOGGER.debug("Gathered bulk compression chain: {}", (Object)chain);
        return chain;
    }

    private static ItemStack getNextVariant(ItemStack item, List<CraftingRecipe> recipes, List<Override> overrides, boolean compressed, RegistryAccess access) {
        for (Override override : overrides) {
            if (compressed && ItemStack.isSameItemSameComponents((ItemStack)override.smaller, (ItemStack)item)) {
                overrides.remove(override);
                return override.larger;
            }
            if (compressed || !ItemStack.isSameItemSameComponents((ItemStack)override.larger, (ItemStack)item)) continue;
            overrides.remove(override);
            return override.smaller;
        }
        for (CraftingRecipe recipe : recipes) {
            for (ItemStack input : ((Ingredient)recipe.getIngredients().getFirst()).getItems()) {
                if (!ItemStack.isSameItemSameComponents((ItemStack)item, (ItemStack)input)) continue;
                recipes.remove(recipe);
                return recipe.getResultItem((HolderLookup.Provider)access).copyWithCount(compressed ? recipe.getIngredients().size() : recipe.getResultItem((HolderLookup.Provider)access).getCount());
            }
        }
        return null;
    }

    private static boolean isDecompressionRecipe(CraftingRecipe recipe) {
        return recipe.getIngredients().stream().filter(i -> !i.isEmpty()).count() == 1L;
    }

    private static boolean isCompressionRecipe(CraftingRecipe recipe, RegistryAccess access) {
        if (recipe.getResultItem((HolderLookup.Provider)access).getCount() != 1) {
            return false;
        }
        List<Ingredient> ingredients = recipe.getIngredients().stream().filter(i -> !i.isEmpty()).distinct().toList();
        if (ingredients.isEmpty()) {
            return false;
        }
        if (ingredients.size() == 1) {
            return true;
        }
        ItemStack[] first = ingredients.getFirst().getItems();
        for (int i2 = 1; i2 < ingredients.size(); ++i2) {
            ItemStack[] stacks = ingredients.get(i2).getItems();
            if (stacks.length != first.length) {
                return false;
            }
            for (int j = 0; j < stacks.length; ++j) {
                if (ItemStack.isSameItemSameComponents((ItemStack)stacks[j], (ItemStack)first[j])) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isIrreversible(CraftingRecipe recipe, List<CraftingRecipe> candidates, List<Override> overrides, RegistryAccess access) {
        if (CompressionService.overrideRecipe(recipe, overrides, access)) {
            return false;
        }
        ItemStack[] testInput = ((Ingredient)recipe.getIngredients().getFirst()).getItems();
        Item testOutput = recipe.getResultItem((HolderLookup.Provider)access).getItem();
        for (CraftingRecipe candidate : candidates) {
            boolean sameQuantity;
            ItemStack[] input = ((Ingredient)candidate.getIngredients().getFirst()).getItems();
            Item output = candidate.getResultItem((HolderLookup.Provider)access).getItem();
            boolean compressible = false;
            boolean decompressible = false;
            for (ItemStack i : input) {
                if (!i.is(testOutput) || CompressionService.isBlacklisted(i)) continue;
                compressible = true;
                break;
            }
            for (ItemStack i : testInput) {
                if (!i.is(output) || CompressionService.isBlacklisted(i)) continue;
                decompressible = true;
                break;
            }
            boolean bl = sameQuantity = candidate.getResultItem((HolderLookup.Provider)access).getCount() == recipe.getIngredients().size() && recipe.getResultItem((HolderLookup.Provider)access).getCount() == candidate.getIngredients().size();
            if (!compressible || !decompressible || !sameQuantity) continue;
            return false;
        }
        return true;
    }

    private static boolean overrideRecipe(CraftingRecipe recipe, List<Override> overrides, RegistryAccess access) {
        ItemStack output = recipe.getResultItem((HolderLookup.Provider)access);
        if (CompressionService.isBlacklisted(output)) {
            return false;
        }
        for (ItemStack input : ((Ingredient)recipe.getIngredients().getFirst()).getItems()) {
            Item inputVariant = (Item)input.getItemHolder().getData(MEGADataMaps.COMPRESSION_OVERRIDE);
            if (inputVariant == null || inputVariant != output.getItem()) continue;
            boolean decompressed = CompressionService.isDecompressionRecipe(recipe);
            ItemStack larger = (decompressed ? input : output).copy();
            ItemStack smaller = decompressed ? output.copy() : input.copyWithCount(recipe.getIngredients().size());
            Override override = new Override(larger, smaller);
            LOGGER.debug("Found bulk compression override: {}", (Object)override);
            overrides.add(override);
            return true;
        }
        return false;
    }

    private static boolean isBlacklisted(ItemStack stack) {
        return stack.getItemHolder().getData(MEGADataMaps.COMPRESSION_OVERRIDE) == Items.AIR;
    }

    static String variantString(ItemStack stack) {
        Object s = BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).toString();
        if (!stack.isComponentsPatchEmpty()) {
            s = (String)s + "(*)";
        }
        return s;
    }

    private record Override(ItemStack larger, ItemStack smaller) {
        @java.lang.Override
        @NotNull
        public String toString() {
            return CompressionService.variantString(this.larger) + " \u2192 " + this.smaller.getCount() + "x " + CompressionService.variantString(this.smaller);
        }
    }
}

