/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.recipe.result;

import it.zerono.mods.zerocore.lib.data.stack.OperationMode;
import it.zerono.mods.zerocore.lib.item.inventory.IInventorySlot;
import it.zerono.mods.zerocore.lib.recipe.result.FluidStackRecipeResult;
import it.zerono.mods.zerocore.lib.recipe.result.IRecipeResultTarget;
import it.zerono.mods.zerocore.lib.recipe.result.ItemStackRecipeResult;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;

public class RecipeResultTargetWrapper {
    public static IRecipeResultTarget<ItemStackRecipeResult> wrap(final IInventorySlot slot) {
        return new IRecipeResultTarget<ItemStackRecipeResult>(){

            @Override
            public long setResult(ItemStackRecipeResult result, OperationMode mode) {
                ItemStack stack = result.getResult();
                return stack.isEmpty() ? 0L : (long)slot.insertStack(stack, mode).getCount();
            }

            @Override
            public long countStorableResults(ItemStackRecipeResult result) {
                return (long)slot.getSlotFreeSpace(result.getResult()) / result.getAmount();
            }
        };
    }

    public static IRecipeResultTarget<ItemStackRecipeResult> wrap(final IItemHandler inventory, final int slot) {
        return new IRecipeResultTarget<ItemStackRecipeResult>(){

            @Override
            public long setResult(ItemStackRecipeResult result, OperationMode mode) {
                return inventory.insertItem(slot, result.getResult(), mode.simulate()).getCount();
            }

            @Override
            public long countStorableResults(ItemStackRecipeResult result) {
                ItemStack stack = result.getResult();
                if (stack.isEmpty()) {
                    return 0L;
                }
                int max = stack.getMaxStackSize();
                stack.setCount(max);
                return (long)(max - inventory.insertItem(slot, stack, true).getCount()) / result.getAmount();
            }
        };
    }

    public static IRecipeResultTarget<FluidStackRecipeResult> wrap(final IFluidHandler inventory) {
        return new IRecipeResultTarget<FluidStackRecipeResult>(){

            @Override
            public long setResult(FluidStackRecipeResult result, OperationMode mode) {
                return inventory.fill(result.getResult(), mode.toFluidAction());
            }

            @Override
            public long countStorableResults(FluidStackRecipeResult result) {
                FluidStack stack = result.getResult();
                if (stack.isEmpty()) {
                    return 0L;
                }
                stack.setAmount(Integer.MAX_VALUE);
                return (long)inventory.fill(stack, IFluidHandler.FluidAction.SIMULATE) / result.getAmount();
            }
        };
    }

    private RecipeResultTargetWrapper() {
    }
}

