/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.recipe.ingredient;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import it.zerono.mods.zerocore.lib.data.ModCodecs;
import it.zerono.mods.zerocore.lib.fluid.FluidHelper;
import it.zerono.mods.zerocore.lib.recipe.ingredient.IRecipeIngredient;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;

public class FluidStackRecipeIngredient
implements IRecipeIngredient<FluidStack> {
    public static final ModCodecs<FluidStackRecipeIngredient, RegistryFriendlyByteBuf> CODECS = new ModCodecs(FluidStack.CODEC.xmap(FluidStackRecipeIngredient::from, i -> i._ingredient), StreamCodec.composite((StreamCodec)FluidStack.STREAM_CODEC, i -> i._ingredient, FluidStackRecipeIngredient::new));
    private final FluidStack _ingredient;
    private List<FluidStack> _cachedMatchingElements;

    public static FluidStackRecipeIngredient from(Fluid fluid, int amount) {
        return FluidStackRecipeIngredient.from(new FluidStack(fluid, amount));
    }

    public static FluidStackRecipeIngredient from(FluidStack stack) {
        return new FluidStackRecipeIngredient(stack);
    }

    @Override
    public boolean isCompatible(FluidStack stack) {
        Preconditions.checkNotNull((Object)stack, (Object)"Stack must not be null");
        return FluidStack.isSameFluidSameComponents((FluidStack)this._ingredient, (FluidStack)stack);
    }

    @Override
    public boolean isCompatible(FluidStack ... ingredients) {
        for (FluidStack stack : ingredients) {
            if (!FluidStack.isSameFluidSameComponents((FluidStack)this._ingredient, (FluidStack)stack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public FluidStack getMatchFrom(FluidStack stack) {
        return this.test(stack) ? this._ingredient : FluidStack.EMPTY;
    }

    @Override
    public long getAmount(FluidStack stack) {
        return this.isCompatible(stack) ? (long)this._ingredient.getAmount() : 0L;
    }

    @Override
    public List<FluidStack> getMatchingElements() {
        if (null == this._cachedMatchingElements) {
            this._cachedMatchingElements = ObjectLists.singleton((Object)this._ingredient);
        }
        return this._cachedMatchingElements;
    }

    @Override
    public boolean isEmpty() {
        return this._ingredient.isEmpty();
    }

    @Override
    public boolean test(FluidStack stack) {
        return this.isCompatible(stack) && stack.getAmount() >= this._ingredient.getAmount();
    }

    @Override
    public boolean testIgnoreAmount(FluidStack stack) {
        return this.isCompatible(stack);
    }

    public String toString() {
        return FluidHelper.toStringHelper(this._ingredient);
    }

    protected FluidStackRecipeIngredient(FluidStack ingredient) {
        this._ingredient = ingredient;
    }
}

