/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.network;

import com.google.common.collect.Sets;
import it.zerono.mods.zerocore.internal.Lib;
import it.zerono.mods.zerocore.internal.network.ModSyncableTileMessage;
import it.zerono.mods.zerocore.lib.data.nbt.INestedSyncableEntity;
import it.zerono.mods.zerocore.lib.data.nbt.ISyncableEntity;
import it.zerono.mods.zerocore.lib.network.INetworkTileEntitySyncProvider;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class NetworkTileEntitySyncProvider
implements INetworkTileEntitySyncProvider {
    private final Supplier<CustomPacketPayload> _messageSupplier;
    private final Set<ServerPlayer> _players;

    public static NetworkTileEntitySyncProvider create(Level level, BlockPos coordinates, ISyncableEntity entity) {
        return new NetworkTileEntitySyncProvider(() -> ModSyncableTileMessage.create(level, coordinates, entity));
    }

    public static NetworkTileEntitySyncProvider create(Level level, Supplier<@NotNull BlockPos> coordinatesSupplier, INestedSyncableEntity entity) {
        return new NetworkTileEntitySyncProvider(() -> ModSyncableTileMessage.create(level, (BlockPos)coordinatesSupplier.get(), entity));
    }

    @Override
    public void enlistForUpdates(ServerPlayer player, boolean updateNow) {
        this._players.add(player);
        if (updateNow) {
            this.getUpdateMessage().ifPresent(update -> this.sendUpdate((CustomPacketPayload)update, player));
        }
    }

    @Override
    public void delistFromUpdates(ServerPlayer player) {
        this._players.remove(player);
    }

    @Override
    public void sendUpdates() {
        if (!this._players.isEmpty()) {
            this.getUpdateMessage().ifPresent(update -> this._players.forEach(player -> this.sendUpdate((CustomPacketPayload)update, (ServerPlayer)player)));
        }
    }

    private NetworkTileEntitySyncProvider(Supplier<CustomPacketPayload> messageSupplier) {
        this._messageSupplier = messageSupplier;
        this._players = Sets.newHashSet();
    }

    private Optional<CustomPacketPayload> getUpdateMessage() {
        return Optional.ofNullable(this._messageSupplier.get());
    }

    private void sendUpdate(CustomPacketPayload update, ServerPlayer player) {
        Lib.NETWORK_HANDLER.sendToPlayer(player, update, new CustomPacketPayload[0]);
    }
}

