/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.item.inventory.filter;

import it.zerono.mods.zerocore.ZeroCore;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.item.inventory.filter.Filter;
import it.zerono.mods.zerocore.lib.item.inventory.filter.FilterManager;
import it.zerono.mods.zerocore.lib.item.inventory.filter.IFilterComponentFactory;
import it.zerono.mods.zerocore.lib.item.inventory.filter.ItemStackFilterCondition;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

public class FilterInventory
extends Filter
implements IItemHandlerModifiable {
    private final int _size;
    private static final ResourceLocation COMPONENT_ID = ZeroCore.ROOT_LOCATION.buildWithSuffix("inventory.filter.filterinventory");

    public FilterInventory(int size) {
        this._size = size;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return true;
    }

    @Override
    public ResourceLocation getComponentId() {
        return COMPONENT_ID;
    }

    public int getSlots() {
        return this._size;
    }

    public ItemStack getStackInSlot(int slot) {
        return this.getFilterStack(slot).map(ItemStackFilterCondition::getFilterStack).orElse(ItemStack.EMPTY);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        boolean reachedLimit;
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        this.validateSlotIndex(slot);
        Optional<ItemStackFilterCondition> itemStackFilter = this.getFilterStack(slot);
        if (!itemStackFilter.isPresent()) {
            if (!simulate) {
                this.addFilterStack(slot, stack);
            }
            return ItemStack.EMPTY;
        }
        ItemStack existing = itemStackFilter.get().getFilterStack();
        if (null == existing) {
            if (!simulate) {
                itemStackFilter.get().setFilterStack(stack);
            }
            return ItemStack.EMPTY;
        }
        int limit = stack.getMaxStackSize();
        if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)existing)) {
            return stack;
        }
        if ((limit -= existing.getCount()) <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.getCount() > limit;
        if (!simulate) {
            existing.grow(reachedLimit ? limit : stack.getCount());
        }
        return reachedLimit ? stack.copyWithCount(stack.getCount() - limit) : ItemStack.EMPTY;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.EMPTY;
        }
        this.validateSlotIndex(slot);
        Optional<ItemStackFilterCondition> itemStackFilter = this.getFilterStack(slot);
        if (!itemStackFilter.isPresent()) {
            return ItemStack.EMPTY;
        }
        ItemStack existing = itemStackFilter.get().getFilterStack();
        if (existing == null) {
            return ItemStack.EMPTY;
        }
        int toExtract = Math.min(amount, existing.getMaxStackSize());
        if (existing.getCount() <= toExtract) {
            if (!simulate) {
                this.removeFilterStack(slot);
            }
            return existing;
        }
        if (!simulate) {
            itemStackFilter.get().setFilterStack(existing, existing.getCount() - toExtract);
        }
        return existing.copyWithCount(toExtract);
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        this.validateSlotIndex(slot);
        CodeHelper.optionalIfPresentOrElse(this.getFilterStack(slot), filter -> {
            ItemStack existing = filter.getFilterStack();
            if (null == existing || !ItemStack.matches((ItemStack)existing, (ItemStack)stack)) {
                filter.setFilterStack(stack);
            }
        }, () -> this.addFilterStack(slot, stack));
    }

    public int getSlotLimit(int slot) {
        ItemStack stack = this.getStackInSlot(slot);
        return stack.isEmpty() ? 0 : stack.getMaxStackSize();
    }

    private boolean isSlotIndexValid(int slot) {
        return slot >= 0 && slot < this._size;
    }

    private void validateSlotIndex(int slot) {
        if (!this.isSlotIndexValid(slot)) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this._size + ")");
        }
    }

    private Optional<ItemStackFilterCondition> getFilterStack(int slot) {
        if (!this.isSlotIndexValid(slot)) {
            return Optional.empty();
        }
        return this.getCondition(String.valueOf(slot)).filter(c -> c instanceof ItemStackFilterCondition).map(c -> (ItemStackFilterCondition)c);
    }

    private void addFilterStack(int slot, ItemStack stack) {
        this.addCondition(String.valueOf(slot), new ItemStackFilterCondition(stack));
    }

    private void removeFilterStack(int slot) {
        this.removeCondition(String.valueOf(slot));
    }

    static {
        FilterManager<FilterInventory> fm = FilterManager.getInstance();
        fm.registerFactory(COMPONENT_ID, new IFilterComponentFactory<FilterInventory>(){

            @Override
            public Optional<FilterInventory> createComponent(@NotNull ResourceLocation componentId) {
                return Optional.of(new FilterInventory(1));
            }

            @Override
            public Optional<FilterInventory> createComponent(@NotNull ResourceLocation componentId, HolderLookup.Provider registries, CompoundTag nbt) {
                return Optional.empty();
            }
        });
    }
}

