/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.item.inventory.container.data;

import com.google.common.base.Preconditions;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModContainer;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.AbstractData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.IContainerData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.Sampler;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.sync.ISyncedSetEntry;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.network.RegistryFriendlyByteBuf;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnumData<T extends Enum<T>>
extends AbstractData<T>
implements IContainerData {
    private final Class<T> _enumClass;
    private T _lastValue;

    public static <T extends Enum<T>> EnumData<T> immutable(ModContainer container, Class<T> enumClass, T value) {
        return EnumData.of(container, enumClass, () -> value, CodeHelper.emptyConsumer());
    }

    public static <T extends Enum<T>> EnumData<T> sampled(int frequency, ModContainer container, Class<T> enumClass, Supplier<@NotNull T> getter, Consumer<@NotNull T> clientSideSetter) {
        return EnumData.of(container, enumClass, new Sampler<T>(frequency, getter), clientSideSetter);
    }

    public static <T extends Enum<T>> EnumData<T> sampled(int frequency, ModContainer container, Class<T> enumClass, Supplier<@NotNull T> getter) {
        return EnumData.of(container, enumClass, new Sampler<T>(frequency, getter), CodeHelper.emptyConsumer());
    }

    public static <T extends Enum<T>> EnumData<T> of(ModContainer container, Class<T> enumClass, Supplier<@NotNull T> getter, Consumer<@NotNull T> clientSideSetter) {
        Preconditions.checkNotNull((Object)((Object)container), (Object)"Container must not be null.");
        EnumData<T> data = container.isClientSide() ? new EnumData<T>(enumClass, getter, clientSideSetter) : new EnumData<T>(enumClass, getter);
        container.addBindableData(data);
        return data;
    }

    public static <T extends Enum<T>> EnumData<T> of(ModContainer container, Class<T> enumClass, Supplier<@NotNull T> getter) {
        return EnumData.of(container, enumClass, getter, CodeHelper.emptyConsumer());
    }

    @Override
    @Nullable
    public ISyncedSetEntry getChangedValue() {
        Enum current = (Enum)this.getValue();
        if (this._lastValue != current) {
            this._lastValue = current;
            return buffer -> buffer.writeEnum(current);
        }
        return null;
    }

    @Override
    public ISyncedSetEntry getValueFrom(RegistryFriendlyByteBuf buffer) {
        return new EnumEntry<Enum>(buffer.readEnum(this._enumClass));
    }

    @Override
    public void updateFrom(ISyncedSetEntry entry) {
        if (entry instanceof EnumEntry) {
            EnumEntry enumEntry = (EnumEntry)entry;
            this.setClientSideValue(enumEntry.value);
            this.notify(enumEntry.value);
        }
    }

    @Override
    @Nullable
    public T defaultValue() {
        return (T)((Enum[])this._enumClass.getEnumConstants())[0];
    }

    private EnumData(Class<T> enumClass, Supplier<T> getter, Consumer<T> clientSideSetter) {
        super(getter, clientSideSetter);
        this._enumClass = enumClass;
    }

    private EnumData(Class<T> enumClass, Supplier<T> getter) {
        super(getter);
        this._enumClass = enumClass;
        this._lastValue = null;
    }

    private record EnumEntry<T extends Enum<T>>(T value) implements ISyncedSetEntry
    {
        @Override
        public void accept(@NotNull RegistryFriendlyByteBuf buffer) {
            buffer.writeEnum(this.value);
        }
    }
}

