/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.item.inventory.container.data;

import com.google.common.base.Preconditions;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModContainer;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.AbstractData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.IContainerData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.Sampler;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.sync.ISyncedSetEntry;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.network.RegistryFriendlyByteBuf;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BooleanData
extends AbstractData<Boolean>
implements IContainerData {
    private boolean _lastValue;

    public static BooleanData immutable(ModContainer container, boolean value) {
        return BooleanData.of(container, () -> value, CodeHelper.emptyConsumer());
    }

    public static BooleanData sampled(int frequency, ModContainer container, Supplier<@NotNull Boolean> getter, Consumer<@NotNull Boolean> clientSideSetter) {
        return BooleanData.of(container, new Sampler<Boolean>(frequency, getter), clientSideSetter);
    }

    public static BooleanData sampled(int frequency, ModContainer container, Supplier<@NotNull Boolean> getter) {
        return BooleanData.of(container, new Sampler<Boolean>(frequency, getter), CodeHelper.emptyConsumer());
    }

    public static BooleanData of(ModContainer container, Supplier<@NotNull Boolean> getter, Consumer<@NotNull Boolean> clientSideSetter) {
        Preconditions.checkNotNull((Object)((Object)container), (Object)"Container must not be null.");
        BooleanData data = container.isClientSide() ? new BooleanData(getter, clientSideSetter) : new BooleanData(getter);
        container.addBindableData(data);
        return data;
    }

    public static BooleanData of(ModContainer container, boolean[] array, int index) {
        Preconditions.checkNotNull((Object)array, (Object)"Array must not be null.");
        Preconditions.checkArgument((index >= 0 && index < array.length ? 1 : 0) != 0, (Object)"Index must be a valid index for the array.");
        return BooleanData.of(container, () -> array[index], v -> {
            array[index] = v;
        });
    }

    public static BooleanData of(ModContainer container, Supplier<@NotNull Boolean> getter) {
        return BooleanData.of(container, getter, CodeHelper.emptyConsumer());
    }

    @Override
    @Nullable
    public ISyncedSetEntry getChangedValue() {
        boolean current = (Boolean)this.getValue();
        if (this._lastValue != current) {
            this._lastValue = current;
            return new BooleanEntry(current);
        }
        return null;
    }

    @Override
    public ISyncedSetEntry getValueFrom(RegistryFriendlyByteBuf buffer) {
        return BooleanEntry.from(buffer);
    }

    @Override
    public void updateFrom(ISyncedSetEntry entry) {
        if (entry instanceof BooleanEntry) {
            BooleanEntry record = (BooleanEntry)entry;
            this.setClientSideValue(record.value);
            this.notify(record.value);
        }
    }

    @Override
    @Nullable
    public Boolean defaultValue() {
        return Boolean.FALSE;
    }

    private BooleanData(Supplier<Boolean> getter, Consumer<Boolean> clientSideSetter) {
        super(getter, clientSideSetter);
    }

    private BooleanData(Supplier<Boolean> getter) {
        super(getter);
        this._lastValue = false;
    }

    private record BooleanEntry(boolean value) implements ISyncedSetEntry
    {
        private static BooleanEntry from(RegistryFriendlyByteBuf buffer) {
            return new BooleanEntry(buffer.readBoolean());
        }

        @Override
        public void accept(@NotNull RegistryFriendlyByteBuf buffer) {
            buffer.writeBoolean(this.value);
        }
    }
}

