/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.item.inventory;

import it.zerono.mods.zerocore.lib.data.stack.OperationMode;
import net.minecraft.world.item.ItemStack;

public interface IInventorySlot {
    public int getIndex();

    public ItemStack getStackInSlot();

    public void setStackInSlot(ItemStack var1);

    default public void setToEmpty() {
        this.setStackInSlot(ItemStack.EMPTY);
    }

    default public boolean isSlotEmpty() {
        return this.getStackInSlot().isEmpty();
    }

    default public int getStackSize() {
        return this.getStackInSlot().getCount();
    }

    default public int setStackSize(int amount, OperationMode mode) {
        if (this.isSlotEmpty()) {
            return 0;
        }
        if (amount <= 0) {
            if (mode.execute()) {
                this.setToEmpty();
            }
            return 0;
        }
        ItemStack stack = this.getStackInSlot();
        int maxStackSize = this.getSlotLimit(stack);
        if (amount > maxStackSize) {
            amount = maxStackSize;
        }
        if (stack.getCount() == amount || mode.simulate()) {
            return amount;
        }
        ItemStack newStack = stack.copy();
        newStack.setCount(amount);
        this.setStackInSlot(newStack);
        return amount;
    }

    default public int increaseStackSize(int amount, OperationMode mode) {
        if (amount > 0) {
            amount = Math.min(amount, this.getSlotLimit(this.getStackInSlot()));
        }
        int currentSize = this.getStackSize();
        return this.setStackSize(currentSize + amount, mode) - currentSize;
    }

    default public int decreaseStackSize(int amount, OperationMode mode) {
        return -this.increaseStackSize(-amount, mode);
    }

    default public ItemStack insertStack(ItemStack stack, OperationMode mode) {
        if (stack.isEmpty() || this.canInsertStack(stack)) {
            return stack;
        }
        int needed = this.getSlotLimit(stack) - this.getStackSize();
        if (needed <= 0) {
            return stack;
        }
        boolean typeMatch = false;
        if (this.isSlotEmpty() || (typeMatch = ItemStack.isSameItemSameComponents((ItemStack)this.getStackInSlot(), (ItemStack)stack))) {
            int toAdd = Math.min(stack.getCount(), needed);
            if (mode.execute()) {
                if (typeMatch) {
                    this.increaseStackSize(toAdd, mode);
                } else {
                    ItemStack toSet = stack.copy();
                    toSet.setCount(toAdd);
                    this.setStackInSlot(toSet);
                }
            }
            ItemStack remainder = stack.copy();
            remainder.setCount(stack.getCount() - toAdd);
            return remainder;
        }
        return stack;
    }

    default public ItemStack extractStack(int amount, OperationMode mode) {
        if (this.isSlotEmpty() || amount < 1) {
            return ItemStack.EMPTY;
        }
        ItemStack current = this.getStackInSlot();
        int currentAmount = Math.min(this.getStackSize(), current.getMaxStackSize());
        if (currentAmount < amount) {
            amount = currentAmount;
        }
        ItemStack result = current.copy();
        result.setCount(amount);
        if (mode.execute()) {
            this.decreaseStackSize(amount, mode);
        }
        return result;
    }

    public boolean canInsertStack(ItemStack var1);

    public boolean canExtractStack(int var1);

    public int getSlotLimit(ItemStack var1);

    default public int getSlotFreeSpace(ItemStack stack) {
        return this.isSlotEmpty() ? this.getSlotLimit(stack) : this.getSlotLimit(stack) - this.getStackInSlot().getCount();
    }
}

