/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.item;

import com.mojang.serialization.DynamicOps;
import java.util.EnumSet;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Containers;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.wrapper.EmptyItemHandler;
import org.jetbrains.annotations.NotNull;

public final class ItemHelper {
    public static final String INVENTORY = "inventory";
    public static final IItemHandlerModifiable EMPTY_ITEM_HANDLER = (IItemHandlerModifiable)EmptyItemHandler.INSTANCE;

    public static ResourceLocation getItemId(ItemLike item) {
        return Objects.requireNonNull(BuiltInRegistries.ITEM.getKey((Object)item.asItem()));
    }

    public static ResourceLocation getItemId(ItemStack stack) {
        return Objects.requireNonNull(BuiltInRegistries.ITEM.getKey((Object)stack.getItem()));
    }

    public static MutableComponent getItemName(Item item) {
        return Component.translatable((String)item.getDescriptionId());
    }

    public static MutableComponent getItemName(ItemStack stack) {
        return Component.translatable((String)stack.getDescriptionId());
    }

    public static Item getItemFrom(String id) {
        return ItemHelper.getItemFrom(ResourceLocation.parse((String)id));
    }

    public static Item getItemFromOrAir(String id) {
        return ItemHelper.getItemFromOrAir(ResourceLocation.parse((String)id));
    }

    public static Item getItemFrom(ResourceLocation id) {
        return (Item)BuiltInRegistries.ITEM.get(id);
    }

    public static Item getItemFromOrAir(ResourceLocation id) {
        return BuiltInRegistries.ITEM.containsKey(id) ? Objects.requireNonNull((Item)BuiltInRegistries.ITEM.get(id)) : Items.AIR;
    }

    public static boolean stackMatch(ItemStack stackA, ItemStack stackB, EnumSet<MatchOption> options) {
        if (stackA.isEmpty() || stackB.isEmpty()) {
            return false;
        }
        if (options.isEmpty()) {
            return true;
        }
        boolean result = true;
        if (options.contains((Object)MatchOption.Item)) {
            boolean bl = result = stackA.getItem() == stackB.getItem();
        }
        if (result && options.contains((Object)MatchOption.Size)) {
            boolean bl = result = stackA.getCount() == stackB.getCount();
        }
        if (result && options.contains((Object)MatchOption.Damage)) {
            boolean bl = result = stackA.getDamageValue() == stackB.getDamageValue();
        }
        if (result && options.contains((Object)MatchOption.NBT)) {
            result = Objects.equals(stackA.getComponents(), stackB.getComponents());
        }
        return result;
    }

    public static <T extends ItemLike> ItemStack stackFrom(Supplier<T> supplier) {
        return ((ItemLike)supplier.get()).asItem().getDefaultInstance();
    }

    public static ItemStack stackFrom(ItemLike provider, int amount) {
        ItemStack stack = provider.asItem().getDefaultInstance();
        if (!stack.isEmpty()) {
            stack.setCount(amount);
        }
        return stack;
    }

    public static <T extends ItemLike> ItemStack stackFrom(Supplier<@NotNull T> supplier, int amount) {
        return ItemHelper.stackFrom((ItemLike)supplier.get(), amount);
    }

    public static ItemStack stackFrom(ItemLike provider, int amount, int damage) {
        ItemStack stack = ItemHelper.stackFrom(provider, amount);
        if (!stack.isEmpty()) {
            stack.setDamageValue(damage);
        }
        return stack;
    }

    public static <T extends ItemLike> ItemStack stackFrom(Supplier<@NotNull T> supplier, int amount, int damage) {
        return ItemHelper.stackFrom((ItemLike)supplier.get(), amount, damage);
    }

    public static ItemStack stackFrom(BlockState state, int amount) {
        return ItemHelper.stackFrom((ItemLike)state.getBlock(), amount);
    }

    public static Tag stackSerializeToNBT(HolderLookup.Provider registries, ItemStack stack) {
        return stack.isEmpty() ? new CompoundTag() : stack.save(registries);
    }

    public static Tag stackSerializeToNBT(HolderLookup.Provider registries, ItemStack stack, Tag output) {
        return stack.isEmpty() ? new CompoundTag() : stack.save(registries, output);
    }

    public static ItemStack stackDeserializeFromNBT(HolderLookup.Provider registries, Tag input) {
        CompoundTag compound;
        if (input instanceof CompoundTag && (compound = (CompoundTag)input).isEmpty()) {
            return ItemStack.EMPTY;
        }
        return ItemStack.OPTIONAL_CODEC.parse((DynamicOps)registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)input).result().orElse(ItemStack.EMPTY);
    }

    public static ItemStack removeStackFromSlot(IItemHandlerModifiable inventory, int slot) {
        ItemStack stack = inventory.getStackInSlot(slot);
        inventory.setStackInSlot(slot, ItemStack.EMPTY);
        return stack;
    }

    public static void inventoryDropItems(IItemHandlerModifiable inventory, Level world, BlockPos position) {
        double x = position.getX();
        double y = position.getY();
        double z = position.getZ();
        IntStream.range(0, inventory.getSlots()).mapToObj(slot -> ItemHelper.removeStackFromSlot(inventory, slot)).filter(stack -> !stack.isEmpty()).forEach(stack -> Containers.dropItemStack((Level)world, (double)x, (double)y, (double)z, (ItemStack)stack));
    }

    private ItemHelper() {
    }

    public static enum MatchOption {
        Item,
        Size,
        Damage,
        NBT;

        public static final EnumSet<MatchOption> MATCH_ALWAYS;
        public static final EnumSet<MatchOption> MATCH_ALL;
        public static final EnumSet<MatchOption> MATCH_ITEM;
        public static final EnumSet<MatchOption> MATCH_ITEM_SIZE;
        public static final EnumSet<MatchOption> MATCH_ITEM_NBT;
        public static final EnumSet<MatchOption> MATCH_ITEM_DAMAGE;
        public static final EnumSet<MatchOption> MATCH_EXISTING_STACK;

        static {
            MATCH_ALWAYS = EnumSet.noneOf(MatchOption.class);
            MATCH_ALL = EnumSet.of(Item, Size, Damage, NBT);
            MATCH_ITEM = EnumSet.of(Item);
            MATCH_ITEM_SIZE = EnumSet.of(Item, Size);
            MATCH_ITEM_NBT = EnumSet.of(Item, NBT);
            MATCH_ITEM_DAMAGE = EnumSet.of(Item, Damage);
            MATCH_EXISTING_STACK = EnumSet.of(Item, Damage, NBT);
        }
    }
}

