/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.datagen.provider.recipe;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import it.zerono.mods.zerocore.lib.data.ResourceLocationBuilder;
import it.zerono.mods.zerocore.lib.datagen.IModDataProvider;
import it.zerono.mods.zerocore.lib.datagen.provider.ProviderSettings;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.data.recipes.SmithingTransformRecipeBuilder;
import net.minecraft.data.recipes.SmithingTrimRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.conditions.AndCondition;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;
import net.neoforged.neoforge.common.conditions.NotCondition;
import net.neoforged.neoforge.common.conditions.OrCondition;
import net.neoforged.neoforge.common.conditions.TagEmptyCondition;
import org.jetbrains.annotations.Nullable;

public abstract class ModRecipeProvider
extends RecipeProvider
implements IModDataProvider {
    private final ProviderSettings _settings;

    protected ModRecipeProvider(String name, PackOutput output, CompletableFuture<HolderLookup.Provider> registryLookup, ResourceLocationBuilder modLocationRoot) {
        super(output, registryLookup);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"Name must not be null or empty");
        Preconditions.checkNotNull((Object)output, (Object)"Output must not be null");
        Preconditions.checkNotNull(registryLookup, (Object)"Registry lookup must not be null");
        Preconditions.checkNotNull((Object)modLocationRoot, (Object)"Mod location root must not be null");
        this._settings = new ProviderSettings(name, output, registryLookup, modLocationRoot);
    }

    protected ResourceLocationBuilder craftingRoot() {
        return this.root().appendPath("crafting");
    }

    protected ResourceLocationBuilder blastingRoot() {
        return this.root().appendPath("blasting");
    }

    protected ResourceLocationBuilder smeltingRoot() {
        return this.root().appendPath("smelting");
    }

    protected ResourceLocationBuilder cookingRoot() {
        return this.root().appendPath("cooking");
    }

    protected ResourceLocationBuilder smokingRoot() {
        return this.root().appendPath("smoking");
    }

    protected ResourceLocationBuilder stonecuttingRoot() {
        return this.root().appendPath("stonecutting");
    }

    protected ResourceLocationBuilder smithingRoot() {
        return this.root().appendPath("smithing");
    }

    protected ResourceLocationBuilder miscRoot() {
        return this.root().appendPath("misc");
    }

    protected ShapedRecipeBuilder shaped(RecipeCategory category, Supplier<? extends ItemLike> result, int amount) {
        ModRecipeProvider.validateResultAndCategory(category, result);
        Preconditions.checkArgument((amount > 0 ? 1 : 0) != 0, (Object)"Amount must be greater than zero");
        return ShapedRecipeBuilder.shaped((RecipeCategory)category, (ItemLike)result.get(), (int)amount);
    }

    protected ShapedRecipeBuilder shaped(RecipeCategory category, Supplier<? extends ItemLike> result) {
        return this.shaped(category, result, 1);
    }

    protected ShapelessRecipeBuilder shapeless(RecipeCategory category, Supplier<? extends ItemLike> result, int amount) {
        ModRecipeProvider.validateResultAndCategory(category, result);
        Preconditions.checkArgument((amount > 0 ? 1 : 0) != 0, (Object)"Amount must be greater than zero");
        return ShapelessRecipeBuilder.shapeless((RecipeCategory)category, (ItemLike)result.get(), (int)amount);
    }

    protected ShapelessRecipeBuilder shapeless(RecipeCategory category, Supplier<? extends ItemLike> result) {
        return this.shapeless(category, result, 1);
    }

    protected SimpleCookingRecipeBuilder campfireCooking(RecipeCategory category, Supplier<? extends ItemLike> result, Ingredient ingredient, float experience, int cookingTime) {
        ModRecipeProvider.validateResultAndCategory(category, result);
        ModRecipeProvider.validateCookingParameters(ingredient, experience, cookingTime);
        return SimpleCookingRecipeBuilder.campfireCooking((Ingredient)ingredient, (RecipeCategory)category, (ItemLike)result.get(), (float)experience, (int)cookingTime);
    }

    protected SimpleCookingRecipeBuilder blasting(RecipeCategory category, Supplier<? extends ItemLike> result, Ingredient ingredient, float experience, int cookingTime) {
        ModRecipeProvider.validateResultAndCategory(category, result);
        ModRecipeProvider.validateCookingParameters(ingredient, experience, cookingTime);
        return SimpleCookingRecipeBuilder.blasting((Ingredient)ingredient, (RecipeCategory)category, (ItemLike)result.get(), (float)experience, (int)cookingTime);
    }

    protected SimpleCookingRecipeBuilder smelting(RecipeCategory category, Supplier<? extends ItemLike> result, Ingredient ingredient, float experience, int cookingTime) {
        ModRecipeProvider.validateResultAndCategory(category, result);
        ModRecipeProvider.validateCookingParameters(ingredient, experience, cookingTime);
        return SimpleCookingRecipeBuilder.smelting((Ingredient)ingredient, (RecipeCategory)category, (ItemLike)result.get(), (float)experience, (int)cookingTime);
    }

    protected SimpleCookingRecipeBuilder smoking(RecipeCategory category, Supplier<? extends ItemLike> result, Ingredient ingredient, float experience, int cookingTime) {
        ModRecipeProvider.validateResultAndCategory(category, result);
        ModRecipeProvider.validateCookingParameters(ingredient, experience, cookingTime);
        return SimpleCookingRecipeBuilder.smoking((Ingredient)ingredient, (RecipeCategory)category, (ItemLike)result.get(), (float)experience, (int)cookingTime);
    }

    protected SingleItemRecipeBuilder stonecutting(RecipeCategory category, Supplier<? extends ItemLike> result, Ingredient ingredient, int amount) {
        ModRecipeProvider.validateResultAndCategory(category, result);
        Preconditions.checkArgument((amount > 0 ? 1 : 0) != 0, (Object)"Amount must be greater than zero");
        return SingleItemRecipeBuilder.stonecutting((Ingredient)ingredient, (RecipeCategory)category, (ItemLike)result.get(), (int)amount);
    }

    protected SingleItemRecipeBuilder stonecutting(RecipeCategory category, Supplier<? extends ItemLike> result, Ingredient ingredient) {
        return this.stonecutting(category, result, ingredient, 1);
    }

    protected SmithingTransformRecipeBuilder smithing(RecipeCategory category, Supplier<? extends ItemLike> result, Ingredient template, Ingredient base, Ingredient addition) {
        ModRecipeProvider.validateResultAndCategory(category, result);
        Preconditions.checkNotNull((Object)template, (Object)"Template must not be null");
        Preconditions.checkNotNull((Object)base, (Object)"Base must not be null");
        Preconditions.checkNotNull((Object)addition, (Object)"Addition must not be null");
        return SmithingTransformRecipeBuilder.smithing((Ingredient)template, (Ingredient)base, (Ingredient)addition, (RecipeCategory)category, (Item)result.get().asItem());
    }

    protected SmithingTrimRecipeBuilder smithingTrim(RecipeCategory category, Ingredient template, Ingredient base, Ingredient addition) {
        Preconditions.checkNotNull((Object)category, (Object)"Category must not be null");
        Preconditions.checkNotNull((Object)template, (Object)"Template must not be null");
        Preconditions.checkNotNull((Object)base, (Object)"Base must not be null");
        Preconditions.checkNotNull((Object)addition, (Object)"Addition must not be null");
        return SmithingTrimRecipeBuilder.smithingTrim((Ingredient)template, (Ingredient)base, (Ingredient)addition, (RecipeCategory)category);
    }

    protected static ICondition not(ICondition condition) {
        Preconditions.checkNotNull((Object)condition, (Object)"Condition must not be null");
        return new NotCondition(condition);
    }

    protected static ICondition and(ICondition ... conditions) {
        return new AndCondition((List)Lists.newArrayList((Object[])conditions));
    }

    protected static ICondition or(ICondition ... conditions) {
        return new OrCondition((List)Lists.newArrayList((Object[])conditions));
    }

    protected static ICondition modLoaded(String modId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)modId) ? 1 : 0) != 0, (Object)"Mod ID must not be null or empty");
        return new ModLoadedCondition(modId);
    }

    protected static ICondition allModsLoaded(String ... modIds) {
        return ModRecipeProvider.and((ICondition[])Stream.of(modIds).map(ModRecipeProvider::modLoaded).toArray(ICondition[]::new));
    }

    protected static ICondition anyModsLoaded(String ... modIds) {
        return ModRecipeProvider.or((ICondition[])Stream.of(modIds).map(ModRecipeProvider::modLoaded).toArray(ICondition[]::new));
    }

    protected void withFallback(RecipeOutput output, ResourceLocation name, TagKey<Item> tag, @Nullable ResourceLocation fallbackName, @Nullable TagKey<Item> fallbackTag, Function<TagKey<Item>, RecipeBuilder> recipe) {
        if (null == fallbackTag || null == fallbackName) {
            recipe.apply(tag).save(output, name);
        } else {
            TagEmptyCondition tagCondition = new TagEmptyCondition(tag.location());
            recipe.apply(tag).save(output.withConditions(new ICondition[]{ModRecipeProvider.not((ICondition)tagCondition)}), name);
            recipe.apply(fallbackTag).save(output.withConditions(new ICondition[]{tagCondition}), fallbackName);
        }
    }

    protected void storageBlock3x3(RecipeOutput output, String name, String group, ResourceLocation toStorageId, RecipeCategory toStorageCategory, Supplier<? extends ItemLike> storage, ResourceLocation toComponentId, RecipeCategory toComponentCategory, Supplier<? extends ItemLike> component) {
        this.shapeless(toStorageCategory, storage).requires(component.get(), 9).group(group).unlockedBy("has_item", ModRecipeProvider.has((ItemLike)component.get())).save(output, toStorageId);
        this.shapeless(toComponentCategory, component, 9).requires(storage.get()).group(group).unlockedBy("has_item", ModRecipeProvider.has((ItemLike)storage.get())).save(output, toComponentId);
    }

    protected void storageBlock3x3(RecipeOutput output, String name, String group, RecipeCategory toStorageCategory, Supplier<? extends ItemLike> storage, RecipeCategory toComponentCategory, Supplier<? extends ItemLike> component) {
        ResourceLocationBuilder crafting = this.craftingRoot().append(name);
        this.storageBlock3x3(output, name, group, crafting.buildWithSuffix("_component_to_storage"), toStorageCategory, storage, crafting.buildWithSuffix("_storage_to_component"), toComponentCategory, component);
    }

    protected void storageBlock2x2(RecipeOutput output, String name, String group, ResourceLocation toStorageId, RecipeCategory toStorageCategory, Supplier<? extends ItemLike> storage, ResourceLocation toComponentId, RecipeCategory toComponentCategory, Supplier<? extends ItemLike> component) {
        this.shaped(toStorageCategory, storage).define(Character.valueOf('X'), component.get()).pattern("XX").pattern("XX").group(group).unlockedBy("has_item", ModRecipeProvider.has((ItemLike)component.get())).save(output, toStorageId);
        this.shapeless(toComponentCategory, component, 4).requires(storage.get()).group(group).unlockedBy("has_item", ModRecipeProvider.has((ItemLike)storage.get())).save(output, toComponentId);
    }

    protected void storageBlock2x2(RecipeOutput output, String name, String group, RecipeCategory toStorageCategory, Supplier<? extends ItemLike> storage, RecipeCategory toComponentCategory, Supplier<? extends ItemLike> component) {
        ResourceLocationBuilder crafting = this.craftingRoot().append(name);
        this.storageBlock2x2(output, name, group, crafting.buildWithSuffix("_component_to_storage2x2"), toStorageCategory, storage, crafting.buildWithSuffix("_storage2x2_to_component"), toComponentCategory, component);
    }

    protected void nugget(RecipeOutput output, String name, String group, ResourceLocation toIngotId, RecipeCategory toIngotCategory, Supplier<? extends ItemLike> ingot, ResourceLocation toNuggetId, RecipeCategory toNuggetCategory, Supplier<? extends ItemLike> nugget) {
        this.shapeless(toIngotCategory, ingot).requires(nugget.get(), 9).group(group).unlockedBy("has_item", ModRecipeProvider.has((ItemLike)nugget.get())).save(output, toIngotId);
        this.shapeless(toNuggetCategory, nugget, 9).requires(ingot.get()).group(group).unlockedBy("has_item", ModRecipeProvider.has((ItemLike)ingot.get())).save(output, toNuggetId);
    }

    protected void nugget(RecipeOutput output, String name, String group, RecipeCategory toIngotCategory, Supplier<? extends ItemLike> ingot, RecipeCategory toNuggetCategory, Supplier<? extends ItemLike> nugget) {
        ResourceLocationBuilder crafting = this.craftingRoot().append(name);
        this.nugget(output, name, group, crafting.buildWithSuffix("_nugget_to_ingot"), toIngotCategory, ingot, crafting.buildWithSuffix("_ingot_to_nugget"), toNuggetCategory, nugget);
    }

    @Override
    public void provideData() {
    }

    @Override
    public CompletableFuture<?> processData(CachedOutput cache, HolderLookup.Provider registryLookup) {
        return super.run(cache);
    }

    @Override
    public ProviderSettings getSettings() {
        return this._settings;
    }

    private static void validateResultAndCategory(RecipeCategory category, Supplier<? extends ItemLike> result) {
        Preconditions.checkNotNull((Object)category, (Object)"Category must not be null");
        Preconditions.checkNotNull(result, (Object)"Result must not be null");
    }

    private static void validateCookingParameters(Ingredient ingredient, float experience, int cookingTime) {
        Preconditions.checkNotNull((Object)ingredient, (Object)"ingredient must not be null");
        Preconditions.checkArgument((experience >= 0.0f ? 1 : 0) != 0, (Object)"Experience must be greater than or equal to zero");
        Preconditions.checkArgument((cookingTime >= 0 ? 1 : 0) != 0, (Object)"Amount must be greater than or equal to zero");
    }
}

