/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.data.ModCodecs;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.Objects;
import java.util.function.BiFunction;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.Mth;

public class WideAmount
extends Number
implements Comparable<WideAmount> {
    public static final WideAmount MAX_VALUE;
    public static final WideAmount ZERO;
    public static final WideAmount ONE;
    public static final ModCodecs<WideAmount, ByteBuf> CODECS;
    private static final int MAX_DECIMAL_DIGITS = 4;
    private static final short MAX_DECIMAL_VALUE = 9999;
    private static final short SINGLE_UNIT = 10000;
    private static final double MAX_VALUE_AS_DOUBLE;
    private static final long MAX_LONG_SHIFT;
    private static final DecimalFormat DECIMAL_FORMAT;
    private long _integerPart;
    private short _decimalPart;

    public static WideAmount from(long integerPart, short decimalPart) {
        return WideAmount.getKnowValueOrCreate(integerPart, decimalPart, WideAmount::new);
    }

    public static WideAmount from(long integerPart) {
        return WideAmount.from(integerPart, (short)0);
    }

    public static WideAmount from(double value) {
        return WideAmount.from(WideAmount.integerPartFrom(value), WideAmount.decimalPartFrom(value));
    }

    public static WideAmount asImmutable(long integerPart, short decimalPart) {
        return WideAmount.getKnowValueOrCreate(integerPart, decimalPart, Immutable::new);
    }

    public static WideAmount asImmutable(long integerPart) {
        return WideAmount.asImmutable(integerPart, (short)0);
    }

    public static WideAmount asImmutable(double value) {
        return WideAmount.asImmutable(WideAmount.integerPartFrom(value), WideAmount.decimalPartFrom(value));
    }

    public static WideAmount parse(String text) {
        int index = text.indexOf(".");
        long integerPart = index == -1 ? Long.parseUnsignedLong(text) : Long.parseUnsignedLong(text.substring(0, index));
        return WideAmount.from(integerPart, WideAmount.parseDecimal(text, index));
    }

    public WideAmount toImmutable() {
        return WideAmount.asImmutable(this._integerPart, this._decimalPart);
    }

    public WideAmount copy() {
        return WideAmount.from(this._integerPart, this._decimalPart);
    }

    public long getIntegerPart() {
        return this._integerPart;
    }

    public short getDecimalPart() {
        return this._decimalPart;
    }

    public boolean isZero() {
        return WideAmount.isZero(this._integerPart, this._decimalPart);
    }

    public boolean equals(WideAmount other) {
        return this._integerPart == other.getIntegerPart() && this._decimalPart == other.getDecimalPart();
    }

    public static WideAmount min(WideAmount a, WideAmount b) {
        return a.greaterThan(b) ? b : a;
    }

    public static WideAmount max(WideAmount a, WideAmount b) {
        return a.greaterThan(b) ? a : b;
    }

    public static WideAmount clamp(WideAmount value, WideAmount min, WideAmount max) {
        return WideAmount.max(WideAmount.min(max, value), min);
    }

    public boolean smallerThan(WideAmount other) {
        return this.compareTo(other) < 0;
    }

    public boolean smallerOrEqual(WideAmount other) {
        return this.compareTo(other) <= 0;
    }

    public boolean greaterThan(WideAmount other) {
        return this.compareTo(other) > 0;
    }

    public boolean greaterOrEqual(WideAmount other) {
        return this.compareTo(other) >= 0;
    }

    public WideAmount set(WideAmount other) {
        return this.set(other.getIntegerPart(), other.getDecimalPart());
    }

    public WideAmount add(WideAmount other) {
        return this.add(other.getIntegerPart(), other.getDecimalPart());
    }

    public WideAmount add(long other) {
        return this.add(other, (short)0);
    }

    public WideAmount add(double other) {
        if (other < 0.0) {
            throw WideAmount.cantBeNegativeException();
        }
        return this.add(WideAmount.integerPartFrom(other), WideAmount.decimalPartFrom(other));
    }

    public WideAmount subtract(WideAmount other) {
        return this.subtract(other.getIntegerPart(), other.getDecimalPart());
    }

    public WideAmount subtract(long other) {
        return this.subtract(other, (short)0);
    }

    public WideAmount subtract(double other) {
        if (other < 0.0) {
            throw WideAmount.cantBeNegativeException();
        }
        return this.subtract(WideAmount.integerPartFrom(other), WideAmount.decimalPartFrom(other));
    }

    public WideAmount multiply(WideAmount other) {
        return this.multiply(other.getIntegerPart(), other.getDecimalPart());
    }

    public WideAmount multiply(long other) {
        return this.multiply(other, (short)0);
    }

    public WideAmount multiply(double other) {
        if (other < 0.0) {
            throw WideAmount.cantBeNegativeException();
        }
        return this.multiply(WideAmount.integerPartFrom(other), WideAmount.decimalPartFrom(other));
    }

    public WideAmount divide(WideAmount other) {
        if (other.isZero()) {
            throw WideAmount.divisionByZeroException();
        }
        if (this.isZero()) {
            return ZERO;
        }
        if (0 == other.getDecimalPart()) {
            return this.divide(other.getIntegerPart());
        }
        BigDecimal divide = new BigDecimal(this.toString()).divide(new BigDecimal(other.toString()), 4, RoundingMode.HALF_UP);
        return this.set(divide.longValue(), WideAmount.parseDecimal(divide.toPlainString()));
    }

    public WideAmount divide(long other) {
        long decimalPart;
        if (0L == other) {
            throw WideAmount.divisionByZeroException();
        }
        if (this.isZero()) {
            return ZERO;
        }
        long remainder = Long.remainderUnsigned(this._integerPart, other);
        long integerPart = Long.divideUnsigned(this._integerPart, other);
        if (Long.compareUnsigned(remainder, MAX_LONG_SHIFT / 10L) >= 0) {
            decimalPart = Long.divideUnsigned(remainder, Long.divideUnsigned(other, 100000L));
        } else {
            decimalPart = Long.divideUnsigned(remainder * 10000L * 10L, other);
            decimalPart += Long.divideUnsigned((long)this._decimalPart * 10L, other);
        }
        if (Long.remainderUnsigned(decimalPart, 10L) >= 5L && (decimalPart += 10L) >= 100000L) {
            ++integerPart;
            decimalPart -= 100000L;
        }
        return this.set(integerPart, (short)(decimalPart /= 10L));
    }

    public WideAmount divide(double other) {
        if (other < 0.0) {
            throw WideAmount.cantBeNegativeException();
        }
        return this.divide(WideAmount.from(other));
    }

    public long divideToUnsignedLong(WideAmount other) {
        if (other.isZero()) {
            throw WideAmount.divisionByZeroException();
        }
        if (this.smallerThan(other)) {
            return 0L;
        }
        long otherIntegerPart = other.getIntegerPart();
        short otherDecimalPart = other.getDecimalPart();
        if (other.greaterOrEqual(ONE)) {
            if (Long.compareUnsigned(otherIntegerPart, MAX_LONG_SHIFT) <= 0) {
                long div = otherIntegerPart * 10000L + (long)otherDecimalPart;
                return Long.divideUnsigned(this._decimalPart, div) * 10000L + Long.divideUnsigned(Long.remainderUnsigned(this._integerPart, div) * 10000L, div);
            }
            if (Long.compareUnsigned(otherIntegerPart, Long.divideUnsigned(-1L, 2L) + 1L) >= 0) {
                return 1L;
            }
            long quotient = Long.divideUnsigned(this._integerPart, otherIntegerPart);
            if (quotient != Long.divideUnsigned(this._integerPart, otherIntegerPart + 1L) && otherIntegerPart * quotient + Long.divideUnsigned((long)otherDecimalPart * quotient, 9999L) > this._integerPart) {
                return quotient - 1L;
            }
            return quotient;
        }
        if (Long.compareUnsigned(this._integerPart, MAX_LONG_SHIFT) >= 0) {
            return Long.divideUnsigned(this._integerPart, otherDecimalPart) * 9999L + Long.divideUnsigned(Long.remainderUnsigned(this._integerPart, otherDecimalPart) * 9999L, otherDecimalPart) + (long)this._decimalPart * 9999L / (long)otherDecimalPart;
        }
        return Long.divideUnsigned(this._integerPart * 9999L, otherDecimalPart) + (long)this._decimalPart * 9999L / (long)otherDecimalPart;
    }

    public long divideToSignedLong(WideAmount other) {
        return CodeHelper.mathClampUnsignedToLong(this.divideToUnsignedLong(other));
    }

    public int divideToInt(WideAmount other) {
        return CodeHelper.mathClampUnsignedToInt(this.divideToSignedLong(other));
    }

    public double percentage(WideAmount total) {
        return total.isZero() || this.greaterThan(total) ? 1.0 : this.copy().divide(total).doubleValue();
    }

    public String toString(int decimalPlaces) {
        Object decimalAsString;
        int numberOfDigits;
        if (0 == this._decimalPart) {
            return Long.toUnsignedString(this._integerPart);
        }
        if (decimalPlaces > 4) {
            decimalPlaces = 4;
        }
        if ((numberOfDigits = ((String)(decimalAsString = Short.toString(this._decimalPart))).length()) < 4) {
            decimalAsString = CodeHelper.zeroFilled(4 - numberOfDigits) + (String)decimalAsString;
            numberOfDigits = 4;
        }
        if (numberOfDigits > decimalPlaces) {
            decimalAsString = ((String)decimalAsString).substring(0, decimalPlaces);
        }
        return Long.toUnsignedString(this._integerPart) + "." + (String)decimalAsString;
    }

    public Tag serializeToNBT() {
        return (Tag)CODECS.encode(this, NbtOps.INSTANCE).getOrThrow();
    }

    public static WideAmount deserializeFromNBT(Tag data) {
        return (WideAmount)CODECS.decode(data, NbtOps.INSTANCE).getOrThrow();
    }

    @Override
    public int compareTo(WideAmount other) {
        return WideAmount.compareTo(this._integerPart, this._decimalPart, other.getIntegerPart(), other.getDecimalPart());
    }

    @Override
    public int intValue() {
        return CodeHelper.mathClampUnsignedToInt(this._integerPart);
    }

    @Override
    public long longValue() {
        return CodeHelper.mathClampUnsignedToLong(this._integerPart);
    }

    @Override
    public float floatValue() {
        return CodeHelper.mathUnsignedLongToFloat(this._integerPart) + (float)this._decimalPart / 10000.0f;
    }

    @Override
    public double doubleValue() {
        return CodeHelper.mathUnsignedLongToDouble(this._integerPart) + (double)this._decimalPart / 10000.0;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof WideAmount && this.equals((WideAmount)other);
    }

    public int hashCode() {
        return Objects.hash(this._integerPart, this._decimalPart);
    }

    public String toString() {
        return this.toString(4);
    }

    private WideAmount(long integerPart, short decimalPart) {
        this._integerPart = integerPart;
        this._decimalPart = (short)Mth.clamp((int)decimalPart, (int)0, (int)9999);
    }

    private static WideAmount getKnowValueOrCreate(long integerPart, short decimalPart, BiFunction<Long, Short, WideAmount> factory) {
        if (WideAmount.isZero(integerPart, decimalPart)) {
            return ZERO;
        }
        if (WideAmount.isOne(integerPart, decimalPart)) {
            return ONE;
        }
        if (WideAmount.isMaxValue(integerPart, decimalPart)) {
            return MAX_VALUE;
        }
        return factory.apply(integerPart, decimalPart);
    }

    protected WideAmount set(long integerPart, short decimalPart) {
        this._integerPart = integerPart;
        this._decimalPart = (short)Mth.clamp((int)decimalPart, (int)0, (int)9999);
        return this;
    }

    private WideAmount add(long otherIntegerPart, short otherDecimalPart) {
        if (this._integerPart < 0L && otherIntegerPart < 0L || (this._integerPart < 0L || otherIntegerPart < 0L) && this._integerPart + otherIntegerPart >= 0L) {
            return this.set(MAX_VALUE);
        }
        long newIntegerPart = this._integerPart + otherIntegerPart;
        int newDecimalPart = this._decimalPart + otherDecimalPart;
        if (newDecimalPart > 9999) {
            if (-1L == newIntegerPart) {
                newDecimalPart = 9999;
            } else {
                newDecimalPart = (short)(newDecimalPart - 10000);
                ++newIntegerPart;
            }
        }
        return this.set(newIntegerPart, (short)newDecimalPart);
    }

    private WideAmount subtract(long otherIntegerPart, short otherDecimalPart) {
        if (WideAmount.compareTo(otherIntegerPart, otherDecimalPart, this._integerPart, this._decimalPart) > 0) {
            return this.set(ZERO);
        }
        long newIntegerPart = this._integerPart - otherIntegerPart;
        short newDecimalPart = (short)(this._decimalPart - otherDecimalPart);
        if (newDecimalPart < 0) {
            newDecimalPart = (short)(newDecimalPart + 10000);
            --newIntegerPart;
        }
        return this.set(newIntegerPart, newDecimalPart);
    }

    private WideAmount multiply(long otherIntegerPart, short otherDecimalPart) {
        if (CodeHelper.mathUnsignedLongMultiplicationWillOverFlow(this._integerPart, otherIntegerPart)) {
            return this.set(MAX_VALUE);
        }
        WideAmount temp = WideAmount.from(WideAmount.clampedMultiplyLongs(this._integerPart, otherIntegerPart));
        temp = temp.add(WideAmount.clampedMultiplyLongAndDecimal(this._integerPart, otherDecimalPart));
        temp = temp.add(WideAmount.clampedMultiplyLongAndDecimal(otherIntegerPart, this._decimalPart));
        temp = temp.add(WideAmount.clampedMultiplyDecimals(this._decimalPart, otherDecimalPart));
        return this.set(temp);
    }

    protected static int compareTo(long xIntegerPart, short xDecimalPart, long yIntegerPart, short yDecimalPart) {
        int comparison = Long.compareUnsigned(xIntegerPart, yIntegerPart);
        return 0 == comparison ? Short.compare(xDecimalPart, yDecimalPart) : comparison;
    }

    protected static boolean isZero(long integerPart, short decimalPart) {
        return 0L == integerPart && decimalPart <= 0;
    }

    protected static boolean isOne(long integerPart, short decimalPart) {
        return 1L == integerPart && decimalPart == 0;
    }

    protected static boolean isMaxValue(long integerPart, short decimalPart) {
        return MAX_VALUE.getIntegerPart() == integerPart && MAX_VALUE.getDecimalPart() == decimalPart;
    }

    private static long clampedMultiplyLongs(long a, long b) {
        if (a == 0L || b == 0L) {
            return 0L;
        }
        if (CodeHelper.mathUnsignedLongMultiplicationWillOverFlow(a, b)) {
            return -1L;
        }
        return a * b;
    }

    private static WideAmount clampedMultiplyDecimals(short a, short b) {
        return WideAmount.from(0L, (short)((long)a * (long)b / 10000L));
    }

    private static WideAmount clampedMultiplyLongAndDecimal(long integerPart, short decimalPart) {
        if (Long.compareUnsigned(integerPart, Long.divideUnsigned(-1L, 10000L)) > 0) {
            return WideAmount.from(Long.divideUnsigned(integerPart, 10000L) * (long)decimalPart, (short)(integerPart % 10000L * (long)decimalPart));
        }
        return WideAmount.from(Long.divideUnsigned(integerPart * (long)decimalPart, 10000L), (short)(integerPart * (long)decimalPart % 10000L));
    }

    protected static long integerPartFrom(double value) {
        if (value > MAX_VALUE_AS_DOUBLE) {
            return MAX_VALUE.getIntegerPart();
        }
        if (value < 0.0) {
            return ZERO.getIntegerPart();
        }
        return (long)value;
    }

    protected static short decimalPartFrom(double value) {
        return WideAmount.parseDecimal(DECIMAL_FORMAT.format(value));
    }

    protected static short parseDecimal(String string) {
        return WideAmount.parseDecimal(string, string.indexOf("."));
    }

    protected static short parseDecimal(String string, int index) {
        if (index == -1) {
            return 0;
        }
        Object decimals = string.substring(index + 1);
        int digitsCount = ((String)decimals).length();
        if (digitsCount < 4) {
            decimals = (String)decimals + CodeHelper.zeroFilled(4 - digitsCount);
        } else if (digitsCount > 4) {
            decimals = ((String)decimals).substring(0, 4);
        }
        return Short.parseShort((String)decimals);
    }

    private static RuntimeException cantBeNegativeException() {
        return new IllegalArgumentException("The value provided is a negative number and this is not supported. WideValues are always positive.");
    }

    private static RuntimeException divisionByZeroException() {
        return new ArithmeticException("Division by zero");
    }

    static {
        CODECS = new ModCodecs(RecordCodecBuilder.create(instance -> instance.group((App)Codec.LONG.fieldOf("i").forGetter(WideAmount::getIntegerPart), (App)Codec.SHORT.fieldOf("d").forGetter(WideAmount::getDecimalPart)).apply((Applicative)instance, WideAmount::from)), StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_LONG, WideAmount::getIntegerPart, (StreamCodec)ByteBufCodecs.SHORT, WideAmount::getDecimalPart, WideAmount::from));
        ZERO = new Immutable(0L, 0);
        ONE = new Immutable(1L, 0);
        MAX_VALUE = new Immutable(-1L, 9999);
        MAX_VALUE_AS_DOUBLE = Double.parseDouble(MAX_VALUE.toString());
        MAX_LONG_SHIFT = Long.divideUnsigned(Long.divideUnsigned(-1L, 10000L), 10000L);
        DECIMAL_FORMAT = new DecimalFormat("0.0000", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
    }

    private static class Immutable
    extends WideAmount {
        private Immutable(long integerPart, short decimalPart) {
            super(integerPart, decimalPart);
        }

        @Override
        public WideAmount toImmutable() {
            return this;
        }

        @Override
        public WideAmount copy() {
            return this;
        }

        @Override
        protected WideAmount set(long integerPart, short decimalPart) {
            return Immutable.from(integerPart, (short)Mth.clamp((int)decimalPart, (int)0, (int)9999));
        }
    }
}

