/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.data;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Arrays;
import net.minecraft.ResourceLocationException;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class ResourceLocationBuilder {
    private final String _namespace;
    @Nullable
    private final String _path;
    @Nullable
    private final String _name;

    public static ResourceLocationBuilder of(String namespace) {
        return new ResourceLocationBuilder(namespace, null, null);
    }

    public static ResourceLocationBuilder of(ResourceLocation location) {
        String name;
        Preconditions.checkNotNull((Object)location, (Object)"Location must not be null");
        String path = location.getPath();
        if (path.contains("/")) {
            String[] components = path.split("/");
            name = components[components.length - 1];
            components = Arrays.copyOf(components, components.length - 1);
            path = ResourceLocationBuilder.rebuildPath(null, components);
        } else {
            name = path;
            path = null;
        }
        return new ResourceLocationBuilder(location.getNamespace(), path, name);
    }

    public static ResourceLocationBuilder vanilla() {
        return ResourceLocationBuilder.of("minecraft");
    }

    public String namespace() {
        return this._namespace;
    }

    public ResourceLocationBuilder appendPath(String ... pathComponents) {
        Preconditions.checkArgument((pathComponents.length > 0 ? 1 : 0) != 0, (Object)"At least one path component must be provided");
        return new ResourceLocationBuilder(this._namespace, ResourceLocationBuilder.rebuildPath(this._path, pathComponents), this._name);
    }

    public ResourceLocationBuilder append(String nameSuffix) {
        ResourceLocationBuilder.validateName(nameSuffix);
        return new ResourceLocationBuilder(this._namespace, this._path, (String)(null != this._name ? this._name + nameSuffix : nameSuffix));
    }

    public ResourceLocationBuilder prepend(String namePrefix) {
        ResourceLocationBuilder.validateName(namePrefix);
        return new ResourceLocationBuilder(this._namespace, this._path, (String)(null != this._name ? namePrefix + this._name : namePrefix));
    }

    public ResourceLocation build() {
        return this.build(null, null);
    }

    public ResourceLocation buildWithPrefix(String prefix) {
        return this.build(prefix, null);
    }

    public ResourceLocation buildWithSuffix(String suffix) {
        return this.build(null, suffix);
    }

    private ResourceLocationBuilder(String namespace, @Nullable String path, @Nullable String name) {
        ResourceLocationBuilder.validateNamespace(namespace);
        this._namespace = namespace;
        this._path = path;
        this._name = name;
    }

    private static void validateNamespace(String namespace) {
        if (Strings.isNullOrEmpty((String)namespace) || !ResourceLocation.isValidNamespace((String)namespace)) {
            throw new ResourceLocationException("Invalid ResourceLocation namespace: " + namespace);
        }
    }

    private static void validateName(String name) {
        if (Strings.isNullOrEmpty((String)name) || !ResourceLocation.isValidNamespace((String)name)) {
            throw new ResourceLocationException("Invalid ResourceLocation name: " + name);
        }
    }

    @Nullable
    private static String rebuildPath(@Nullable String current, String ... pathComponents) {
        StringBuilder builder = new StringBuilder(256);
        if (!Strings.isNullOrEmpty((String)current)) {
            builder.append(current);
            if (!current.endsWith("/")) {
                builder.append("/");
            }
        }
        for (String component : pathComponents) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)component) ? 1 : 0) != 0, (Object)"Every path components must not be null or empty");
            Preconditions.checkArgument((boolean)ResourceLocation.isValidPath((String)component), (String)"Invalid path component for a ResourceLocation: %s", (Object)component);
            builder.append(component);
            if (component.endsWith("/")) continue;
            builder.append("/");
        }
        return builder.length() > 0 ? builder.toString() : null;
    }

    private ResourceLocation build(@Nullable String prefix, @Nullable String suffix) {
        Object fullName = "";
        if (!Strings.isNullOrEmpty((String)prefix)) {
            ResourceLocationBuilder.validateName(prefix);
            fullName = prefix;
        }
        if (null != this._name) {
            fullName = (String)fullName + this._name;
        }
        if (!Strings.isNullOrEmpty((String)suffix)) {
            ResourceLocationBuilder.validateName(suffix);
            fullName = (String)fullName + suffix;
        }
        Preconditions.checkState((!((String)fullName).isEmpty() || !Strings.isNullOrEmpty((String)this._path) ? 1 : 0) != 0, (Object)"A path or a name must be set before building a ResourceLocation");
        return ResourceLocation.fromNamespaceAndPath((String)this._namespace, (String)(null != this._path ? this._path + (String)fullName : fullName));
    }
}

