/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.client.gui.control;

import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.client.gui.ButtonState;
import it.zerono.mods.zerocore.lib.client.gui.DesiredDimension;
import it.zerono.mods.zerocore.lib.client.gui.IWindow;
import it.zerono.mods.zerocore.lib.client.gui.ModContainerScreen;
import it.zerono.mods.zerocore.lib.client.gui.Theme;
import it.zerono.mods.zerocore.lib.client.gui.control.AbstractTextualControl;
import it.zerono.mods.zerocore.lib.client.gui.sprite.ISprite;
import it.zerono.mods.zerocore.lib.client.gui.sprite.Sprite;
import it.zerono.mods.zerocore.lib.client.gui.sprite.SpriteSet;
import it.zerono.mods.zerocore.lib.data.geometry.Rectangle;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModContainer;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;

public abstract class AbstractButtonControl
extends AbstractTextualControl {
    private SpriteSet<ButtonState> _iconSet = null;
    private boolean _autoSize = false;

    public AbstractButtonControl(ModContainerScreen<? extends ModContainer> gui, String name, String text) {
        super(gui, name, text);
    }

    public boolean getAutoSize() {
        return this._autoSize;
    }

    public void setAutoSize(boolean autoSize) {
        this._autoSize = autoSize;
    }

    public ISprite getIconForState(ButtonState state) {
        if (null == this._iconSet) {
            return Sprite.EMPTY;
        }
        return this._iconSet.getOrDefault(state);
    }

    public void setIconForState(ISprite icon, ButtonState state) {
        if (null == this._iconSet) {
            this._iconSet = new SpriteSet((Enum[])ButtonState.values());
        }
        this._iconSet.set(state, icon);
    }

    public void setIconForState(ISprite icon, ButtonState firstState, ButtonState secondState, ButtonState ... otherStates) {
        this.setIconForState(icon, firstState);
        this.setIconForState(icon, secondState);
        if (null != otherStates && otherStates.length > 0) {
            for (ButtonState state : otherStates) {
                this.setIconForState(icon, state);
            }
        }
    }

    @Override
    public int getDesiredDimension(DesiredDimension dimension) {
        if (this.getAutoSize()) {
            switch (dimension) {
                case Width: {
                    return this.getTextWidth() + this.getPadding().getLeft() + this.getPadding().getRight();
                }
            }
        }
        return super.getDesiredDimension(dimension);
    }

    @Override
    public void onPaint(GuiGraphics gfx, float partialTicks, int mouseX, int mouseY) {
        this.getIconFromState(this.getButtonState()).ifPresent(sprite -> this.paintButtonSprite(gfx, (ISprite)sprite));
        super.onPaint(gfx, partialTicks, mouseX, mouseY);
    }

    @Override
    public boolean onMouseClicked(IWindow wnd, int mouseX, int mouseY, int clickedButton) {
        boolean handled = super.onMouseClicked(wnd, mouseX, mouseY, clickedButton);
        if (handled) {
            this.playClickSound();
        }
        return handled;
    }

    protected Optional<ISprite> getIconFromState(ButtonState state) {
        return null == this._iconSet ? Optional.empty() : CodeHelper.optionalOr(this._iconSet.get(state), () -> this._iconSet.get(ButtonState.Default));
    }

    protected int getIconWidth() {
        return this.getIconFromState(this.getButtonState()).map(ISprite::getWidth).orElse(0);
    }

    protected int getIconHeight() {
        return this.getIconFromState(this.getButtonState()).map(ISprite::getHeight).orElse(0);
    }

    @Override
    protected int getTextOffsetX() {
        return this.getIconWidth();
    }

    protected abstract ButtonState getButtonState();

    protected void playClickSound() {
        this.playSound((Holder<SoundEvent>)SoundEvents.UI_BUTTON_CLICK);
    }

    protected void paintButton3D(GuiGraphics gfx, ButtonState state, int x, int y, int width, int height) {
        Theme theme = this.getTheme();
        switch (state) {
            case DefaultDisabled: {
                this.paintButton3D(gfx, x, y, width, height, theme.DARK_OUTLINE_COLOR, theme.BUTTON_DISABLED_3D_GRADIENT_LIGHT, theme.BUTTON_DISABLED_3D_GRADIENT_DARK, theme.BUTTON_DISABLED_3D_BORDER_LIGHT, theme.BUTTON_DISABLED_3D_BORDER_DARK);
                break;
            }
            case Active: 
            case ActiveHighlighted: {
                this.paintButton3D(gfx, x, y, width, height, theme.DARK_OUTLINE_COLOR, theme.BUTTON_ACTIVE_3D_GRADIENT_LIGHT, theme.BUTTON_ACTIVE_3D_GRADIENT_DARK, theme.BUTTON_ACTIVE_3D_BORDER_LIGHT, theme.BUTTON_ACTIVE_3D_BORDER_DARK);
                break;
            }
            case DefaultHighlighted: {
                this.paintButton3D(gfx, x, y, width, height, theme.DARK_OUTLINE_COLOR, theme.BUTTON_HIGHLIGHTED_3D_GRADIENT_LIGHT, theme.BUTTON_HIGHLIGHTED_3D_GRADIENT_DARK, theme.BUTTON_HIGHLIGHTED_3D_BORDER_LIGHT, theme.BUTTON_HIGHLIGHTED_3D_BORDER_DARK);
                break;
            }
            case Default: {
                this.paintButton3D(gfx, x, y, width, height, theme.DARK_OUTLINE_COLOR, theme.BUTTON_NORMAL_3D_GRADIENT_LIGHT, theme.BUTTON_NORMAL_3D_GRADIENT_DARK, theme.BUTTON_NORMAL_3D_BORDER_LIGHT, theme.BUTTON_NORMAL_3D_BORDER_DARK);
            }
        }
    }

    private void paintButtonSprite(GuiGraphics gfx, ISprite sprite) {
        Rectangle paddedBounds = this.getPaddingRect();
        this.paintSprite(gfx, sprite, paddedBounds.getX1(), paddedBounds.getY1(), Math.min(sprite.getWidth(), paddedBounds.Width), Math.min(sprite.getHeight(), paddedBounds.Height));
    }
}

