/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.client.gui;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.text.TextHelper;
import java.util.List;
import java.util.function.Function;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.jetbrains.annotations.NotNull;

public class ToolTipsBuilder {
    private final ImmutableList.Builder<Component> _texts = ImmutableList.builder();
    private final ImmutableList.Builder<Object> _objects = ImmutableList.builder();

    public ImmutablePair<List<Component>, List<Object>> build() {
        return new ImmutablePair((Object)this._texts.build(), (Object)this._objects.build());
    }

    public ToolTipsBuilder addText(Component text) {
        Preconditions.checkNotNull((Object)text, (Object)"Text must not be null.");
        this._texts.add((Object)text);
        return this;
    }

    public ToolTipsBuilder addText(MutableComponent text, Function<@NotNull MutableComponent, @NotNull MutableComponent> textPostProcessor) {
        Preconditions.checkNotNull((Object)text, (Object)"Text must not be null.");
        Preconditions.checkNotNull(textPostProcessor, (Object)"Text post processor must not be null.");
        this._texts.add((Object)((Component)textPostProcessor.apply(text)));
        return this;
    }

    public ToolTipsBuilder addText(MutableComponent text, Component ... siblings) {
        Preconditions.checkNotNull((Object)text, (Object)"Text must not be null.");
        this._texts.add((Object)text);
        ToolTipsBuilder.appendSiblings(text, siblings);
        return this;
    }

    public ToolTipsBuilder addText(MutableComponent text, Function<@NotNull MutableComponent, @NotNull MutableComponent> textPostProcessor, Component ... siblings) {
        this.addText(text, textPostProcessor);
        ToolTipsBuilder.appendSiblings(text, siblings);
        return this;
    }

    public ToolTipsBuilder addLiteral(String text) {
        if (Strings.isNullOrEmpty((String)text)) {
            return this.addEmptyLine();
        }
        return this.addText((Component)TextHelper.literal(text));
    }

    public ToolTipsBuilder addLiteral(String text, Function<@NotNull MutableComponent, @NotNull MutableComponent> textPostProcessor) {
        if (Strings.isNullOrEmpty((String)text)) {
            return this.addEmptyLine();
        }
        return this.addText(TextHelper.literal(text), textPostProcessor);
    }

    public ToolTipsBuilder addTranslatable(String langKey) {
        return this.addText((Component)TextHelper.translatable(langKey));
    }

    public ToolTipsBuilder addTranslatable(String langKey, Function<@NotNull MutableComponent, @NotNull MutableComponent> textPostProcessor) {
        return this.addText(TextHelper.translatable(langKey), textPostProcessor);
    }

    public ToolTipsBuilder addTranslatable(String langKey, Object ... arguments) {
        return this.addText((Component)TextHelper.translatable(langKey, arguments));
    }

    public ToolTipsBuilder addTranslatable(String langKey, Function<@NotNull MutableComponent, @NotNull MutableComponent> textPostProcessor, Object ... arguments) {
        return this.addText(TextHelper.translatable(langKey, arguments), textPostProcessor);
    }

    public ToolTipsBuilder addEmptyLine() {
        return this.addText(CodeHelper.TEXT_EMPTY_LINE);
    }

    public ToolTipsBuilder addObject(Object object) {
        this._objects.add(object);
        return this;
    }

    public ToolTipsBuilder addObject(Object object, Object ... others) {
        this._objects.add(object);
        for (Object o : others) {
            this._objects.add(o);
        }
        return this;
    }

    protected static void appendSiblings(MutableComponent text, Component ... siblings) {
        for (Component sibling : siblings) {
            text.append(sibling);
        }
    }
}

