/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.internal.gamecontent;

import it.zerono.mods.zerocore.internal.gamecontent.debugtool.DebugToolItem;
import it.zerono.mods.zerocore.lib.data.ModCodecs;
import it.zerono.mods.zerocore.lib.data.component.FluidStackListComponent;
import it.zerono.mods.zerocore.lib.data.component.FluidTankComponent;
import it.zerono.mods.zerocore.lib.data.component.ItemStackListComponent;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.NotNull;

public class Content {
    private static final DeferredRegister<Item> ITEMS = DeferredRegister.create((Registry)BuiltInRegistries.ITEM, (String)"zerocore");
    private static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((Registry)BuiltInRegistries.FEATURE, (String)"zerocore");
    private static final DeferredRegister<DataComponentType<?>> DATA_COMPONENTS = DeferredRegister.create((Registry)BuiltInRegistries.DATA_COMPONENT_TYPE, (String)"zerocore");
    public static final Supplier<@NotNull DebugToolItem> DEBUG_TOOL = ITEMS.register("debugtool", DebugToolItem::new);
    public static final Supplier<@NotNull DataComponentType<ItemStackListComponent>> ITEMSTACK_COMPONENT_TYPE = Content.registerComponent("itemstacks", ItemStackListComponent.CODECS);
    public static final Supplier<@NotNull DataComponentType<FluidStackListComponent>> FLUIDSTACK_COMPONENT_TYPE = Content.registerComponent("fluidstacks", FluidStackListComponent.CODECS);
    public static final Supplier<@NotNull DataComponentType<FluidTankComponent>> FLUIDTANK_COMPONENT_TYPE = Content.registerComponent("fluid_tank", FluidTankComponent.CODECS);

    public static void initialize(IEventBus modBus) {
        ITEMS.register(modBus);
        FEATURES.register(modBus);
        DATA_COMPONENTS.register(modBus);
        modBus.addListener(Content::modifyCreativeTabs);
    }

    private static <Type> Supplier<@NotNull DataComponentType<Type>> registerComponent(String name, ModCodecs<Type, ? super RegistryFriendlyByteBuf> codecs) {
        return DATA_COMPONENTS.register(name, () -> DataComponentType.builder().persistent(codecs.codec()).networkSynchronized(codecs.streamCodec()).build());
    }

    private static void modifyCreativeTabs(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.TOOLS_AND_UTILITIES) {
            event.accept((ItemLike)DEBUG_TOOL.get());
        }
    }
}

