/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.model;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Hashtable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.Tuple;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.dungeon.model.DungeonModel;
import xiroc.dungeoncrawl.dungeon.model.DungeonModels;
import xiroc.dungeoncrawl.exception.DatapackLoadException;
import xiroc.dungeoncrawl.util.JSONUtils;

public class ModelPools {
    public static final Hashtable<String, ImmutableSet<Tuple<DungeonModel, Integer>>> POOLS = new Hashtable();
    private static final ResourceLocation FILE = DungeonCrawl.locate("dungeon/model_pools.json");

    public static void load(ResourceManager resourceManager) {
        DungeonCrawl.LOGGER.debug("Loading {}", (Object)FILE);
        POOLS.clear();
        try {
            JsonObject file = JsonParser.parseReader((Reader)new InputStreamReader(((Resource)resourceManager.getResource(FILE).orElseThrow(() -> new DatapackLoadException("Missing file: " + String.valueOf(FILE)))).open())).getAsJsonObject();
            JsonObject pools = file.getAsJsonObject("pools");
            pools.entrySet().forEach(entry -> {
                ImmutableSet.Builder builder = new ImmutableSet.Builder();
                ((JsonElement)entry.getValue()).getAsJsonArray().forEach(element -> {
                    JsonObject modelEntry = element.getAsJsonObject();
                    ResourceLocation key = ResourceLocation.parse((String)modelEntry.get("key").getAsString());
                    if (!DungeonModels.KEY_TO_MODEL.containsKey(key)) {
                        DungeonCrawl.LOGGER.warn("Cannot resolve model key " + String.valueOf(key) + " in " + String.valueOf(FILE));
                    } else {
                        builder.add((Object)new Tuple((Object)DungeonModels.KEY_TO_MODEL.get(key), (Object)JSONUtils.getWeight(modelEntry)));
                    }
                });
                ImmutableSet pool = builder.build();
                if (pool.isEmpty()) {
                    throw new DatapackLoadException("Empty model pool " + (String)entry.getKey() + " in " + String.valueOf(FILE));
                }
                POOLS.put((String)entry.getKey(), (ImmutableSet<Tuple<DungeonModel, Integer>>)pool);
            });
        }
        catch (IOException e) {
            DungeonCrawl.LOGGER.error("Failed to load " + String.valueOf(FILE));
            e.printStackTrace();
        }
    }
}

