/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.everythingcopper.common.item;

import cy.jdkdigital.everythingcopper.init.ModDataComponents;
import cy.jdkdigital.everythingcopper.init.ModTags;
import cy.jdkdigital.everythingcopper.util.WeatheringUtils;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.SimpleTier;

public interface ICopperItem {
    public static final Tier COPPER_TIER = new SimpleTier(ModTags.INCORRECT_FOR_COPPER_TOOL, 180, 7.0f, 1.8f, 18, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.COPPER_INGOT}));

    default public void weatheringTick(ItemStack stack, Level level) {
        if (ICopperItem.canAge(stack) && level.random.nextFloat() < 1.8962963E-4f) {
            ICopperItem.setAge(stack, WeatheringUtils.nextState(ICopperItem.getAge(stack)));
        }
    }

    public static boolean isWaxed(ItemStack stack) {
        if (stack.has(ModDataComponents.WAXED)) {
            return Boolean.TRUE.equals(stack.get(ModDataComponents.WAXED));
        }
        return false;
    }

    public static void setWaxed(ItemStack stack, boolean waxed) {
        stack.set(ModDataComponents.WAXED, (Object)waxed);
    }

    public static boolean canAge(ItemStack stack) {
        return !ICopperItem.isWaxed(stack) && !ICopperItem.getAge(stack).equals("oxidized");
    }

    public static String getAge(ItemStack stack) {
        if (stack.has(ModDataComponents.OXIDATION_STATE)) {
            return (String)stack.get(ModDataComponents.OXIDATION_STATE);
        }
        return "unaffected";
    }

    public static void setAge(ItemStack stack, String age) {
        stack.set(ModDataComponents.OXIDATION_STATE, (Object)age);
    }

    public static Float getStateAsFloat(ItemStack stack) {
        if (stack.has(ModDataComponents.OXIDATION_STATE)) {
            String state;
            return switch (state = (String)stack.get(ModDataComponents.OXIDATION_STATE)) {
                case "exposed" -> Float.valueOf(1.0f);
                case "weathered" -> Float.valueOf(2.0f);
                case "oxidized" -> Float.valueOf(3.0f);
                default -> Float.valueOf(0.0f);
            };
        }
        return Float.valueOf(0.0f);
    }
}

