/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.item.spirit.calling;

import com.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.klikli_dev.occultism.common.item.spirit.calling.ItemMode;
import com.klikli_dev.occultism.util.EntityUtil;
import com.klikli_dev.occultism.util.ItemNBTUtil;
import com.klikli_dev.occultism.util.TextUtil;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.Capabilities;

public class ExtractItemMode
extends ItemMode {
    public ExtractItemMode() {
        super("set_extract");
    }

    public boolean setSpiritExtractLocation(Player player, Level world, BlockPos pos, ItemStack stack, Direction face) {
        UUID boundSpiritId = ItemNBTUtil.getSpiritEntityUUID(stack);
        if (boundSpiritId != null) {
            Optional<SpiritEntity> boundSpirit = EntityUtil.getEntityByUuiDGlobal(world.getServer(), boundSpiritId).map(e -> (SpiritEntity)e);
            if (boundSpirit.isPresent()) {
                boundSpirit.get().setExtractPosition(pos);
                boundSpirit.get().setExtractFacing(face);
                ItemNBTUtil.updateItemNBTFromEntity(stack, boundSpirit.get());
                String blockName = world.getBlockState(pos).getBlock().getDescriptionId();
                player.displayClientMessage((Component)Component.translatable((String)"item.occultism.book_of_calling.message_set_extract", (Object[])new Object[]{TextUtil.formatDemonName(boundSpirit.get().getName().getString()), Component.translatable((String)blockName), face.getSerializedName()}), true);
                return true;
            }
            player.displayClientMessage((Component)Component.translatable((String)"item.occultism.book_of_calling.message_spirit_not_found"), true);
        }
        return false;
    }

    @Override
    public boolean handle(BlockEntity blockEntity, Player player, Level world, BlockPos pos, ItemStack stack, Direction face) {
        if (blockEntity != null && world.getCapability(Capabilities.ItemHandler.BLOCK, blockEntity.getBlockPos(), blockEntity.getBlockState(), blockEntity, (Object)face) != null) {
            return this.setSpiritExtractLocation(player, world, pos, stack, face);
        }
        return true;
    }
}

