/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.systems;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.common.NeoForgeMod;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.core.XyCraft;
import tv.soaryn.xycraft.core.content.blocks.XyBlock;
import tv.soaryn.xycraft.core.content.systems.BlockTickSystemLevelAttachment;
import tv.soaryn.xycraft.core.content.systems.ServerBlockTickSystem;
import tv.soaryn.xycraft.machines.XyMachines;
import tv.soaryn.xycraft.machines.content.attachments.BalloonStakeAttachment;
import tv.soaryn.xycraft.machines.content.blocks.properties.MachineStateProperties;
import tv.soaryn.xycraft.machines.content.registries.MachinesAttachments;
import tv.soaryn.xycraft.machines.content.registries.MachinesContent;
import tv.soaryn.xycraft.machines.content.systems.MachinesSounds;

public class BalloonStakeTickSystem
extends ServerBlockTickSystem<BlockTickSystemLevelAttachment> {
    public static final ResourceLocation BalloonBoundID = XyCraft.resource((String)"balloon_field_id");
    public static final AttributeModifier InsideField = new AttributeModifier(BalloonBoundID, 1.0, AttributeModifier.Operation.ADD_VALUE);

    public boolean isValidState(ServerLevel level, BlockState state, BlockPos pos) {
        return state.is(MachinesContent.Block.Stake.block());
    }

    public void clean(ServerLevel level, BlockPos.MutableBlockPos pos) {
        XyBlock.clean((Block)MachinesContent.Block.Stake.block(), (ServerLevel)level, (BlockPos.MutableBlockPos)pos);
        XyMachines.Logger.error("Balloon on a Stick at block position [%s] was moved without calling onRemove. Take note of how it may have been moved and please report this on https://github.com/Soaryn/XyCraftTracker/issues");
    }

    protected void tickBlocks(ServerLevel level, BlockTickSystemLevelAttachment data, BlockPos.MutableBlockPos pos, BlockState state, long currentStep) {
        BlockEntity blockEntity = level.getBlockEntity((BlockPos)pos);
        if (blockEntity == null) {
            return;
        }
        BalloonStakeAttachment balloonData = (BalloonStakeAttachment)blockEntity.getData(MachinesAttachments.Block.BalloonData);
        Player player = balloonData.getPlayer((Level)level);
        if (!balloonData.isBound() || player != null) {
            return;
        }
        this.popBalloon((BlockPos)pos, (Level)level, balloonData, (BlockPos)pos, state, blockEntity);
    }

    protected void tickBatchBlocks(ServerLevel level, BlockTickSystemLevelAttachment tickData, BlockPos.MutableBlockPos pos, BlockState state, long currentStep) {
        BlockEntity blockEntity = level.getBlockEntity((BlockPos)pos);
        if (blockEntity == null) {
            return;
        }
        BalloonStakeAttachment data = (BalloonStakeAttachment)blockEntity.getData(MachinesAttachments.Block.BalloonData);
        Player player = data.getPlayer((Level)level);
        if (!data.isBound() || player == null) {
            return;
        }
        AttributeInstance creativeFlight = player.getAttribute(NeoForgeMod.CREATIVE_FLIGHT);
        if (!player.isAlive() || creativeFlight == null) {
            this.popBalloon((BlockPos)pos, (Level)level, data, player.blockPosition(), state, blockEntity);
            return;
        }
        Vec3 playerPos = player.position();
        int range = (Integer)XyMachines.ServerConfig.BalloonOnAStickRange.get();
        Vec3 vecPosOfBlock = Vec3.atCenterOf((Vec3i)pos);
        Vec3 dif = playerPos.subtract(vecPosOfBlock);
        Vec3i difI = new Vec3i(Mth.abs((int)((int)dif.x())), Mth.abs((int)((int)dif.y())), Mth.abs((int)((int)dif.z())));
        if (difI.getX() > range || difI.getY() > range || difI.getZ() > range) {
            if (creativeFlight.hasModifier(BalloonBoundID)) {
                creativeFlight.removeModifier(InsideField);
                player.resetFallDistance();
            }
            this.popBalloon((BlockPos)pos, (Level)level, data, player.blockPosition(), state, blockEntity);
        } else if (!creativeFlight.hasModifier(BalloonBoundID)) {
            creativeFlight.addTransientModifier(InsideField);
        }
    }

    public void popBalloon(BlockPos pos, Level level, BalloonStakeAttachment data, BlockPos boundLocation, BlockState currentState, BlockEntity blockEntity) {
        if (!((Boolean)currentState.getValue((Property)MachineStateProperties.Connected)).booleanValue()) {
            return;
        }
        data.setIsBound(false);
        data.setBoundId(-1);
        blockEntity.setChanged();
        BlockState state = (BlockState)currentState.setValue((Property)MachineStateProperties.Connected, (Comparable)Boolean.valueOf(false));
        level.setBlockAndUpdate(pos, state);
        level.markAndNotifyBlock(pos, level.getChunkAt(pos), state, state, 3, 512);
        float r = Mth.clamp((float)(level.getRandom().nextFloat() - 0.5f), (float)-0.01f, (float)0.1f);
        level.playSound(null, boundLocation, (SoundEvent)MachinesSounds.BalloonPop.value(), SoundSource.BLOCKS, 0.8f, 1.0f + r);
    }

    @NotNull
    protected Supplier<AttachmentType<BlockTickSystemLevelAttachment>> getAttachmentType() {
        return MachinesAttachments.System.BalloonStakeSystemData;
    }
}

