/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.recipes.producers.cryochamber;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.api.content.IStage;
import tv.soaryn.xycraft.core.content.recipe.IRecipeContainer;
import tv.soaryn.xycraft.core.content.recipe.IRecipeContent;
import tv.soaryn.xycraft.core.content.recipe.IRecipeWithStage;
import tv.soaryn.xycraft.core.content.recipe.RecipeContent;
import tv.soaryn.xycraft.core.content.recipe.RecipeSerDes;
import tv.soaryn.xycraft.core.content.stages.IXyStage;
import tv.soaryn.xycraft.core.utils.serialization.BinarySerializer;
import tv.soaryn.xycraft.core.utils.serialization.CodecUtils;
import tv.soaryn.xycraft.core.utils.serialization.Serializer;
import tv.soaryn.xycraft.machines.content.blocks.properties.IOMode;
import tv.soaryn.xycraft.machines.content.registries.MachinesRecipeTypes;

public record CryoChamberRecipe(Either<SizedFluidIngredient, SizedIngredient> input, Either<FluidStack, ItemStack> output, int entropy, long ticks, Optional<IStage> requiredStage) implements IRecipeContent<Input, CryoChamberRecipe>,
IRecipeWithStage
{
    private static final MapCodec<CryoChamberRecipe> codec = RecordCodecBuilder.mapCodec(builder -> builder.group((App)CodecUtils.Codecs.ContentObjectIngredient.fieldOf("ingredient").forGetter(CryoChamberRecipe::input), (App)CodecUtils.Codecs.ContentObject.fieldOf("output").forGetter(CryoChamberRecipe::output), (App)Codec.INT.fieldOf("entropy").forGetter(CryoChamberRecipe::entropy), (App)Codec.LONG.fieldOf("ticks").forGetter(CryoChamberRecipe::ticks), (App)IXyStage.CODEC.optionalFieldOf("stage_required").forGetter(CryoChamberRecipe::requiredStage)).apply((Applicative)builder, CryoChamberRecipe::new));
    private static final BinarySerializer<CryoChamberRecipe> SerDes = BinarySerializer.ofType(CryoChamberRecipe::new, CryoChamberRecipe::input, (BinarySerializer)RecipeSerDes.InputObjectSerDes, CryoChamberRecipe::output, (BinarySerializer)RecipeSerDes.OutputObjectSerDes, CryoChamberRecipe::entropy, (BinarySerializer)Serializer.INTEGER, CryoChamberRecipe::ticks, (BinarySerializer)Serializer.LONG, CryoChamberRecipe::requiredStage, (BinarySerializer)BinarySerializer.optionalOf((BinarySerializer)IXyStage.SerDes));

    public static RecipeSerDes<CryoChamberRecipe> register() {
        return RecipeSerDes.create(codec, SerDes);
    }

    public RecipeContent<CryoChamberRecipe> getContent() {
        return MachinesRecipeTypes.CryoChamber;
    }

    public IOMode inputMode() {
        return this.input.left().isPresent() ? IOMode.Fluid : IOMode.Item;
    }

    public IOMode outputMode() {
        return this.output.left().isPresent() ? IOMode.Fluid : IOMode.Item;
    }

    public boolean matches(@NotNull Input input, @NotNull Level level) {
        return input.getHeatValue() <= (long)this.entropy && (Boolean)this.input.map(left -> left.test(input.getInputFluid()), right -> right.test(input.getInputItem())) != false;
    }

    public Optional<IStage> getRequiredStage() {
        return this.requiredStage();
    }

    public static interface Input
    extends IRecipeContainer {
        public long getHeatValue();

        public ItemStack getInputItem();

        public FluidStack getInputFluid();
    }
}

