/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.recipes.producers.centrifuge;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.api.content.IStage;
import tv.soaryn.xycraft.core.content.recipe.IRecipeContainer;
import tv.soaryn.xycraft.core.content.recipe.IRecipeContent;
import tv.soaryn.xycraft.core.content.recipe.IRecipeWithStage;
import tv.soaryn.xycraft.core.content.recipe.RecipeContent;
import tv.soaryn.xycraft.core.content.recipe.RecipeSerDes;
import tv.soaryn.xycraft.core.content.stages.IXyStage;
import tv.soaryn.xycraft.core.utils.serialization.BinarySerializer;
import tv.soaryn.xycraft.core.utils.serialization.CodecUtils;
import tv.soaryn.xycraft.core.utils.serialization.Serializer;
import tv.soaryn.xycraft.machines.content.blocks.properties.IOMode;
import tv.soaryn.xycraft.machines.content.registries.MachinesRecipeTypes;

public record CentrifugeRecipe(Either<SizedFluidIngredient, SizedIngredient> input, Either<FluidStack, ItemStack> outputA, Optional<Either<FluidStack, ItemStack>> outputB, long ticks, Optional<IStage> requiredStage) implements IRecipeContent<Input, CentrifugeRecipe>,
IRecipeWithStage
{
    private static final MapCodec<CentrifugeRecipe> codec = RecordCodecBuilder.mapCodec(builder -> builder.group((App)CodecUtils.Codecs.ContentObjectIngredient.fieldOf("input").forGetter(CentrifugeRecipe::input), (App)CodecUtils.Codecs.ContentObject.fieldOf("output_a").forGetter(CentrifugeRecipe::outputA), (App)CodecUtils.Codecs.ContentObject.optionalFieldOf("output_b").forGetter(CentrifugeRecipe::outputB), (App)Codec.LONG.fieldOf("ticks").forGetter(CentrifugeRecipe::ticks), (App)IXyStage.CODEC.optionalFieldOf("stage_required").forGetter(CentrifugeRecipe::requiredStage)).apply((Applicative)builder, CentrifugeRecipe::new));
    private static final BinarySerializer<CentrifugeRecipe> SerDes = BinarySerializer.ofType(CentrifugeRecipe::new, CentrifugeRecipe::input, (BinarySerializer)RecipeSerDes.InputObjectSerDes, CentrifugeRecipe::outputA, (BinarySerializer)RecipeSerDes.OutputObjectSerDes, CentrifugeRecipe::outputB, (BinarySerializer)BinarySerializer.optionalOf((BinarySerializer)RecipeSerDes.OutputObjectSerDes), CentrifugeRecipe::ticks, (BinarySerializer)Serializer.LONG, CentrifugeRecipe::requiredStage, (BinarySerializer)BinarySerializer.optionalOf((BinarySerializer)IXyStage.SerDes));

    public static RecipeSerDes<CentrifugeRecipe> register() {
        return RecipeSerDes.create(codec, SerDes);
    }

    public RecipeContent<CentrifugeRecipe> getContent() {
        return MachinesRecipeTypes.Centrifuge;
    }

    public IOMode inputMode() {
        return this.input.left().isPresent() ? IOMode.Fluid : IOMode.Item;
    }

    public IOMode outputModeA() {
        return this.outputA.left().isPresent() ? IOMode.Fluid : IOMode.Item;
    }

    public IOMode outputModeB() {
        return this.outputB.map(fluidStackItemStackEither -> fluidStackItemStackEither.left().isPresent() ? IOMode.Fluid : IOMode.Item).orElse(IOMode.Empty);
    }

    public boolean matches(@NotNull Input input, @NotNull Level level) {
        return (Boolean)this.input.map(left -> left.test(input.getInputFluid()), right -> right.test(input.getInputItem()));
    }

    public Optional<IStage> getRequiredStage() {
        return this.requiredStage();
    }

    public static interface Input
    extends IRecipeContainer {
        public ItemStack getInputItem();

        public FluidStack getInputFluid();
    }
}

