/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.command;

import com.brandon3055.brandonscore.worldentity.WorldEntity;
import com.brandon3055.brandonscore.worldentity.WorldEntityHandler;
import com.brandon3055.draconicevolution.blocks.tileentity.TileChaosCrystal;
import com.brandon3055.draconicevolution.entity.guardian.GuardianFightManager;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;

public class CommandRespawnGuardian {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"respawn_draconic_guardian").requires(cs -> cs.hasPermission(2))).executes(context -> CommandRespawnGuardian.respawn((CommandContext<CommandSourceStack>)context, false)));
    }

    private static int respawn(CommandContext<CommandSourceStack> ctx, boolean spawnHere) throws CommandSyntaxException {
        if (spawnHere) {
            return CommandRespawnGuardian.spawnHere(ctx);
        }
        Vec3 pos = ((CommandSourceStack)ctx.getSource()).getPosition();
        TileChaosCrystal tile = BlockPos.betweenClosedStream((BlockPos)BlockPos.containing((Position)pos).offset(-60, -60, -60), (BlockPos)BlockPos.containing((Position)pos).offset(60, 60, 60)).filter(e -> ((CommandSourceStack)ctx.getSource()).getLevel().getBlockEntity(e) instanceof TileChaosCrystal).map(e -> (TileChaosCrystal)((CommandSourceStack)ctx.getSource()).getLevel().getBlockEntity(e)).findAny().orElse(null);
        if (tile == null) {
            throw new SimpleCommandExceptionType((Message)Component.literal((String)"Chaos crystal not detected! Please run this command within 60 blocks of an islands chaos crystal.")).create();
        }
        if (tile.parentPos.notNull()) {
            BlockEntity parent = tile.getLevel().getBlockEntity(tile.parentPos.get());
            if (parent instanceof TileChaosCrystal) {
                tile = (TileChaosCrystal)parent;
            } else {
                throw new SimpleCommandExceptionType((Message)Component.literal((String)"Found invalid chaos crystal at this location")).create();
            }
        }
        TileChaosCrystal finalTile = tile;
        GuardianFightManager existingFight = WorldEntityHandler.getWorldEntities().stream().filter(e -> e instanceof GuardianFightManager).map(e -> (GuardianFightManager)((Object)e)).filter(e -> e.getArenaOrigin().equals((Object)finalTile.getBlockPos())).findAny().orElse(null);
        if (existingFight != null) {
            throw new SimpleCommandExceptionType((Message)Component.literal((String)"There should already be a guardian in this area")).create();
        }
        tile.guardianDefeated.set(false);
        WorldEntityHandler.addWorldEntity((Level)tile.getLevel(), (WorldEntity)new GuardianFightManager(tile.getBlockPos()));
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"Reset Successful. Go to center of island to trigger spawning sequence.").withStyle(ChatFormatting.GREEN), true);
        return 0;
    }

    private static int spawnHere(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        return 0;
    }
}

