/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.modules.entities.logic;

import com.brandon3055.brandonscore.api.power.IOPStorage;
import com.brandon3055.brandonscore.inventory.InventoryDynamic;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.api.modules.entities.logic.IHarvestHandler;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.PriorityQueue;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class ForestHarvestHandler
implements IHarvestHandler {
    private final int speed;
    private final int range;
    private final boolean harvestLeaves;
    private BlockPos origin;
    private PriorityQueue<Pos> sortedHarvestQue = new PriorityQueue();
    private LinkedList<Long> searchQue = new LinkedList();
    private Set<Long> processedBlocks = new HashSet<Long>();
    private Set<Long> searchedXZPositions = new HashSet<Long>();
    private boolean complete = false;
    private BlockPos.MutableBlockPos mPos = new BlockPos.MutableBlockPos();

    public ForestHarvestHandler(int speed, int range, boolean leaves) {
        this.speed = speed;
        this.range = range;
        this.harvestLeaves = leaves;
    }

    @Override
    public boolean start(BlockPos origin, Level level, ServerPlayer player) {
        BlockState state = level.getBlockState(origin);
        if (!this.canSearchUnder(state)) {
            return false;
        }
        int i = 0;
        do {
            if (i++ > 80) {
                return false;
            }
            if ((origin = origin.below()).getY() >= level.getMinBuildHeight()) continue;
            return false;
        } while (!this.canSearchThrough(state = level.getBlockState(origin)) || this.isHarvestable(state));
        if (!this.canSearchUnder(level.getBlockState(origin.above()))) {
            return false;
        }
        this.searchQue.add(origin.asLong());
        this.origin = origin.immutable();
        return true;
    }

    @Override
    public void tick(Level level, ServerPlayer player, ItemStack stack, IOPStorage storage, InventoryDynamic stackCollector) {
        int i;
        if (this.origin == null || this.complete || level.isClientSide) {
            return;
        }
        if (!this.sortedHarvestQue.isEmpty()) {
            for (i = 0; i < this.speed && !this.sortedHarvestQue.isEmpty(); ++i) {
                this.updateHarvest(level, (Player)player, stack, storage, stackCollector);
            }
        }
        if (!this.searchQue.isEmpty()) {
            for (i = 0; i < this.speed * 4 && !this.searchQue.isEmpty(); ++i) {
                this.updateSearch(level, (Player)player);
            }
        }
        if (!this.sortedHarvestQue.isEmpty() || !this.searchQue.isEmpty()) {
            return;
        }
        this.complete = true;
        player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.PLAYERS, 0.1f, 0.5f * ((player.level().random.nextFloat() - player.level().random.nextFloat()) * 0.7f + 1.8f));
    }

    private void updateSearch(Level level, Player player) {
        this.mPos.set(this.searchQue.removeFirst().longValue());
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if ((double)level.random.nextFloat() < 0.1) {
                serverLevel.sendParticles((ServerPlayer)player, (ParticleOptions)ParticleTypes.CLOUD, true, (double)this.mPos.getX() + 0.5, (double)this.mPos.getY() + 1.5, (double)this.mPos.getZ() + 0.5, 1, 0.0, 0.0, 0.0, 0.1);
            }
        }
        Utils.hollowCube((BlockPos)this.mPos.offset(-1, -1, -1), (BlockPos)this.mPos.offset(1, 1, 1), pos -> {
            long longXZPos = BlockPos.asLong((int)pos.getX(), (int)0, (int)pos.getZ());
            if (this.searchedXZPositions.contains(longXZPos)) {
                return;
            }
            long longPos = pos.asLong();
            if (this.origin.distSqr((Vec3i)pos) > (double)(this.range * this.range)) {
                this.searchedXZPositions.add(longXZPos);
                this.processedBlocks.add(longPos);
                return;
            }
            BlockState state = level.getBlockState(pos);
            if (this.isHarvestable(state)) {
                this.searchedXZPositions.add(longXZPos);
                this.queHarvest(level, (BlockPos)pos);
                return;
            }
            BlockState aboveState = level.getBlockState(pos.above());
            if (this.canSearchThrough(state) && this.canSearchUnder(aboveState)) {
                this.searchedXZPositions.add(longXZPos);
                this.searchQue.add(pos.asLong());
                if (this.isHarvestable(aboveState)) {
                    this.queHarvest(level, pos.above());
                }
            }
            this.processedBlocks.add(longPos);
        });
    }

    private void updateHarvest(Level level, Player player, ItemStack stack, IOPStorage storage, InventoryDynamic stackCollector) {
        Pos next = this.sortedHarvestQue.poll();
        if (next == null) {
            return;
        }
        this.mPos.set(next.pos);
        this.doHarvest(stack, player, level, this.mPos.immutable(), storage, stackCollector);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if ((double)level.random.nextFloat() < 0.1) {
                serverLevel.sendParticles((ServerPlayer)player, (ParticleOptions)ParticleTypes.FLAME, true, (double)this.mPos.getX() + 0.5, (double)this.mPos.getY() + 0.5, (double)this.mPos.getZ() + 0.5, 1, 0.0, 0.0, 0.0, 0.1);
            }
        }
        Utils.hollowCube((BlockPos)this.mPos.offset(-1, -1, -1), (BlockPos)this.mPos.offset(1, 1, 1), pos -> {
            long longPos = pos.asLong();
            if (this.processedBlocks.contains(longPos)) {
                return;
            }
            this.processedBlocks.add(longPos);
            if (this.origin.distSqr((Vec3i)pos) > (double)(this.range * this.range)) {
                return;
            }
            BlockState state = level.getBlockState(pos);
            if (this.isHarvestable(state)) {
                this.queHarvest(level, (BlockPos)pos);
            }
        });
    }

    private void queHarvest(Level level, BlockPos pos) {
        this.sortedHarvestQue.add(new Pos(pos.asLong(), (int)Utils.getDistanceSq((double)pos.getX(), (double)pos.getZ(), (double)this.origin.getX(), (double)this.origin.getZ()) + level.random.nextInt(16)));
    }

    @Override
    public boolean isDone() {
        return false;
    }

    @Override
    public void stop(Level level, ServerPlayer player) {
    }

    private boolean canSearchThrough(BlockState state) {
        return !state.isAir() && !state.is(BlockTags.REPLACEABLE) && !state.is(BlockTags.FLOWERS) && !state.is(BlockTags.LOGS) && !state.is(BlockTags.LEAVES) && state.getFluidState().isEmpty();
    }

    private boolean canSearchUnder(BlockState state) {
        return (state.isAir() || state.is(BlockTags.REPLACEABLE) || state.is(BlockTags.FLOWERS) || state.is(BlockTags.LOGS) || state.is(BlockTags.LEAVES)) && state.getFluidState().isEmpty();
    }

    private boolean isHarvestable(BlockState state) {
        return state.is(BlockTags.LOGS) || this.harvestLeaves && state.is(BlockTags.LEAVES);
    }

    private record Pos(long pos, int distance) implements Comparable<Pos>
    {
        @Override
        public int compareTo(@NotNull Pos o) {
            return Integer.compare(this.distance, o.distance);
        }
    }
}

