/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.crafting;

import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.draconicevolution.api.DraconicAPI;
import com.brandon3055.draconicevolution.api.crafting.IFusionDataTransfer;
import com.brandon3055.draconicevolution.api.crafting.IFusionInventory;
import com.brandon3055.draconicevolution.api.crafting.IFusionRecipe;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;

public class FusionRecipe
implements IFusionRecipe {
    private final ItemStack result;
    private final Ingredient catalyst;
    private final long totalEnergy;
    private final TechLevel techLevel;
    private final List<FusionIngredient> ingredients;

    public FusionRecipe(ItemStack result, Ingredient catalyst, long totalEnergy, TechLevel techLevel, List<FusionIngredient> ingredients) {
        this.result = result;
        this.catalyst = catalyst;
        this.totalEnergy = totalEnergy;
        this.techLevel = techLevel;
        this.ingredients = ingredients;
    }

    @Override
    public TechLevel getRecipeTier() {
        return this.techLevel;
    }

    @Override
    public long getEnergyCost() {
        return this.totalEnergy;
    }

    @Override
    public NonNullList<Ingredient> getIngredients() {
        return this.ingredients.stream().map(fusionIngredient -> fusionIngredient.ingredient).collect(Collectors.toCollection(NonNullList::create));
    }

    @Override
    public List<IFusionRecipe.IFusionIngredient> fusionIngredients() {
        return ImmutableList.copyOf(this.ingredients);
    }

    @Override
    public Ingredient getCatalyst() {
        return this.catalyst;
    }

    public ItemStack assemble(IFusionInventory inv, HolderLookup.Provider provider) {
        ItemStack stack = this.result.copy();
        if (stack.getItem() instanceof IFusionDataTransfer) {
            ((IFusionDataTransfer)stack.getItem()).transferIngredientData(stack, inv, provider);
        }
        return stack;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.result;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)DraconicAPI.FUSION_RECIPE_SERIALIZER.get();
    }

    public static class FusionIngredient
    implements IFusionRecipe.IFusionIngredient {
        private static final Codec<FusionIngredient> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(e -> e.ingredient), (App)Codec.BOOL.fieldOf("consume").forGetter(e -> e.consume)).apply((Applicative)builder, FusionIngredient::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, FusionIngredient> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, e -> e.ingredient, (StreamCodec)ByteBufCodecs.BOOL, e -> e.consume, FusionIngredient::new);
        private final Ingredient ingredient;
        private final boolean consume;

        public FusionIngredient(Ingredient ingredient, boolean consume) {
            this.ingredient = ingredient;
            this.consume = consume;
        }

        @Override
        public Ingredient get() {
            return this.ingredient;
        }

        @Override
        public boolean consume() {
            return this.consume;
        }
    }

    public static class Serializer
    implements RecipeSerializer<FusionRecipe> {
        private static final MapCodec<FusionRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)ItemStack.CODEC.fieldOf("result").forGetter(e -> e.result), (App)Ingredient.CODEC_NONEMPTY.fieldOf("catalyst").forGetter(e -> e.catalyst), (App)Codec.LONG.fieldOf("totalEnergy").forGetter(e -> e.totalEnergy), (App)TechLevel.CODEC.fieldOf("techLevel").forGetter(e -> e.techLevel), (App)Codec.list(FusionIngredient.CODEC).fieldOf("ingredients").forGetter(e -> e.ingredients)).apply((Applicative)builder, FusionRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, FusionRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<FusionRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, FusionRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static FusionRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            ItemStack result = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            Ingredient catalyst = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            int count = buffer.readByte();
            ArrayList<FusionIngredient> fusionIngredients = new ArrayList<FusionIngredient>();
            for (int i = 0; i < count; ++i) {
                fusionIngredients.add((FusionIngredient)FusionIngredient.STREAM_CODEC.decode((Object)buffer));
            }
            long totalEnergy = buffer.readLong();
            TechLevel techLevel = TechLevel.VALUES[Mth.clamp((int)buffer.readByte(), (int)0, (int)(TechLevel.values().length - 1))];
            return new FusionRecipe(result, catalyst, totalEnergy, techLevel, fusionIngredients);
        }

        private static void toNetwork(RegistryFriendlyByteBuf buffer, FusionRecipe recipe) {
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.result);
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.catalyst);
            buffer.writeByte(recipe.ingredients.size());
            for (FusionIngredient ingredient : recipe.ingredients) {
                FusionIngredient.STREAM_CODEC.encode((Object)buffer, (Object)ingredient);
            }
            buffer.writeLong(recipe.totalEnergy);
            buffer.writeByte(recipe.techLevel.index);
        }
    }
}

