/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.config;

import com.brandon3055.draconicevolution.api.config.ConfigProperty;
import com.brandon3055.draconicevolution.client.gui.modular.itemconfig.PropertyData;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;

public class BooleanProperty
extends ConfigProperty {
    private boolean value;
    private boolean defaultValue;
    private ConfigProperty.BooleanFormatter formatter = ConfigProperty.BooleanFormatter.TRUE_FALSE;
    private BiConsumer<ItemStack, BooleanProperty> changeListener;
    public static final Codec<BooleanProperty> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.STRING.fieldOf("name").forGetter(e -> e.name), (App)Codec.BOOL.fieldOf("show_on_hud").forGetter(e -> e.showOnHud), (App)UUIDUtil.CODEC.optionalFieldOf("unique_name").forGetter(ConfigProperty::getOptionalUniqueName), (App)Codec.BOOL.fieldOf("value").forGetter(e -> e.value), (App)Codec.BOOL.fieldOf("default_value").forGetter(e -> e.defaultValue), (App)ConfigProperty.BooleanFormatter.CODEC.fieldOf("formatter").forGetter(e -> e.formatter)).apply((Applicative)builder, BooleanProperty::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, BooleanProperty> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, e -> e.name, (StreamCodec)ByteBufCodecs.BOOL, e -> e.showOnHud, (StreamCodec)ByteBufCodecs.optional((StreamCodec)UUIDUtil.STREAM_CODEC), ConfigProperty::getOptionalUniqueName, (StreamCodec)ByteBufCodecs.BOOL, e -> e.value, (StreamCodec)ByteBufCodecs.BOOL, e -> e.defaultValue, ConfigProperty.BooleanFormatter.STREAM_CODEC, e -> e.formatter, BooleanProperty::new);

    public BooleanProperty(String name, boolean defaultValue) {
        super(name);
        this.value = this.defaultValue = defaultValue;
    }

    public BooleanProperty(String name, Component displayName, boolean defaultValue) {
        super(name, displayName);
        this.value = this.defaultValue = defaultValue;
    }

    BooleanProperty(String name, boolean showOnHud, Optional<UUID> uniqueName, boolean value, boolean defaultValue, ConfigProperty.BooleanFormatter formatter) {
        super(name, showOnHud, uniqueName);
        this.value = value;
        this.defaultValue = defaultValue;
        this.formatter = formatter;
    }

    @Override
    public BooleanProperty copy() {
        return new BooleanProperty(this.name, this.showOnHud, Optional.ofNullable(this.uniqueName), this.value, this.defaultValue, this.formatter);
    }

    public boolean getValue() {
        return this.value;
    }

    public void setValue(boolean value) {
        this.value = value;
    }

    @Override
    public String getDisplayValue() {
        return this.formatter.format(this.getValue());
    }

    public BooleanProperty setFormatter(ConfigProperty.BooleanFormatter formatter) {
        this.formatter = formatter;
        return this;
    }

    public ConfigProperty.BooleanFormatter getFormatter() {
        return this.formatter;
    }

    @Override
    public void onValueChanged(ItemStack stack) {
        if (this.provider != null) {
            this.provider.markDirty();
        }
        if (this.changeListener != null) {
            this.changeListener.accept(stack, this);
        }
    }

    @Override
    public void validateValue() {
    }

    @Override
    public ConfigProperty.Type getType() {
        return ConfigProperty.Type.BOOLEAN;
    }

    public BooleanProperty setChangeListener(Runnable changeListener) {
        this.changeListener = (stack, t) -> changeListener.run();
        return this;
    }

    public BooleanProperty setChangeListener(Consumer<ItemStack> changeListener) {
        this.changeListener = (stack, booleanProperty) -> changeListener.accept((ItemStack)stack);
        return this;
    }

    public BooleanProperty setChangeListener(BiConsumer<ItemStack, BooleanProperty> changeListener) {
        this.changeListener = changeListener;
        return this;
    }

    @Override
    public void loadData(PropertyData data, ItemStack stack) {
        this.value = data.booleanValue;
        this.onValueChanged(stack);
    }

    public String toString() {
        return "BooleanProperty{value=" + this.value + "}";
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof BooleanProperty)) {
            return false;
        }
        BooleanProperty that = (BooleanProperty)o;
        if (!super.equals(o)) {
            return false;
        }
        return this.value == that.value && this.defaultValue == that.defaultValue && this.formatter == that.formatter;
    }

    @Override
    public boolean equalsWOValue(Object o) {
        if (!(o instanceof BooleanProperty)) {
            return false;
        }
        BooleanProperty that = (BooleanProperty)o;
        if (!super.equals(o)) {
            return false;
        }
        return this.defaultValue == that.defaultValue && this.formatter == that.formatter;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.value, this.defaultValue, this.formatter});
    }
}

