/*
 * Decompiled with CFR 0.152.
 */
package edivad.dimstorage.network.to_server;

import edivad.dimstorage.DimStorage;
import edivad.dimstorage.api.Frequency;
import edivad.dimstorage.blockentities.BlockEntityDimChest;
import edivad.dimstorage.setup.Registration;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record UpdateDimChest(BlockPos pos, Frequency freq, boolean locked) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<UpdateDimChest> TYPE = new CustomPacketPayload.Type(DimStorage.rl("update_dim_chest"));
    public static final StreamCodec<RegistryFriendlyByteBuf, UpdateDimChest> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, UpdateDimChest::pos, Frequency.STREAM_CODEC, UpdateDimChest::freq, (StreamCodec)ByteBufCodecs.BOOL, UpdateDimChest::locked, UpdateDimChest::new);

    public UpdateDimChest(BlockEntityDimChest tank) {
        this(tank.getBlockPos(), tank.getFrequency(), tank.locked);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(UpdateDimChest message, IPayloadContext ctx) {
        Player player = ctx.player();
        Level level = player.level();
        level.getBlockEntity(message.pos, (BlockEntityType)Registration.DIMCHEST_TILE.get()).ifPresent(chest -> {
            chest.setFrequency(message.freq);
            chest.locked = message.locked;
            chest.setChanged();
            level.sendBlockUpdated(message.pos, chest.getBlockState(), chest.getBlockState(), 3);
            player.openMenu((MenuProvider)chest, buf -> buf.writeBlockPos(message.pos).writeBoolean(true));
        });
    }
}

